/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.definition;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.definition.ThemeDefinitionElement;
import org.eclipse.e4.ui.css.swt.helpers.ThemeElementDefinitionHelper;
import org.eclipse.e4.ui.css.swt.helpers.URI;
import org.eclipse.e4.ui.internal.css.swt.definition.IThemeElementDefinitionOverridable;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyThemeElementDefinitionHandler
implements ICSSPropertyHandler {
    private static final String CATEGORY_PROP = "category";
    private static final String LABEL_PROP = "label";
    private static final String DESCRIPTION_PROP = "description";
    private static final String MESSAGE_QUERY_PARAM = "message";
    private Map<Long, ResourceBundle> bundleToResourceBundles = new WeakHashMap<Long, ResourceBundle>();

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(element instanceof ThemeDefinitionElement)) {
            return false;
        }
        IThemeElementDefinitionOverridable definition = (IThemeElementDefinitionOverridable)((ThemeDefinitionElement)((Object)element)).getNativeWidget();
        if (CATEGORY_PROP.equals(property)) {
            definition.setCategoryId(ThemeElementDefinitionHelper.normalizeId(value.getCssText().substring(1)));
        } else if (LABEL_PROP.equals(property)) {
            definition.setName(this.getLabel(value));
        } else if (DESCRIPTION_PROP.equals(property)) {
            definition.setDescription(this.getLabel(value));
        }
        return true;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    private String getLabel(CSSValue value) {
        String messageId;
        URL resourceBundleURL = this.getResourceBundleURL(value);
        if (resourceBundleURL != null && (messageId = this.getMessageId(resourceBundleURL)) != null) {
            String message;
            ResourceBundle resourceBundle = this.getResourceBundle(resourceBundleURL);
            String string = message = resourceBundle != null ? resourceBundle.getString(messageId) : null;
            if (message != null) {
                return resourceBundle.getString(messageId);
            }
        }
        return value.getCssText();
    }

    private String getMessageId(URL resourceBundleURL) {
        int indexOfMessageParam;
        String query = resourceBundleURL.getQuery();
        if (query != null && (indexOfMessageParam = query.indexOf(MESSAGE_QUERY_PARAM)) != -1) {
            return query.substring(indexOfMessageParam + MESSAGE_QUERY_PARAM.length() + 1);
        }
        return null;
    }

    private Bundle getBundle(URI uri) throws BundleException {
        Bundle bundle = Platform.getBundle((String)uri.lastSegment());
        if (bundle != null && (bundle.getState() & 0x20) == 0) {
            bundle.start();
        }
        return bundle;
    }

    private ResourceBundle getResourceBundle(URL resourceBundleURL) {
        ResourceBundle resourceBundle = null;
        try {
            URI uri = URI.createURI(resourceBundleURL.getPath());
            if (uri != null) {
                resourceBundle = this.getResourceBundle(this.getBundle(uri));
            }
        }
        catch (Exception exception) {}
        return resourceBundle;
    }

    private ResourceBundle getResourceBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        ResourceBundle resourceBundle = this.bundleToResourceBundles.get(bundle.getBundleId());
        if (resourceBundle != null) {
            return resourceBundle;
        }
        BundleLocalization localization = this.getBundleLocalization(bundle);
        if (localization != null) {
            resourceBundle = localization.getLocalization(bundle, null);
        }
        if (resourceBundle != null) {
            this.bundleToResourceBundles.put(bundle.getBundleId(), resourceBundle);
        }
        return resourceBundle;
    }

    private BundleLocalization getBundleLocalization(Bundle bundle) {
        ServiceReference ref = bundle.getBundleContext().getServiceReference(BundleLocalization.class);
        return (BundleLocalization)bundle.getBundleContext().getService(ref);
    }

    private URL getResourceBundleURL(CSSValue value) {
        URL url = null;
        if (this.hasResourceBundleUrl(value)) {
            try {
                url = new URL(((CSSPrimitiveValue)value).getStringValue());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return url;
    }

    private boolean hasResourceBundleUrl(CSSValue value) {
        return value.getCssValueType() == 1 && ((CSSPrimitiveValue)value).getPrimitiveType() == 20;
    }
}

