/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.maven.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.oomph.resources.DynamicMavenProjectFactory;
import org.eclipse.oomph.resources.MavenProjectFactory;
import org.eclipse.oomph.resources.ProjectFactory;
import org.eclipse.oomph.resources.ResourcesFactory;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.backend.BackendResource;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.maven.MavenImportTask;
import org.eclipse.oomph.setup.maven.MavenPackage;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;

public class MavenImportTaskImpl
extends SetupTaskImpl
implements MavenImportTask {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    protected EList<SourceLocator> sourceLocators;
    protected static final String PROJECT_NAME_TEMPLATE_EDEFAULT = null;
    protected String projectNameTemplate = PROJECT_NAME_TEMPLATE_EDEFAULT;
    protected EList<String> profiles;

    protected MavenImportTaskImpl() {
    }

    protected EClass eStaticClass() {
        return MavenPackage.Literals.MAVEN_IMPORT_TASK;
    }

    @Override
    public EList<SourceLocator> getSourceLocators() {
        if (this.sourceLocators == null) {
            this.sourceLocators = new EObjectContainmentEList(SourceLocator.class, (InternalEObject)this, 10);
        }
        return this.sourceLocators;
    }

    @Override
    public String getProjectNameTemplate() {
        return this.projectNameTemplate;
    }

    @Override
    public void setProjectNameTemplate(String newProjectNameTemplate) {
        String oldProjectNameTemplate = this.projectNameTemplate;
        this.projectNameTemplate = newProjectNameTemplate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldProjectNameTemplate, (Object)this.projectNameTemplate));
        }
    }

    @Override
    public EList<String> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 12);
        }
        return this.profiles;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return ((InternalEList)this.getSourceLocators()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getSourceLocators();
            }
            case 11: {
                return this.getProjectNameTemplate();
            }
            case 12: {
                return this.getProfiles();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.getSourceLocators().clear();
                this.getSourceLocators().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setProjectNameTemplate((String)newValue);
                return;
            }
            case 12: {
                this.getProfiles().clear();
                this.getProfiles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.getSourceLocators().clear();
                return;
            }
            case 11: {
                this.setProjectNameTemplate(PROJECT_NAME_TEMPLATE_EDEFAULT);
                return;
            }
            case 12: {
                this.getProfiles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.sourceLocators != null && !this.sourceLocators.isEmpty();
            }
            case 11: {
                return PROJECT_NAME_TEMPLATE_EDEFAULT == null ? this.projectNameTemplate != null : !PROJECT_NAME_TEMPLATE_EDEFAULT.equals(this.projectNameTemplate);
            }
            case 12: {
                return this.profiles != null && !this.profiles.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (projectNameTemplate: ");
        result.append(this.projectNameTemplate);
        result.append(", profiles: ");
        result.append(this.profiles);
        result.append(')');
        return result.toString();
    }

    public int getProgressMonitorWork() {
        return 100;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        EList<SourceLocator> sourceLocators = this.getSourceLocators();
        if (sourceLocators.isEmpty()) {
            return false;
        }
        if (context.getTrigger() != Trigger.MANUAL) {
            IProject[] iProjectArray = ROOT.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IPath projectFolder = project.getLocation();
                for (SourceLocator sourceLocator : sourceLocators) {
                    Path rootFolder = new Path(sourceLocator.getRootFolder());
                    if (!rootFolder.isPrefixOf(projectFolder)) continue;
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void perform(SetupTaskContext context) throws Exception {
        EList<SourceLocator> sourceLocators = this.getSourceLocators();
        int size = sourceLocators.size();
        IProgressMonitor monitor = context.getProgressMonitor(true);
        monitor.beginTask("", 2 * size);
        try {
            MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
            LinkedHashSet<MavenProjectInfo> projectInfos = new LinkedHashSet<MavenProjectInfo>();
            for (SourceLocator sourceLocator : sourceLocators) {
                LocalProjectScanner projectScanner = this.createLocalProjectScanner(Collections.singletonList(sourceLocator.getRootFolder()), modelManager);
                this.processMavenProject(sourceLocator, projectInfos, projectScanner, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
            }
            if (projectInfos.isEmpty()) {
                monitor.worked(size);
            } else {
                EList<String> profiles;
                IProjectConfigurationManager projectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
                ProjectImportConfiguration projectImportConfiguration = new ProjectImportConfiguration();
                String projectNameTemplate = this.getProjectNameTemplate();
                if (!StringUtil.isEmpty((String)projectNameTemplate)) {
                    projectImportConfiguration.setProjectNameTemplate(projectNameTemplate);
                }
                if (!(profiles = this.getProfiles()).isEmpty()) {
                    for (MavenProjectInfo mavenProjectInfo : projectInfos) {
                        mavenProjectInfo.addProfiles(profiles);
                    }
                }
                projectConfigurationManager.importProjects(projectInfos, projectImportConfiguration, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)size));
            }
        }
        finally {
            monitor.done();
        }
    }

    private LocalProjectScanner createLocalProjectScanner(List<String> folders, MavenModelManager modelManager) {
        try {
            Constructor constructor = ReflectUtil.getConstructor(LocalProjectScanner.class, (Class[])new Class[]{File.class, List.class, Boolean.TYPE, MavenModelManager.class});
            return (LocalProjectScanner)constructor.newInstance(null, folders, false, modelManager);
        }
        catch (Exception ex) {
            return new LocalProjectScanner(folders, false, modelManager);
        }
    }

    private void processMavenProject(SourceLocator sourceLocator, Set<MavenProjectInfo> projectInfos, LocalProjectScanner projectScanner, IProgressMonitor monitor) throws InterruptedException {
        monitor.beginTask("", 2);
        try {
            projectScanner.run((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
            List projects = projectScanner.getProjects();
            this.processMavenProject(sourceLocator, projectInfos, projects, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
        }
        finally {
            monitor.done();
        }
    }

    private void processMavenProject(SourceLocator sourceLocator, Set<MavenProjectInfo> projectInfos, List<MavenProjectInfo> projects, IProgressMonitor monitor) {
        monitor.beginTask("", projects.size());
        try {
            for (MavenProjectInfo projectInfo : projects) {
                MavenImportTaskImpl.processMavenProject(sourceLocator, projectInfos, projectInfo, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void processMavenProject(SourceLocator sourceLocator, Set<MavenProjectInfo> projectInfos, MavenProjectInfo projectInfo, IProgressMonitor monitor) {
        monitor.beginTask("", 6);
        try {
            String projectName;
            IProject project;
            String projectFolder = projectInfo.getPomFile().getParent();
            BackendContainer backendContainer = (BackendContainer)BackendResource.get((String)projectFolder);
            BasicEList factories = new BasicEList((Collection)MavenProjectFactory.LIST);
            if (!projectInfo.getPomFile().getName().equals("pom.xml")) {
                DynamicMavenProjectFactory altFactory = ResourcesFactory.eINSTANCE.createDynamicMavenProjectFactory();
                altFactory.setXMLFileName(projectInfo.getPomFile().getName());
                altFactory.getExcludedPaths().addAll((Collection)((ProjectFactory)factories.get(0)).getExcludedPaths());
                factories.add((Object)altFactory);
            }
            if ((project = sourceLocator.loadProject((EList)factories, backendContainer, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1))) != null && sourceLocator.matches(project) && !ROOT.getProject(projectName = project.getName()).exists()) {
                projectInfos.add(projectInfo);
            }
            if (sourceLocator.isLocateNestedProjects()) {
                Collection projects = projectInfo.getProjects();
                MavenImportTaskImpl.processMavenProject(sourceLocator, projectInfos, projects, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)5));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void processMavenProject(SourceLocator sourceLocator, Set<MavenProjectInfo> projectInfos, Collection<MavenProjectInfo> projects, IProgressMonitor monitor) {
        monitor.beginTask("", projects.size());
        try {
            for (MavenProjectInfo childProjectInfo : projects) {
                MavenImportTaskImpl.processMavenProject(sourceLocator, projectInfos, childProjectInfo, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
            }
        }
        finally {
            monitor.done();
        }
    }
}

