/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.dom;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringListValueStyle;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.SemanticElementHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.listener.CustomStyleListener;
import org.eclipse.papyrus.infra.gmfdiag.common.types.NotationTypesMap;
import org.eclipse.papyrus.infra.gmfdiag.css.dom.StyleListener;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.CSSDOMSemanticElementHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.StatefulView;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GMFElementAdapter
extends ElementAdapter
implements NodeList,
IChangeListener,
StatefulView,
IAdaptable {
    public static final String EMPTY_VALUE = " ";
    protected static final String KIND = "kind";
    public static final String CSS_VALUES_SEPARATOR = " ";
    public CSSDOMSemanticElementHelper helper;
    protected EObject semanticElement;
    protected View notationElement;
    protected String namespaceURI;
    protected String localName;
    protected Node[] children;
    protected Node parentNode;
    protected Adapter styleListener;
    protected CustomStyleListener cssStyleListener;
    private final Set<StringIgnoreCase> pseudoInstances = new HashSet<StringIgnoreCase>();

    public static String getCSSID(EObject sourceElement) {
        return GMFElementAdapter.getCSSValue(sourceElement, "cssId");
    }

    public static String getCSSClass(EObject sourceElement) {
        List<String> allClasses = GMFElementAdapter.getCSSValues(sourceElement, "cssClass");
        return ListHelper.deepToString(allClasses, (String)" ");
    }

    public static String getCSSStyle(EObject sourceElement) {
        return GMFElementAdapter.getCSSValue(sourceElement, "cssStyle");
    }

    private static String getCSSValue(EObject sourceElement, String key) {
        StringValueStyle style = (StringValueStyle)GMFElementAdapter.findStyle(sourceElement, key, NotationPackage.eINSTANCE.getStringValueStyle());
        if (style == null) {
            return null;
        }
        return style.getStringValue();
    }

    private static List<String> getCSSValues(EObject sourceElement, String key) {
        StringListValueStyle style = (StringListValueStyle)GMFElementAdapter.findStyle(sourceElement, key, NotationPackage.eINSTANCE.getStringListValueStyle());
        if (style == null) {
            return Collections.emptyList();
        }
        return style.getStringListValue();
    }

    private static NamedStyle findStyle(EObject sourceElement, String key, EClass type) {
        View view = GMFElementAdapter.findView(sourceElement);
        if (view == null) {
            return null;
        }
        return view.getNamedStyle(type, key);
    }

    private static View findView(EObject sourceElement) {
        if (sourceElement == null) {
            return null;
        }
        if (sourceElement instanceof View) {
            return (View)sourceElement;
        }
        return GMFElementAdapter.findView(sourceElement.eContainer());
    }

    public GMFElementAdapter(View view, ExtendedCSSEngine engine) {
        super((Object)view, (CSSEngine)engine);
        if (view == null || view.getDiagram() == null) {
            throw new IllegalArgumentException("Cannot handle orphaned view : " + view);
        }
        this.notationElement = view;
        this.helper = CSSDOMSemanticElementHelper.getInstance();
        this.listenNotationElement();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Diagram.class) {
            return this.getNotationElement().getDiagram();
        }
        return null;
    }

    public EObject getSemanticElement() {
        if (this.semanticElement == null) {
            this.semanticElement = this.helper.findSemanticElement((EObject)this.notationElement);
            this.computePseudoInstances();
            this.listenSemanticElement();
        }
        return this.semanticElement;
    }

    private void computePseudoInstances() {
        if (this.helper.isFloatingLabel((EObject)this.notationElement)) {
            String humanType = NotationTypesMap.instance.getHumanReadableType(this.notationElement);
            if (humanType == null) {
                humanType = this.notationElement.getType();
            }
            this.pseudoInstances.add(new StringIgnoreCase(humanType));
        }
    }

    private Adapter getStyleListener() {
        if (this.styleListener == null) {
            this.styleListener = new StyleListener(this);
        }
        return this.styleListener;
    }

    private void listenNotationElement() {
        this.notationElement.eAdapters().add((Object)this.getStyleListener());
        List<String> cssStyles = Arrays.asList("cssClass", "cssId", "cssStyle", "css_stylesheets");
        this.cssStyleListener = new CustomStyleListener(this.notationElement, (IChangeListener)this, cssStyles);
        this.notationElement.eAdapters().add((Object)this.cssStyleListener);
    }

    ExtendedCSSEngine getEngine() {
        return (ExtendedCSSEngine)this.engine;
    }

    private void listenSemanticElement() {
        if (this.semanticElement != null) {
            this.semanticElement.eAdapters().add((Object)this.getStyleListener());
        }
    }

    public Node getParentNode() {
        if (this.parentNode == null) {
            View gmfElement = this.notationElement;
            while (gmfElement != null) {
                EObject semanticElement = this.helper.findSemanticElement((EObject)gmfElement);
                if (semanticElement != this.getSemanticElement()) break;
                EObject container = gmfElement.eContainer();
                if (gmfElement == container || !(container instanceof View)) {
                    gmfElement = null;
                    break;
                }
                gmfElement = (View)container;
            }
            this.parentNode = this.engine.getElement((Object)gmfElement);
            if (this.parentNode == this) {
                this.parentNode = null;
                return null;
            }
        }
        return this.parentNode;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public String getNamespaceURI() {
        if (this.namespaceURI == null) {
            this.namespaceURI = EMFHelper.getQualifiedName((EPackage)this.getSemanticElement().eClass().getEPackage(), (String)".");
        }
        return this.namespaceURI;
    }

    public String getCSSId() {
        return GMFElementAdapter.getCSSID((EObject)this.notationElement);
    }

    public String getCSSClass() {
        return GMFElementAdapter.getCSSClass((EObject)this.notationElement);
    }

    public String getCSSStyle() {
        return GMFElementAdapter.getCSSStyle((EObject)this.notationElement);
    }

    public String getLocalName() {
        if (this.localName == null) {
            if (this.getSemanticElement() instanceof Diagram) {
                Diagram diagram = (Diagram)this.getSemanticElement();
                String type = diagram.getType();
                String humanType = NotationTypesMap.instance.getHumanReadableType((View)diagram);
                this.localName = humanType != null ? humanType : type;
            } else {
                if (this.getNotationElement() instanceof BasicCompartment) {
                    return "Compartment";
                }
                if (this.helper.isFloatingLabel((EObject)this.getNotationElement())) {
                    return "Label";
                }
                this.localName = this.getSemanticElement().eClass().getName();
            }
        }
        return this.localName;
    }

    public final String getAttribute(String attr) {
        String value = this.doGetAttribute(attr);
        if (value != null) {
            return value;
        }
        return "";
    }

    protected String doGetAttribute(String attr) {
        if (this.notationElement instanceof DecorationNode && KIND.equals(attr)) {
            DecorationNode node = (DecorationNode)this.notationElement;
            String humanType = NotationTypesMap.instance.getHumanReadableType((View)node);
            if (humanType == null) {
                return node.getType();
            }
            return humanType;
        }
        EStructuralFeature feature = this.getSemanticElement().eClass().getEStructuralFeature(attr);
        if (feature != null) {
            if (feature.isMany()) {
                List values = (List)this.semanticElement.eGet(feature);
                LinkedList<String> cssValues = new LinkedList<String>();
                for (Object value : values) {
                    if (value == null) continue;
                    cssValues.add(this.getCSSValue(feature, value));
                }
                return ListHelper.deepToString(cssValues, (String)" ");
            }
            Object value = this.semanticElement.eGet(feature);
            if (value != null) {
                return this.getCSSValue(feature, value);
            }
        }
        return null;
    }

    protected String getCSSValue(EStructuralFeature feature, Object value) {
        if (value == null) {
            return null;
        }
        if (feature instanceof EReference && value instanceof ENamedElement) {
            String name = ((ENamedElement)value).getName();
            return name == null || name.isEmpty() ? " " : name;
        }
        return value.toString();
    }

    public EObject getNativeWidget() {
        return this.notationElement;
    }

    @Override
    public Node item(int index) {
        return this.getChildren()[index];
    }

    @Override
    public int getLength() {
        return this.getChildren().length;
    }

    protected Node[] getChildren() {
        if (this.children == null) {
            this.children = this.computeChildren(this.notationElement, this.engine);
        }
        return this.children;
    }

    protected Node[] computeChildren(View notationElement, CSSEngine engine) {
        EObject semanticElement = this.helper.findSemanticElement((EObject)notationElement);
        LinkedList<Node> childList = new LinkedList<Node>();
        for (EObject child : notationElement.eContents()) {
            if (!(child instanceof View)) continue;
            View notationChild = (View)child;
            if (SemanticElementHelper.findSemanticElement((EObject)notationChild) != semanticElement) {
                childList.add(engine.getElement((Object)notationChild));
                continue;
            }
            childList.addAll(Arrays.asList(this.computeChildren(notationChild, engine)));
        }
        return childList.toArray(new Node[childList.size()]);
    }

    public View getNotationElement() {
        return this.notationElement;
    }

    public void semanticElementChanged() {
        if (this.semanticElement != null && this.semanticElement != this.notationElement) {
            this.semanticElement.eAdapters().remove((Object)this.styleListener);
            this.semanticElement = null;
        }
        this.localName = null;
        this.parentNode = null;
        this.namespaceURI = null;
        this.children = null;
        this.getEngine().notifyChange((Element)((Object)this));
    }

    public void childrenChanged() {
        if (this.children != null) {
            this.children = null;
            this.getEngine().notifyChange((Element)((Object)this));
        }
    }

    public void parentChanged() {
        if (this.parentNode != null) {
            this.parentNode = null;
            this.getEngine().notifyChange((Element)((Object)this));
        }
    }

    public void handleChange(ChangeEvent event) {
        if (this.notationElement instanceof CSSDiagram) {
            this.getEngine().reset();
        }
        this.getEngine().notifyChange((Element)((Object)this));
    }

    public void dispose() {
        super.dispose();
        this.notationElement.eAdapters().remove((Object)this.cssStyleListener);
        this.cssStyleListener.dispose();
        this.notationElement.eAdapters().remove((Object)this.styleListener);
        if (this.semanticElement != null) {
            this.semanticElement.eAdapters().remove((Object)this.styleListener);
        }
    }

    public void notationPropertyChanged() {
        this.getEngine().notifyChange((Element)((Object)this));
    }

    public void semanticPropertyChanged() {
        this.getEngine().notifyChange((Element)((Object)this));
    }

    public void notationElementDisposed() {
        this.dispose();
        this.getEngine().handleDispose(this.notationElement);
    }

    public boolean isPseudoInstanceOf(String pseudo) {
        return this.pseudoInstances.contains(new StringIgnoreCase(pseudo));
    }

    public void addStaticPseudoInstance(String pseudo) {
        throw new UnsupportedOperationException();
    }

    public String[] getStaticPseudoInstances() {
        return new String[0];
    }

    @Override
    public void addStates(Set<String> states) {
        for (String state : states) {
            this.pseudoInstances.add(new StringIgnoreCase(state));
        }
        this.getEngine().notifyChange((Element)((Object)this));
    }

    @Override
    public void removeStates(Set<String> states) {
        for (String state : states) {
            this.pseudoInstances.remove(new StringIgnoreCase(state));
        }
        this.getEngine().notifyChange((Element)((Object)this));
    }

    @Override
    public Set<String> getStates() {
        HashSet<String> result = new HashSet<String>();
        for (StringIgnoreCase element : this.pseudoInstances) {
            result.add(element.toString());
        }
        return result;
    }

    private static final class StringIgnoreCase {
        private final String sourceString;
        private final String sourceStringToLower;

        public StringIgnoreCase(String source) {
            this.sourceString = source;
            this.sourceStringToLower = source == null ? null : source.toLowerCase();
        }

        public boolean equals(Object other) {
            if (other instanceof String) {
                return ((String)other).equalsIgnoreCase(this.sourceString);
            }
            if (other instanceof StringIgnoreCase) {
                return this.equals(((StringIgnoreCase)other).sourceString);
            }
            return false;
        }

        public int hashCode() {
            if (this.sourceStringToLower == null) {
                return 0;
            }
            return this.sourceStringToLower.hashCode();
        }

        public String toString() {
            return this.sourceStringToLower;
        }
    }
}

