/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.ApplyStereotypeAdviceRule;
import org.eclipse.papyrus.uml.profile.types.generator.ElementTypeRule;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdviceConfiguration;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class ConfigurationSetRule {
    @Extension
    private static ElementTypesConfigurationsFactory elementtypesconfigurationsFactory = ElementTypesConfigurationsFactory.eINSTANCE;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private UML _uML;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private ElementTypeRule _elementTypeRule;
    @Inject
    @Extension
    private ApplyStereotypeAdviceRule _applyStereotypeAdviceRule;
    private final HashMap<ArrayList<?>, ElementTypeSetConfiguration> _createCache_toConfigurationSet = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementTypeSetConfiguration toConfigurationSet(Profile umlProfile) {
        ElementTypeSetConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Profile[]{umlProfile});
        HashMap<ArrayList<?>, ElementTypeSetConfiguration> hashMap = this._createCache_toConfigurationSet;
        synchronized (hashMap) {
            ElementTypeSetConfiguration _createElementTypeSetConfiguration;
            if (this._createCache_toConfigurationSet.containsKey(_cacheKey)) {
                return this._createCache_toConfigurationSet.get(_cacheKey);
            }
            _result = _createElementTypeSetConfiguration = elementtypesconfigurationsFactory.createElementTypeSetConfiguration();
            this._createCache_toConfigurationSet.put(_cacheKey, _result);
        }
        this._init_toConfigurationSet(_result, umlProfile);
        return _result;
    }

    private void _init_toConfigurationSet(ElementTypeSetConfiguration it, Profile umlProfile) {
        this._identifiers.setIdentifierBase((Package)umlProfile);
        String _qualified = this._identifiers.getQualified("elementTypes");
        it.setIdentifier(_qualified);
        String _elvis = null;
        ElementTypeSetConfiguration _baseUMLElementTypeSet = this._uMLElementTypes.getBaseUMLElementTypeSet();
        String _metamodelNsURI = null;
        if (_baseUMLElementTypeSet != null) {
            _metamodelNsURI = _baseUMLElementTypeSet.getMetamodelNsURI();
        }
        _elvis = _metamodelNsURI != null ? _metamodelNsURI : "http://www.eclipse.org/uml2/5.0.0/UML";
        it.setMetamodelNsURI(_elvis);
        final ArrayList elementTypeConfigurationList = CollectionLiterals.newArrayList((Object[])new ElementTypeConfiguration[0]);
        final ArrayList adviceBindingConfigurationList = CollectionLiterals.newArrayList((Object[])new AbstractAdviceBindingConfiguration[0]);
        Iterable<ImpliedExtension> _allExtensions = this._uML.getAllExtensions((Package)umlProfile);
        Consumer<ImpliedExtension> _function = new Consumer<ImpliedExtension>(){

            @Override
            public void accept(final ImpliedExtension ext) {
                Class _metaclass = ext.getMetaclass();
                Iterable<? extends ElementTypeConfiguration> _diagramSpecificElementTypes = ConfigurationSetRule.this._uMLElementTypes.getDiagramSpecificElementTypes(_metaclass);
                Functions.Function1<ElementTypeConfiguration, SpecializationTypeConfiguration> _function = new Functions.Function1<ElementTypeConfiguration, SpecializationTypeConfiguration>(){

                    public SpecializationTypeConfiguration apply(ElementTypeConfiguration it) {
                        return ConfigurationSetRule.this._elementTypeRule.toElementType(ext, it);
                    }
                };
                Iterable _map = IterableExtensions.map(_diagramSpecificElementTypes, (Functions.Function1)_function);
                Iterables.addAll((Collection)elementTypeConfigurationList, (Iterable)_map);
                Class _metaclass_1 = ext.getMetaclass();
                Iterable<? extends ElementTypeConfiguration> _diagramSpecificElementTypes_1 = ConfigurationSetRule.this._uMLElementTypes.getDiagramSpecificElementTypes(_metaclass_1);
                Functions.Function1<ElementTypeConfiguration, Boolean> _function_1 = new Functions.Function1<ElementTypeConfiguration, Boolean>(){

                    public Boolean apply(ElementTypeConfiguration it) {
                        boolean _hasSemanticSupertype = ConfigurationSetRule.this._uMLElementTypes.hasSemanticSupertype(it);
                        return !_hasSemanticSupertype;
                    }
                };
                Iterable typesNeedingAdvice = IterableExtensions.filter(_diagramSpecificElementTypes_1, (Functions.Function1)_function_1);
                Functions.Function1<ElementTypeConfiguration, ApplyStereotypeAdviceConfiguration> _function_2 = new Functions.Function1<ElementTypeConfiguration, ApplyStereotypeAdviceConfiguration>(){

                    public ApplyStereotypeAdviceConfiguration apply(ElementTypeConfiguration it) {
                        Stereotype _stereotype = ext.getStereotype();
                        return ConfigurationSetRule.this._applyStereotypeAdviceRule.toAdviceConfiguration(_stereotype, ext, it);
                    }
                };
                Iterable _map_1 = IterableExtensions.map((Iterable)typesNeedingAdvice, (Functions.Function1)_function_2);
                Iterables.addAll((Collection)adviceBindingConfigurationList, (Iterable)_map_1);
            }
        };
        _allExtensions.forEach(_function);
        EList _adviceBindingsConfigurations = it.getAdviceBindingsConfigurations();
        Functions.Function1<AbstractAdviceBindingConfiguration, String> _function_1 = new Functions.Function1<AbstractAdviceBindingConfiguration, String>(){

            public String apply(AbstractAdviceBindingConfiguration it) {
                return it.getIdentifier();
            }
        };
        List _sortBy = IterableExtensions.sortBy((Iterable)adviceBindingConfigurationList, (Functions.Function1)_function_1);
        _adviceBindingsConfigurations.addAll((Collection)_sortBy);
        EList _elementTypeConfigurations = it.getElementTypeConfigurations();
        Functions.Function1<ElementTypeConfiguration, String> _function_2 = new Functions.Function1<ElementTypeConfiguration, String>(){

            public String apply(ElementTypeConfiguration it) {
                return it.getIdentifier();
            }
        };
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)elementTypeConfigurationList, (Functions.Function1)_function_2);
        _elementTypeConfigurations.addAll((Collection)_sortBy_1);
    }
}

