/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.types.AbstractMatcherConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherConfiguration;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherFactory;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class ElementTypeRule {
    @Extension
    private static ElementTypesConfigurationsFactory elementtypesconfigurationsFactory = ElementTypesConfigurationsFactory.eINSTANCE;
    @Extension
    private static StereotypeApplicationMatcherFactory stereotypeApplicationMatcherConfigurationFactory = StereotypeApplicationMatcherFactory.eINSTANCE;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private Identifiers _identifiers;
    private final HashMap<ArrayList<?>, SpecializationTypeConfiguration> _createCache_toElementType = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, StereotypeApplicationMatcherConfiguration> _createCache_toMatcherConfiguration = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpecializationTypeConfiguration toElementType(ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        SpecializationTypeConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{umlExtension, supertype});
        HashMap<ArrayList<?>, SpecializationTypeConfiguration> hashMap = this._createCache_toElementType;
        synchronized (hashMap) {
            SpecializationTypeConfiguration _createSpecializationTypeConfiguration;
            if (this._createCache_toElementType.containsKey(_cacheKey)) {
                return this._createCache_toElementType.get(_cacheKey);
            }
            _result = _createSpecializationTypeConfiguration = elementtypesconfigurationsFactory.createSpecializationTypeConfiguration();
            this._createCache_toElementType.put(_cacheKey, _result);
        }
        this._init_toElementType(_result, umlExtension, supertype);
        return _result;
    }

    private void _init_toElementType(SpecializationTypeConfiguration it, ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        boolean _not;
        boolean _notEquals;
        String _elementTypeID = this._identifiers.toElementTypeID(umlExtension, supertype);
        it.setIdentifier(_elementTypeID);
        boolean _hasSemanticSupertype = this._uMLElementTypes.hasSemanticSupertype(supertype);
        if (_hasSemanticSupertype) {
            EList _specializedTypesID = it.getSpecializedTypesID();
            Class _metaclass = umlExtension.getMetaclass();
            ElementTypeConfiguration _elementTypeConfiguration = this._uMLElementTypes.getElementTypeConfiguration(_metaclass);
            String _elementTypeID_1 = this._identifiers.toElementTypeID(umlExtension, _elementTypeConfiguration);
            _specializedTypesID.add((Object)_elementTypeID_1);
        }
        EList _specializedTypesID_1 = it.getSpecializedTypesID();
        String _identifier = supertype.getIdentifier();
        _specializedTypesID_1.add((Object)_identifier);
        String _hint = supertype.getHint();
        it.setHint(_hint);
        String _elementTypeName = this._identifiers.toElementTypeName(umlExtension, supertype);
        it.setName(_elementTypeName);
        Stereotype _stereotype = umlExtension.getStereotype();
        IconEntry icon = this.getIconEntry(_stereotype);
        IconEntry _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)icon, null);
        if (_notEquals) {
            _xifexpression = icon;
        } else {
            Class _metaclass_1 = umlExtension.getMetaclass();
            _xifexpression = this._uMLElementTypes.getIconEntry(_metaclass_1);
        }
        it.setIconEntry(_xifexpression);
        boolean _hasSemanticSupertype_1 = this._uMLElementTypes.hasSemanticSupertype(supertype);
        boolean bl2 = _not = !_hasSemanticSupertype_1;
        if (_not) {
            StereotypeApplicationMatcherConfiguration _matcherConfiguration = this.toMatcherConfiguration(umlExtension, supertype);
            it.setMatcherConfiguration((AbstractMatcherConfiguration)_matcherConfiguration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StereotypeApplicationMatcherConfiguration toMatcherConfiguration(ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        StereotypeApplicationMatcherConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{umlExtension, supertype});
        HashMap<ArrayList<?>, StereotypeApplicationMatcherConfiguration> hashMap = this._createCache_toMatcherConfiguration;
        synchronized (hashMap) {
            StereotypeApplicationMatcherConfiguration _createStereotypeApplicationMatcherConfiguration;
            if (this._createCache_toMatcherConfiguration.containsKey(_cacheKey)) {
                return this._createCache_toMatcherConfiguration.get(_cacheKey);
            }
            _result = _createStereotypeApplicationMatcherConfiguration = stereotypeApplicationMatcherConfigurationFactory.createStereotypeApplicationMatcherConfiguration();
            this._createCache_toMatcherConfiguration.put(_cacheKey, _result);
        }
        this._init_toMatcherConfiguration(_result, umlExtension, supertype);
        return _result;
    }

    private void _init_toMatcherConfiguration(StereotypeApplicationMatcherConfiguration it, ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        EList _stereotypesQualifiedNames = it.getStereotypesQualifiedNames();
        Stereotype _stereotype = umlExtension.getStereotype();
        String _qualifiedName = _stereotype.getQualifiedName();
        _stereotypesQualifiedNames.add((Object)_qualifiedName);
    }

    private IconEntry getIconEntry(final Stereotype stereotype) {
        boolean _notEquals;
        IconEntry _xblockexpression = null;
        EList _icons = stereotype.getIcons();
        Functions.Function1<Image, Boolean> _function = new Functions.Function1<Image, Boolean>(){

            public Boolean apply(Image it) {
                String _location = it.getLocation();
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_location);
                return !_isNullOrEmpty;
            }
        };
        Image image = (Image)IterableExtensions.findFirst((Iterable)_icons, (Functions.Function1)_function);
        IconEntry _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)image, null);
        if (_notEquals) {
            boolean _notEquals_1;
            IconEntry _xblockexpression_1 = null;
            String _location = image.getLocation();
            final URI uri = URI.createURI((String)_location, (boolean)true);
            IconEntry _xifexpression_1 = null;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)uri, null);
            if (_notEquals_1) {
                IconEntry _createIconEntry = elementtypesconfigurationsFactory.createIconEntry();
                Procedures.Procedure1<IconEntry> _function_1 = new Procedures.Procedure1<IconEntry>(){

                    public void apply(IconEntry it) {
                        boolean _isPlatform = uri.isPlatform();
                        if (_isPlatform) {
                            String _segment = uri.segment(1);
                            it.setBundleId(_segment);
                            List _segmentsList = uri.segmentsList();
                            Iterable _drop = IterableExtensions.drop((Iterable)_segmentsList, (int)2);
                            Functions.Function1<String, CharSequence> _function = new Functions.Function1<String, CharSequence>(){

                                public CharSequence apply(String it) {
                                    return URI.decode((String)it);
                                }
                            };
                            String _join = IterableExtensions.join((Iterable)_drop, (CharSequence)"/", (Functions.Function1)_function);
                            String _plus = "/" + _join;
                            it.setIconPath(_plus);
                        } else {
                            boolean _isRelative = uri.isRelative();
                            if (_isRelative) {
                                IProject _containingProject = ElementTypeRule.this.containingProject((EObject)stereotype);
                                String _name = _containingProject.getName();
                                it.setBundleId(_name);
                                String _string = uri.toString();
                                String _decode = URI.decode((String)_string);
                                String _plus_1 = "/" + _decode;
                                it.setIconPath(_plus_1);
                            } else {
                                String _string_1 = uri.toString();
                                it.setIconPath(_string_1);
                            }
                        }
                    }
                };
                _xifexpression_1 = (IconEntry)ObjectExtensions.operator_doubleArrow((Object)_createIconEntry, (Procedures.Procedure1)_function_1);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private IProject containingProject(EObject object) {
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = _workspace.getRoot();
        Resource _eResource = object.eResource();
        URI _uRI = _eResource.getURI();
        String _segment = _uRI.segment(2);
        return _root.getProject(_segment);
    }
}

