/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.arg.diagram.edit.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.gmf.tooling.runtime.update.UpdaterLinkDescriptor;
import org.eclipse.opencert.sam.arg.arg.ArgPackage;
import org.eclipse.opencert.sam.arg.arg.Choice;
import org.eclipse.opencert.sam.arg.arg.ModelElement;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramUpdater;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgLinkDescriptor;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgNodeDescriptor;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgVisualIDRegistry;
import org.eclipse.opencert.sam.arg.arg.impl.CaseImpl;
import org.eclipse.opencert.sam.arg.arg.impl.ClaimImpl;

public class RepairViewLocationsCommand
extends AbstractTransactionalCommand {
    private String sourceFile;
    private Point offset;
    private List<EObject> listObjects;
    private View parentView;
    private EditPart host;

    public RepairViewLocationsCommand(String sourceFile, Point offset, List<EObject> listNodes, TransactionalEditingDomain editingDomain, View parentView, EditPart host) {
        super(editingDomain, "Repair location of views", RepairViewLocationsCommand.getWorkspaceFiles((EObject)parentView));
        this.sourceFile = sourceFile;
        this.parentView = parentView;
        this.host = host;
        this.listObjects = listNodes;
        this.offset = offset;
    }

    private List<View> findViews(List<EObject> listNodes) {
        ArrayList<View> res = new ArrayList<View>();
        for (EObject elem : listNodes) {
            EditPart editPart = this.lookForEditPart(elem);
            View view = ((IGraphicalEditPart)editPart).getNotationView();
            res.add(view);
        }
        return res;
    }

    private EditPart lookForEditPart(EObject semantic) {
        Collection editPartSet = ((IGraphicalEditPart)this.host).getViewer().getEditPartRegistry().values();
        Iterator editPartIterator = editPartSet.iterator();
        EditPart existedEditPart = null;
        while (editPartIterator.hasNext() && existedEditPart == null) {
            EditPart currentEditPart = (EditPart)editPartIterator.next();
            if (!this.isEditPartTypeAdapted(currentEditPart.getClass(), semantic.eClass()) || !semantic.equals(((GraphicalEditPart)currentEditPart).resolveSemanticElement())) continue;
            existedEditPart = currentEditPart;
        }
        return existedEditPart;
    }

    private boolean isEditPartTypeAdapted(Class<? extends EditPart> editPartClass, EClass eClass) {
        if (DiagramEditPart.class.isAssignableFrom(editPartClass) || CompartmentEditPart.class.isAssignableFrom(editPartClass)) {
            return false;
        }
        if (GraphicalEditPart.class.isAssignableFrom(editPartClass)) {
            return this.isEditPartTypeSuitableForEClass(editPartClass.asSubclass(GraphicalEditPart.class), eClass);
        }
        return false;
    }

    protected boolean isEditPartTypeSuitableForEClass(Class<? extends GraphicalEditPart> editPartClass, EClass eClass) {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.listObjects == null || this.listObjects.isEmpty()) {
            return CommandResult.newOKCommandResult();
        }
        CaseRepairViewLocationsCanonicalEditPolicy kk = new CaseRepairViewLocationsCanonicalEditPolicy();
        kk.setObjects(this.listObjects);
        kk.setHost(this.host);
        kk.setoffset(this.offset);
        kk.LoadObjectLocations(this.sourceFile);
        kk.refresh();
        kk.deactivate();
        return CommandResult.newOKCommandResult();
    }

    public class CaseRepairViewLocationsCanonicalEditPolicy
    extends CanonicalEditPolicy {
        private Map<EObject, String> eObjectToIDMap = null;
        Map<String, LayoutConstraint> objectLocations = new HashMap<String, LayoutConstraint>();
        private Point offset;
        private List<EObject> listRootObjects = null;
        private Set<EStructuralFeature> myFeaturesToSynchronize;

        public void setObjects(List<EObject> lro) {
            this.listRootObjects = lro;
            for (EObject element : this.listRootObjects) {
                if (!(element instanceof CaseImpl)) continue;
                System.out.println("CaseRepairViewLocationsCanonicalEditPolicy.setObject(): Error object not allowed - " + element.getClass().getCanonicalName());
            }
        }

        public void setoffset(Point offset) {
            this.offset = offset;
        }

        private String getModelFile(EObject model) {
            String ret = "";
            MinimalEObjectImpl model2 = (MinimalEObjectImpl)model;
            String name = model2.eProxyURI().toString();
            int index = name.indexOf("eProxyURI: ");
            index = index != -1 ? (index += "eProxyURI: ".length()) : 0;
            name = name.substring(index);
            ret = name.substring(0, name.indexOf("#"));
            return ret;
        }

        public void LoadObjectLocations(String fileSource) {
            DiagramImpl diagramImpl = null;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new GMFResourceFactory());
            resourceSet.getPackageRegistry().put((Object)"arg", (Object)ArgPackage.eINSTANCE);
            File file = new File(fileSource);
            URI uri = file.isFile() ? URI.createFileURI((String)file.getAbsolutePath()) : URI.createURI((String)fileSource);
            try {
                Resource resource = resourceSet.getResource(uri, true);
                System.out.println("Loaded " + uri);
                diagramImpl = (DiagramImpl)resource.getContents().get(0);
            }
            catch (RuntimeException exception) {
                System.out.println("Problem loading " + uri);
                exception.printStackTrace();
            }
            GMFResource aa = (GMFResource)diagramImpl.eResource();
            EObject obj = diagramImpl.basicGetElement();
            String sModelFile = this.getModelFile(obj);
            File modelFile = new File(sModelFile);
            URI modelUri = modelFile.isFile() ? URI.createFileURI((String)modelFile.getAbsolutePath()) : URI.createURI((String)sModelFile);
            Resource modelResource = resourceSet.getResource(modelUri, true);
            System.out.println("Loaded " + modelUri);
            GMFResource bb = (GMFResource)modelResource;
            DiagramImpl d = (DiagramImpl)aa.getContents().get(0);
            for (Object elem0 : d.getChildren()) {
                if (!(elem0 instanceof Node)) continue;
                Node view = (Node)elem0;
                bb.getID(view.getElement());
                LayoutConstraint lc = view.getLayoutConstraint();
                ModelElement me = (ModelElement)view.getElement();
                System.out.println("key = " + me.getId() + me.getName() + me.getClass().getName());
                this.objectLocations.put(String.valueOf(me.getId()) + me.getName() + me.eClass().getName(), lc);
            }
        }

        protected IStatus changeLocations(List<View> nodel, Location offset) {
            for (View elem : nodel) {
                this.changeLocation((Node)elem, offset);
            }
            return Status.OK_STATUS;
        }

        private IStatus changeLocation(Node node, Location offset) {
            Location lc = (Location)node.getLayoutConstraint();
            int x = lc.getX();
            int y = lc.getY();
            lc.setX(offset.getX() + x);
            lc.setY(offset.getY() + y);
            return Status.OK_STATUS;
        }

        protected void refreshOnActivate() {
            List c = this.getHost().getChildren();
            int i = 0;
            while (i < c.size()) {
                ((EditPart)c.get(i)).activate();
                ++i;
            }
            super.refreshOnActivate();
        }

        protected Set getFeaturesToSynchronize() {
            if (this.myFeaturesToSynchronize == null) {
                this.myFeaturesToSynchronize = new HashSet<EStructuralFeature>();
                this.myFeaturesToSynchronize.add((EStructuralFeature)ArgPackage.eINSTANCE.getCase_Argument());
                this.myFeaturesToSynchronize.add((EStructuralFeature)ArgPackage.eINSTANCE.getCase_Argumentation());
            }
            return this.myFeaturesToSynchronize;
        }

        protected List getSemanticChildrenList() {
            View viewObject = (View)this.getHost().getModel();
            LinkedList<EObject> result = new LinkedList<EObject>();
            List<ArgNodeDescriptor> childDescriptors = ArgDiagramUpdater.getCase_1000SemanticChildren(viewObject);
            for (ArgNodeDescriptor d : childDescriptors) {
                result.add(d.getModelElement());
            }
            return result;
        }

        protected boolean isOrphaned(Collection<EObject> semanticChildren, View view) {
            if (this.isShortcut(view)) {
                return ArgDiagramUpdater.isShortcutOrphaned(view);
            }
            return this.isMyDiagramElement(view) && !semanticChildren.contains(view.getElement());
        }

        private boolean isMyDiagramElement(View view) {
            int visualID = ArgVisualIDRegistry.getVisualID(view);
            boolean res2 = false;
            if (view.getElement() != null) {
                DiagramImpl diagramImpl = (DiagramImpl)this.getHost().getModel();
                CaseImpl cs = (CaseImpl)diagramImpl.basicGetElement();
                GMFResource aa = null;
                CDOResource bb = null;
                if (cs.eResource() instanceof GMFResource) {
                    aa = (GMFResource)cs.eResource();
                } else if (cs.eResource() instanceof CDOResource) {
                    bb = (CDOResource)cs.eResource();
                }
                block0 : switch (visualID) {
                    case 2001: 
                    case 2002: 
                    case 2003: 
                    case 2004: 
                    case 2005: 
                    case 2006: 
                    case 2007: {
                        ModelElement me = (ModelElement)ViewUtil.resolveSemanticElement((View)view);
                        if (me == null) break;
                        String meID = "-1";
                        if (aa != null) {
                            meID = aa.getID((EObject)me);
                        } else if (bb != null) {
                            meID = this.getID((EObject)me);
                        }
                        for (EObject elem : this.listRootObjects) {
                            String rootObjectId = "-1";
                            if (aa != null) {
                                rootObjectId = aa.getID(elem);
                            } else if (bb != null) {
                                rootObjectId = this.getID(elem);
                            }
                            if (meID == null || meID.compareToIgnoreCase(rootObjectId) != 0 || !me.getClass().equals(elem.getClass())) continue;
                            res2 = true;
                            break block0;
                        }
                        break;
                    }
                }
            }
            switch (visualID) {
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: 
                case 2007: {
                    return res2;
                }
            }
            return false;
        }

        protected boolean isShortcut(View view) {
            return view.getEAnnotation("Shortcut") != null;
        }

        private void setIDs() {
            this.eObjectToIDMap = new HashMap<EObject, String>();
            List result = this.getSemanticChildrenList();
            for (EObject elem : result) {
                ClaimImpl obj;
                Choice elem2;
                CDOID cdoID = CDOUtil.getCDOObject((EObject)elem).cdoID();
                new Long(cdoID.toURIFragment());
                this.eObjectToIDMap.put(elem, cdoID.toString());
                if (!(elem instanceof ClaimImpl) || (elem2 = (obj = (ClaimImpl)elem).getChoice()) == null) continue;
                CDOID cdoID2 = CDOUtil.getCDOObject((EObject)elem2).cdoID();
                this.eObjectToIDMap.put((EObject)elem2, cdoID2.toString());
            }
        }

        private String getID(EObject eObject) {
            if (this.eObjectToIDMap == null) {
                return null;
            }
            return this.eObjectToIDMap.get(eObject);
        }

        protected void refreshSemantic() {
            if (this.resolveSemanticElement() == null) {
                return;
            }
            LinkedList<IAdaptable> createdViews = new LinkedList<IAdaptable>();
            List<ArgNodeDescriptor> childDescriptors = ArgDiagramUpdater.getCase_1000SemanticChildren((View)this.getHost().getModel());
            DiagramImpl diagramImpl = (DiagramImpl)this.getHost().getModel();
            CaseImpl cs = (CaseImpl)diagramImpl.basicGetElement();
            GMFResource aa = null;
            CDOResource bb = null;
            if (cs.eResource() instanceof GMFResource) {
                aa = (GMFResource)cs.eResource();
            } else if (cs.eResource() instanceof CDOResource) {
                bb = (CDOResource)cs.eResource();
                this.setIDs();
            }
            HashSet<Object> rootObjectIds = new HashSet<Object>();
            for (EObject elem : this.listRootObjects) {
                if (elem instanceof CaseImpl) continue;
                Object rootObjectId = "-1";
                if (aa != null) {
                    rootObjectId = aa.getID(elem);
                } else if (bb != null) {
                    rootObjectId = this.getID(elem);
                }
                rootObjectIds.add(rootObjectId);
            }
            LinkedList<ArgNodeDescriptor> c = new LinkedList<ArgNodeDescriptor>();
            for (ArgNodeDescriptor next : childDescriptors) {
                ModelElement me = (ModelElement)next.getModelElement();
                if (me == null) continue;
                Object meID = "-1";
                if (aa != null) {
                    meID = aa.getID((EObject)me);
                } else if (bb != null) {
                    meID = this.getID((EObject)me);
                }
                if (meID == null || !rootObjectIds.contains(meID)) {
                    c.add(next);
                    continue;
                }
                if (meID == null || !rootObjectIds.contains(meID)) continue;
                boolean OK = false;
                for (EObject elem : this.listRootObjects) {
                    if (!me.getClass().equals(elem.getClass())) continue;
                    OK = true;
                    break;
                }
                if (OK) continue;
                c.add(next);
            }
            childDescriptors.removeAll(c);
            LinkedList<Object> orphaned = new LinkedList<Object>();
            LinkedList<View> knownViewChildren = new LinkedList<View>();
            for (View v : this.getViewChildren()) {
                if (this.isShortcut(v)) {
                    if (!ArgDiagramUpdater.isShortcutOrphaned(v)) continue;
                    orphaned.add(v);
                    continue;
                }
                if (!this.isMyDiagramElement(v)) continue;
                knownViewChildren.add(v);
            }
            orphaned.addAll(knownViewChildren);
            ArrayList<CreateViewRequest.ViewDescriptor> viewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>(childDescriptors.size());
            for (ArgNodeDescriptor next : childDescriptors) {
                String hint = ArgVisualIDRegistry.getType(next.getVisualID());
                CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(next.getModelElement(), hint);
                CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, hint, -1, false, this.host().getDiagramPreferencesHint());
                viewDescriptors.add(descriptor);
            }
            boolean changed = this.deleteViews(orphaned.iterator());
            for (CreateViewRequest.ViewDescriptor oneviewDescriptor : viewDescriptors) {
                ArrayList<CreateViewRequest.ViewDescriptor> oneviewDescriptorl = new ArrayList<CreateViewRequest.ViewDescriptor>(1);
                oneviewDescriptorl.add(oneviewDescriptor);
                CreateViewRequest request = this.getCreateViewRequest(oneviewDescriptorl);
                ModelElement me = (ModelElement)oneviewDescriptor.getElementAdapter().getAdapter(ModelElement.class);
                System.out.println("key = " + me.getId() + me.getName() + me.getClass().getName());
                Bounds lc = (Bounds)this.objectLocations.get(String.valueOf(me.getId()) + me.getName() + me.eClass().getName());
                int x = 0;
                int y = 0;
                if (lc != null) {
                    x = lc.getX();
                    y = lc.getY();
                    Dimension newSize = new Dimension(lc.getWidth(), lc.getHeight());
                    request.setSize(newSize);
                }
                Point newlocation = new Point();
                newlocation.setX(this.offset.x() + x);
                newlocation.setY(this.offset.y() + y);
                request.setLocation(newlocation);
                Command cmd = this.getCreateViewCommand((CreateRequest)request);
                if (cmd == null || !cmd.canExecute()) continue;
                SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)this.host().getNotationView())).execute();
                this.executeCommand(cmd);
                List nl = (List)request.getNewObject();
                createdViews.addAll(nl);
            }
            if (changed || createdViews.size() > 0) {
                this.postProcessRefreshSemantic(createdViews);
            }
            Collection<IAdaptable> createdConnectionViews = this.refreshConnections();
            createdViews.addAll(createdConnectionViews);
            this.makeViewsImmutable(createdViews);
        }

        private Collection<IAdaptable> refreshConnections() {
            Domain2Notation domain2NotationMap = new Domain2Notation();
            Collection<ArgLinkDescriptor> linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
            LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
            Iterator linksIterator = existingLinks.iterator();
            block0: while (linksIterator.hasNext()) {
                Edge nextDiagramLink = (Edge)linksIterator.next();
                int diagramLinkVisualID = ArgVisualIDRegistry.getVisualID((View)nextDiagramLink);
                if (diagramLinkVisualID == -1) {
                    if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                    linksIterator.remove();
                    continue;
                }
                EObject diagramLinkObject = nextDiagramLink.getElement();
                EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
                EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
                Iterator<ArgLinkDescriptor> linkDescriptorsIterator = linkDescriptors.iterator();
                while (linkDescriptorsIterator.hasNext()) {
                    ArgLinkDescriptor nextLinkDescriptor = linkDescriptorsIterator.next();
                    if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                    linksIterator.remove();
                    linkDescriptorsIterator.remove();
                    continue block0;
                }
            }
            this.deleteViews(existingLinks.iterator());
            return this.createConnections(linkDescriptors, domain2NotationMap);
        }

        private Collection<ArgLinkDescriptor> collectAllLinks(View view, Domain2Notation domain2NotationMap) {
            if (!"Arg".equals(ArgVisualIDRegistry.getModelID(view))) {
                return Collections.emptyList();
            }
            LinkedList<ArgLinkDescriptor> result = new LinkedList<ArgLinkDescriptor>();
            switch (ArgVisualIDRegistry.getVisualID(view)) {
                case 1000: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getCase_1000ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 2001: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getClaim_2001ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 2003: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getArgumentReasoning_2003ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 2005: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getInformationElementCitation_2005ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 2006: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getArgumentElementCitation_2006ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 2007: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getChoice_2007ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 2002: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getAgreement_2002ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 2004: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getArgumentation_2004ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 3001: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getChoice_3001ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 4001: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getAssertedInference_4001ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 4002: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getAssertedEvidence_4002ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 4003: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getAssertedContext_4003ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 4004: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getAssertedChallenge_4004ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                    break;
                }
                case 4005: {
                    if (!domain2NotationMap.containsKey(view.getElement())) {
                        result.addAll(ArgDiagramUpdater.getAssertedCounterEvidence_4005ContainedLinks(view));
                    }
                    domain2NotationMap.putView(view.getElement(), view);
                }
            }
            Iterator children = view.getChildren().iterator();
            while (children.hasNext()) {
                result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
            }
            Iterator edges = view.getSourceEdges().iterator();
            while (edges.hasNext()) {
                result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
            }
            return result;
        }

        private Collection<IAdaptable> createConnections(Collection<ArgLinkDescriptor> linkDescriptors, Domain2Notation domain2NotationMap) {
            LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
            for (ArgLinkDescriptor nextLinkDescriptor : linkDescriptors) {
                EditPart sourceEditPart = this.getSourceEditPart(nextLinkDescriptor, domain2NotationMap);
                EditPart targetEditPart = this.getTargetEditPart(nextLinkDescriptor, domain2NotationMap);
                if (sourceEditPart == null || targetEditPart == null) continue;
                CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), ArgVisualIDRegistry.getType(nextLinkDescriptor.getVisualID()), -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
                CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
                ccr.setType((Object)"connection start");
                ccr.setSourceEditPart(sourceEditPart);
                sourceEditPart.getCommand((Request)ccr);
                ccr.setTargetEditPart(targetEditPart);
                ccr.setType((Object)"connection end");
                Command cmd = targetEditPart.getCommand((Request)ccr);
                if (cmd == null || !cmd.canExecute()) continue;
                this.executeCommand(cmd);
                IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
                if (viewAdapter == null) continue;
                adapters.add(viewAdapter);
            }
            return adapters;
        }

        private EditPart getEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap) {
            View view = (View)domain2NotationMap.get(domainModelElement);
            if (view != null) {
                return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
            }
            return null;
        }

        private Diagram getDiagram() {
            return ((View)this.getHost().getModel()).getDiagram();
        }

        private EditPart getSourceEditPart(UpdaterLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
            return this.getEditPart(descriptor.getSource(), domain2NotationMap);
        }

        private EditPart getTargetEditPart(UpdaterLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
            return this.getEditPart(descriptor.getDestination(), domain2NotationMap);
        }

        protected final EditPart getHintedEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap, int hintVisualId) {
            View view = domain2NotationMap.getHinted(domainModelElement, ArgVisualIDRegistry.getType(hintVisualId));
            if (view != null) {
                return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
            }
            return null;
        }

        protected class Domain2Notation
        extends HashMap<EObject, View> {
            protected Domain2Notation() {
            }

            public boolean containsDomainElement(EObject domainElement) {
                return this.containsKey(domainElement);
            }

            public View getHinted(EObject domainEObject, String hint) {
                return (View)this.get(domainEObject);
            }

            public void putView(EObject domainElement, View view) {
                if (!this.containsKey(view.getElement()) || !CaseRepairViewLocationsCanonicalEditPolicy.this.isShortcut(view)) {
                    this.put(domainElement, view);
                }
            }
        }
    }
}

