/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.as2cs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.internal.utilities.AbstractConversion;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.xtext.base.as2cs.AS2CSConversion;
import org.eclipse.ocl.xtext.base.as2cs.BaseDeclarationVisitor;
import org.eclipse.ocl.xtext.base.as2cs.BaseReferenceVisitor;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.CSI2ASMapping;

public class AS2CS
extends AbstractConversion {
    private @NonNull Map<EClass, Factory> factoryMap = new HashMap<EClass, Factory>();
    protected final @NonNull Map<? extends BaseCSResource, ? extends ASResource> cs2asResourceMap;

    public AS2CS(@NonNull Map<? extends BaseCSResource, ? extends ASResource> cs2asResourceMap, @NonNull EnvironmentFactoryInternal environmentFactory) {
        super(environmentFactory);
        this.cs2asResourceMap = cs2asResourceMap;
    }

    public AS2CS(@NonNull AS2CS aConverter) {
        super(aConverter.getEnvironmentFactory());
        this.cs2asResourceMap = aConverter.cs2asResourceMap;
    }

    protected synchronized void addFactory(@NonNull Factory factory) {
        EClass[] eClassArray = factory.getEClasses();
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            this.factoryMap.put(eClass, factory);
            ++n2;
        }
    }

    public @NonNull BaseDeclarationVisitor createDefaultDeclarationVisitor(@NonNull AS2CSConversion conversion) {
        return new BaseDeclarationVisitor(conversion);
    }

    public @NonNull BaseReferenceVisitor createDefaultReferenceVisitor(@NonNull AS2CSConversion conversion) {
        return new BaseReferenceVisitor(conversion);
    }

    public @Nullable Resource getASResource(@NonNull Resource csResource) {
        return (Resource)this.cs2asResourceMap.get(csResource);
    }

    public @NonNull Collection<? extends Resource> getASResources() {
        return this.cs2asResourceMap.values();
    }

    public @NonNull Collection<? extends BaseCSResource> getCSResources() {
        return this.cs2asResourceMap.keySet();
    }

    public @Nullable Factory getFactory(@NonNull EClass eClass) {
        return this.factoryMap.get(eClass);
    }

    public void update() {
        AS2CSConversion conversion = new AS2CSConversion(this);
        for (BaseCSResource baseCSResource : this.getCSResources()) {
            if (baseCSResource == null) continue;
            conversion.update(baseCSResource);
        }
        CSI2ASMapping cSI2ASMapping = CSI2ASMapping.getCSI2ASMapping(this.environmentFactory);
        cSI2ASMapping.add(this.cs2asResourceMap);
        cSI2ASMapping.update();
    }

    public static interface Factory {
        public @NonNull BaseDeclarationVisitor createDeclarationVisitor(@NonNull AS2CSConversion var1);

        public @NonNull BaseReferenceVisitor createReferenceVisitor(@NonNull AS2CSConversion var1, @Nullable Namespace var2);

        public @NonNull EClass @NonNull [] getEClasses();
    }
}

