/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.baseline.baseline.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.opencert.apm.baseline.baseline.BaseActivity;
import org.eclipse.opencert.apm.baseline.baseline.BaseArtefact;
import org.eclipse.opencert.apm.baseline.baseline.diagram.edit.policies.BaselineBaseItemSemanticEditPolicy;

public class BaseActivityRequiredArtefactReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public BaseActivityRequiredArtefactReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof BaseActivity)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof BaseArtefact) || !(this.newEnd instanceof BaseActivity)) {
            return false;
        }
        return BaselineBaseItemSemanticEditPolicy.getLinkConstraints().canExistBaseActivityRequiredArtefact_4001(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof BaseArtefact) || !(this.newEnd instanceof BaseArtefact)) {
            return false;
        }
        return BaselineBaseItemSemanticEditPolicy.getLinkConstraints().canExistBaseActivityRequiredArtefact_4001(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getRequiredArtefact().remove((Object)this.getOldTarget());
        this.getNewSource().getRequiredArtefact().add((Object)this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().getRequiredArtefact().remove((Object)this.getOldTarget());
        this.getOldSource().getRequiredArtefact().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected BaseActivity getOldSource() {
        return (BaseActivity)this.referenceOwner;
    }

    protected BaseActivity getNewSource() {
        return (BaseActivity)this.newEnd;
    }

    protected BaseArtefact getOldTarget() {
        return (BaseArtefact)this.oldEnd;
    }

    protected BaseArtefact getNewTarget() {
        return (BaseArtefact)this.newEnd;
    }
}

