/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo.executors;

import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.opencert.storage.cdo.property.OpencertPropertiesReader;
import org.eclipse.opencert.storage.cdo.session.ICDOSessionProvider;
import org.eclipse.opencert.storage.cdo.session.SimpleCDOSessionProvider;

public abstract class TemplatedSimpleInTransactionExecutor<T> {
    private ICDOSessionProvider cdoSessionProvider = new SimpleCDOSessionProvider(OpencertPropertiesReader.getInstance());

    public abstract T executeInTransaction(CDOTransaction var1);

    public T executeReadOnlyOperation() throws RuntimeException {
        try {
            CDOSession activeSession = this.cdoSessionProvider.getActiveSession();
            CDOTransaction cdoTransaction = activeSession.openTransaction();
            T returnedValue = this.executeInTransaction(cdoTransaction);
            cdoTransaction.rollback();
            T t = returnedValue;
            return t;
        }
        finally {
            this.cdoSessionProvider.close();
        }
    }

    public T executeReadWriteOperation() throws RuntimeException {
        try {
            CDOSession activeSession = this.cdoSessionProvider.getActiveSession();
            CDOTransaction cdoTransaction = activeSession.openTransaction();
            T returnedValue = this.executeInTransaction(cdoTransaction);
            cdoTransaction.commit();
            T t = returnedValue;
            return t;
        }
        catch (CommitException ce) {
            throw new RuntimeException(ce);
        }
        finally {
            this.cdoSessionProvider.close();
        }
    }
}

