/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.opencert.storage.cdo.property.IOpencertClientConfigurationAdapter;

public final class OpencertPropertiesReader
implements IOpencertClientConfigurationAdapter {
    private String dbHost;
    private String dbUser;
    private String dbPassword;
    private int dbPort;
    private String dbName;
    private String serverAddress;
    private static final String DB_USER = "dbUser";
    private static final String DB_PASSWORD = "dbPassword";
    private static final String SERVER_ADDRESS = "serverAddress";
    private static final String DB_NAME = "dbName";
    private static final String DB_PORT = "dbPort";
    private static final String DB_HOST = "dbHost";
    private static final String IS_SHOW_NEW_CLONE_PROJECT_BUTTONS = "isShowNewCloneProjectButtons";
    private static final String IS_IMPACT_ANALYSIS_VIA_BASELINE_ELEMENTS_ENABLED = "isImpactAnalysisViaBaselineElementsEnabled";
    private static final String IS_IMPACT_ANALYSIS_TRIGERRING_FROM_WEB_ENABLED = "isImpactAnalysisTrigerringFromWebEnabled";
    private static volatile OpencertPropertiesReader theInstance = null;
    private static final String PROPERTIES_FILE = String.valueOf(System.getProperty("user.home")) + File.separator + "opencert-properties.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpencertPropertiesReader getInstance() {
        if (theInstance != null) return theInstance;
        Class<OpencertPropertiesReader> clazz = OpencertPropertiesReader.class;
        synchronized (OpencertPropertiesReader.class) {
            if (theInstance != null) return theInstance;
            theInstance = new OpencertPropertiesReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    private OpencertPropertiesReader() {
        System.out.println("OpencertPropertiesReader() opencert-properties.xml path: " + PROPERTIES_FILE);
        Properties props = this.readPropertiesFromFile();
        this.readProperiesFromUserHome(props);
    }

    private void readProperiesFromUserHome(Properties props) {
        this.dbHost = props.getProperty(DB_HOST);
        this.dbUser = props.getProperty(DB_USER);
        this.dbPassword = props.getProperty(DB_PASSWORD);
        this.serverAddress = props.getProperty(SERVER_ADDRESS);
        this.dbPort = Integer.parseInt(props.getProperty(DB_PORT));
        this.dbName = props.getProperty(DB_NAME);
        System.out.println("dbHost: " + this.dbHost);
        System.out.println("dbUser: " + this.dbUser);
        System.out.println("dbPassword: *");
        System.out.println("serverAddress: " + this.serverAddress);
        System.out.println("dbPort: " + this.dbPort);
        System.out.println("dbName: " + this.dbName);
    }

    private Properties readPropertiesFromFile() {
        Properties result;
        block6: {
            result = new Properties();
            File file = new File(PROPERTIES_FILE);
            if (!file.exists() || file.isDirectory()) {
                System.out.println("Properties file not found.\nCreating \"default properties\"");
                OpencertPropertiesReader.createDefaultopencertProperties();
            }
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(PROPERTIES_FILE);
                    result.loadFromXML(fis);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    OpencertPropertiesReader.close(fis);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                OpencertPropertiesReader.close(fis);
                throw throwable;
            }
            OpencertPropertiesReader.close(fis);
        }
        return result;
    }

    private static void createDefaultopencertProperties() {
        block5: {
            Properties prop = new Properties();
            prop.setProperty(DB_HOST, "localhost");
            prop.setProperty(DB_PORT, "5432");
            prop.setProperty(DB_NAME, "cdo-opencert");
            prop.setProperty(DB_USER, "opencertdbms");
            prop.setProperty(DB_PASSWORD, "opencertdbms");
            prop.setProperty(SERVER_ADDRESS, "localhost:2036");
            prop.setProperty(IS_SHOW_NEW_CLONE_PROJECT_BUTTONS, "false");
            prop.setProperty(IS_IMPACT_ANALYSIS_VIA_BASELINE_ELEMENTS_ENABLED, "false");
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(PROPERTIES_FILE);
                    prop.storeToXML(fos, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    OpencertPropertiesReader.close(fos);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                OpencertPropertiesReader.close(fos);
                throw throwable;
            }
            OpencertPropertiesReader.close(fos);
        }
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public int getDbPort() {
        return this.dbPort;
    }

    public String getDbName() {
        return this.dbName;
    }

    @Override
    public String getCDOServerAddress() {
        return this.serverAddress;
    }

    public boolean isShowNewCloneProjectButtons() {
        return this.readBooleanProperty(IS_SHOW_NEW_CLONE_PROJECT_BUTTONS);
    }

    public boolean isImpactAnalysisViaBaselineElementsEnabled() {
        return this.readBooleanProperty(IS_IMPACT_ANALYSIS_VIA_BASELINE_ELEMENTS_ENABLED);
    }

    public boolean isImpactAnalysisTrigerringFromWebEnabled() {
        return this.readBooleanProperty(IS_IMPACT_ANALYSIS_TRIGERRING_FROM_WEB_ENABLED);
    }

    private boolean readBooleanProperty(String propertyKey) {
        Properties props = this.readPropertiesFromFile();
        boolean result = Boolean.parseBoolean(props.getProperty(propertyKey));
        return result;
    }

    public static void close(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    public static void close(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException iOException) {}
    }
}

