/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.service.types.Activator;
import org.eclipse.papyrus.sysml.service.types.helper.advice.AssociationEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.ClassifierUtils;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class AssociationNoneEditHelperAdvice
extends AssociationEditHelperAdvice {
    protected Classifier getSourceOwnerType(ConfigureRequest req) {
        Classifier result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof Classifier) {
            result = (Classifier)paramObject;
        }
        return result;
    }

    protected Classifier getTargetOwnerType(ConfigureRequest req) {
        Classifier result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof Classifier) {
            result = (Classifier)paramObject;
        }
        return result;
    }

    protected Property createTargetProperty(Property targetProperty, Classifier propertyContainer, Type propertyType, Association association, TransactionalEditingDomain editingDomain, IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.setPropertyType(targetProperty, propertyType, editingDomain, progressMonitor, info);
        this.setPropertyName(targetProperty);
        return targetProperty;
    }

    protected Property createSourceProperty(Property sourceProperty, Classifier propertyContainer, Type propertyType, Association association, TransactionalEditingDomain editingDomain, IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.setPropertyType(sourceProperty, propertyType, editingDomain, progressMonitor, info);
        this.setPropertyName(sourceProperty);
        return sourceProperty;
    }

    protected void setPropertyType(Property property, Type propertyType, TransactionalEditingDomain editingDomain, IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        SetRequest request = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)propertyType);
        request.setEditingDomain(editingDomain);
        IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((Object)property);
        ICommand editCommand = commandProvider.getEditCommand((IEditCommandRequest)request);
        editCommand.execute(progressMonitor, info);
    }

    private void setPropertyName(Property property) {
        String baseName = property.getType().getName().toLowerCase();
        Element owner = property.getOwner();
        if (owner instanceof Classifier) {
            List ownedAttributes = ClassifierUtils.getOwnedAttributes((Classifier)((Classifier)owner));
            String defaultNameWithIncrementFromBase = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)property.getType().getName().toLowerCase(), (Collection)ownedAttributes, (String)"_");
            property.setName(defaultNameWithIncrementFromBase);
        } else {
            property.setName(baseName);
        }
    }

    protected void configureSourceProperty(Property sourceProperty) {
    }

    protected void configureTargetProperty(Property targetProperty) {
    }

    protected void addSourceInModel(Property sourceEnd, Classifier owner, Type targetType, Association association) throws UnsupportedOperationException {
        boolean added = ClassifierUtils.addOwnedAttribute((Classifier)owner, (Property)sourceEnd);
        if (!added) {
            throw new UnsupportedOperationException("Cannot add a Property on Classifier " + owner.getQualifiedName());
        }
    }

    protected void addTargetInModel(Property targetEnd, Classifier owner, Type sourceType, Association association) {
        boolean added = ClassifierUtils.addOwnedAttribute((Classifier)owner, (Property)targetEnd);
        if (!added) {
            throw new UnsupportedOperationException("Cannot add a Property on Classifier " + owner.getQualifiedName());
        }
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        final Association association = (Association)request.getElementToConfigure();
        final Classifier sourceType = this.getSourceOwnerType(request);
        final Classifier targetType = this.getTargetOwnerType(request);
        if (sourceType == null || targetType == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                try {
                    Property targetProperty = UMLFactory.eINSTANCE.createProperty();
                    Property sourceProperty = UMLFactory.eINSTANCE.createProperty();
                    association.getMemberEnds().add((Object)targetProperty);
                    association.getMemberEnds().add((Object)sourceProperty);
                    AssociationNoneEditHelperAdvice.this.addSourceInModel(targetProperty, sourceType, (Type)targetType, association);
                    AssociationNoneEditHelperAdvice.this.addTargetInModel(sourceProperty, targetType, (Type)sourceType, association);
                    AssociationNoneEditHelperAdvice.this.createTargetProperty(targetProperty, sourceType, (Type)targetType, association, request.getEditingDomain(), progressMonitor, info);
                    AssociationNoneEditHelperAdvice.this.configureSourceProperty(targetProperty);
                    AssociationNoneEditHelperAdvice.this.createSourceProperty(sourceProperty, targetType, (Type)sourceType, association, request.getEditingDomain(), progressMonitor, info);
                    AssociationNoneEditHelperAdvice.this.configureTargetProperty(sourceProperty);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                    return CommandResult.newCancelledCommandResult();
                }
                return CommandResult.newOKCommandResult((Object)association);
            }
        };
    }
}

