/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.impactanalysis.relations.traverse;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.EventKind;
import org.eclipse.opencert.apm.baseline.baseline.BaseArtefact;
import org.eclipse.opencert.apm.baseline.baseline.BaseArtefactRel;
import org.eclipse.opencert.evm.evidspec.evidence.Artefact;
import org.eclipse.opencert.impactanalysis.relations.ArtefactRelationType;
import org.eclipse.opencert.impactanalysis.relations.ArtefactsRelationImpactFactory;
import org.eclipse.opencert.impactanalysis.relations.IArtefactRelationImpact;
import org.eclipse.opencert.impactanalysis.relations.traverse.AbstractRelationsTraverser;
import org.eclipse.opencert.storage.cdo.CDOStorageUtil;

public class DirectAndBaseRelationsTraverser
extends AbstractRelationsTraverser {
    @Override
    public List<IArtefactRelationImpact> generateArtefactRelationImpactsList(CDOTransaction cdoTransaction, Long impactingArtefactCdoId, IArtefactRelationImpact sourceArtefactRelationImpact, int recursionDepth, EventKind impactingEventKind) {
        ArrayList<IArtefactRelationImpact> artefactRelationImpacts = new ArrayList<IArtefactRelationImpact>();
        ArtefactRelationType sourceArtefactRelationType = null;
        if (sourceArtefactRelationImpact != null) {
            sourceArtefactRelationType = sourceArtefactRelationImpact.getArtefactRelationType();
        }
        if (sourceArtefactRelationType == null || ArtefactRelationType.DIRECT_EVIDENCE_RELATION.equals((Object)sourceArtefactRelationType) || ArtefactRelationType.BASELINE_TO_EVIDENCE_VIA_MAP_RELATION.equals((Object)sourceArtefactRelationType)) {
            this.addDirectArtefactRelations(cdoTransaction, impactingArtefactCdoId, impactingEventKind, artefactRelationImpacts, recursionDepth);
            this.addEvidenceToBaselineMappedArtefactRelations(cdoTransaction, impactingArtefactCdoId, impactingEventKind, sourceArtefactRelationImpact, artefactRelationImpacts, recursionDepth);
            return artefactRelationImpacts;
        }
        if (ArtefactRelationType.DIRECT_BASELINE_RELATION.equals((Object)sourceArtefactRelationType) || ArtefactRelationType.EVIDENCE_TO_BASELINE_VIA_MAP_RELATION.equals((Object)sourceArtefactRelationType)) {
            this.addDirectBaseArtefactRelations(cdoTransaction, impactingArtefactCdoId, impactingEventKind, artefactRelationImpacts, recursionDepth);
        }
        if (ArtefactRelationType.DIRECT_BASELINE_RELATION.equals((Object)sourceArtefactRelationType)) {
            this.addBaselineToEvidenceMappedArtefactRelations(cdoTransaction, impactingArtefactCdoId, impactingEventKind, sourceArtefactRelationImpact, artefactRelationImpacts, recursionDepth);
        }
        return artefactRelationImpacts;
    }

    private void addDirectBaseArtefactRelations(CDOTransaction cdoTransaction, Long impactingArtefactCdoId, EventKind impactingEventKind, List<IArtefactRelationImpact> artefactRelationImpacts, int recursionDepth) {
        CDOQuery query = cdoTransaction.createQuery("sql", "select * from baseline_baseartefactrel where target = " + impactingArtefactCdoId + CDOStorageUtil.getMandatoryCDOQuerySuffix());
        List impactedBaseArtefactRelations = query.getResult(BaseArtefactRel.class);
        for (BaseArtefactRel baseArtefactRel : impactedBaseArtefactRelations) {
            IArtefactRelationImpact artefactRelationImpact = ArtefactsRelationImpactFactory.createArtefactsRelationImpact(recursionDepth, baseArtefactRel, impactingEventKind);
            if (artefactRelationImpact == null) continue;
            artefactRelationImpacts.add(artefactRelationImpact);
        }
    }

    private void addEvidenceToBaselineMappedArtefactRelations(CDOTransaction cdoTransaction, Long impactingArtefactCdoId, EventKind impactingEventKind, IArtefactRelationImpact sourceArtefactRelationImpact, List<IArtefactRelationImpact> artefactRelationImpacts, int recursionDepth) {
        CDOQuery query2 = cdoTransaction.createQuery("sql", "select * from evidence_artefact where cdo_id = " + impactingArtefactCdoId + CDOStorageUtil.getMandatoryCDOQuerySuffix());
        Artefact impactingArtefact = (Artefact)query2.getResultValue(Artefact.class);
        CDOQuery query = cdoTransaction.createQuery("sql", "select cdo_source from baseline_baseartefact_compliancemap_list where (cdo_version >= 0) and cdo_value in (select cdo_id from baseline_basecompliancemap where " + CDOStorageUtil.getMandatoryCDOQuerySuffix((boolean)false) + " and cdo_id in " + "(select cdo_source from baseline_basecompliancemap_target_list where cdo_value = " + impactingArtefactCdoId + CDOStorageUtil.getMandatoryCDOQuerySuffix() + "));");
        List impactedMappedBaseArtefacts = query.getResult(BaseArtefact.class);
        for (BaseArtefact impactedMappedBaseArtefact : impactedMappedBaseArtefacts) {
            IArtefactRelationImpact artefactRelationImpact = ArtefactsRelationImpactFactory.createEvidenceMappedToBaseArtefactImpact(recursionDepth, impactingArtefact, impactedMappedBaseArtefact, impactingEventKind, sourceArtefactRelationImpact);
            if (artefactRelationImpact == null) continue;
            artefactRelationImpacts.add(artefactRelationImpact);
        }
    }

    private void addBaselineToEvidenceMappedArtefactRelations(CDOTransaction cdoTransaction, Long impactingArtefactCdoId, EventKind impactingEventKind, IArtefactRelationImpact sourceArtefactRelationImpact, List<IArtefactRelationImpact> artefactRelationImpacts, int recursionDepth) {
        CDOQuery query2 = cdoTransaction.createQuery("sql", "select * from baseline_baseartefact where cdo_id = " + impactingArtefactCdoId + CDOStorageUtil.getMandatoryCDOQuerySuffix());
        BaseArtefact baseArtefact = (BaseArtefact)query2.getResultValue(BaseArtefact.class);
        CDOQuery query = cdoTransaction.createQuery("sql", "select cdo_value from baseline_basecompliancemap_target_list where cdo_source in (select cdo_id from baseline_basecompliancemap where (cdo_revised = 0 and cdo_version >= 0) and cdo_id in (select cdo_value from baseline_baseartefact_compliancemap_list where (cdo_version >= 0) and cdo_source = " + impactingArtefactCdoId + "))");
        List mappedArtefacts = query.getResult(Artefact.class);
        for (Artefact mappedArtefact : mappedArtefacts) {
            IArtefactRelationImpact artefactRelationImpact = ArtefactsRelationImpactFactory.createBaseArtefactMappedToEvidenceImpact(recursionDepth, baseArtefact, mappedArtefact, impactingEventKind, sourceArtefactRelationImpact);
            if (artefactRelationImpact == null) continue;
            artefactRelationImpacts.add(artefactRelationImpact);
        }
    }
}

