/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.impactanalysis.test;

import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.opencert.apm.baseline.baseline.BaseArtefact;
import org.eclipse.opencert.apm.baseline.baseline.BaseArtefactRel;
import org.eclipse.opencert.apm.baseline.baseline.BaseComplianceMap;
import org.eclipse.opencert.apm.baseline.baseline.BaselineFactory;
import org.eclipse.opencert.evm.evidspec.evidence.Artefact;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactRel;
import org.eclipse.opencert.infra.general.general.ChangeEffectKind;
import org.eclipse.opencert.infra.mappings.mapping.MapJustification;
import org.eclipse.opencert.infra.mappings.mapping.MapKind;
import org.eclipse.opencert.infra.mappings.mapping.MappingFactory;
import org.eclipse.opencert.storage.cdo.CDOStorageUtil;
import org.eclipse.opencert.storage.cdo.StandaloneCDOAccessor;
import org.eclipse.opencert.storage.cdo.executors.SimpleInTransactionExecutor;
import org.eclipse.opencert.storage.cdo.test.DataCreationRoutines;

public class BaseFrameworkImpactStructureCreator {
    public static void main(String[] args) {
        BaseFrameworkImpactStructureCreator.createUseCaseTest();
    }

    private static void createBasicImpactStructure() {
        new SimpleInTransactionExecutor(){

            public void executeInTransaction(CDOTransaction cdoTransaction) {
                Resource resource = StandaloneCDOAccessor.getDefaultResource((CDOTransaction)cdoTransaction);
                BaseArtefact notImpactingArtefact = DataCreationRoutines.createBaseArtefact((String)"NotImpactingArtefact", (int)1);
                BaseArtefact baseArtefactA = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactA", (int)1);
                BaseArtefact baseArtefactB = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactB", (int)2);
                BaseArtefact baseArtefactC = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactC", (int)3);
                BaseArtefact baseArtefactD = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactD", (int)4);
                BaseArtefact baseArtefactE = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactE", (int)5);
                Artefact artefactA = DataCreationRoutines.createArtefact((String)"ArtefactA", (int)1);
                Artefact artefactE = DataCreationRoutines.createArtefact((String)"ArtefactE", (int)5);
                BaseComplianceMap complianceMapA = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                MapJustification mapJustificationA = MappingFactory.eINSTANCE.createMapJustification();
                mapJustificationA.setExplanation("OK");
                resource.getContents().add((Object)mapJustificationA);
                complianceMapA.setMapJustification(mapJustificationA);
                complianceMapA.setType(MapKind.FULL);
                BaseComplianceMap complianceMapE = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                MapJustification mapJustificationB = MappingFactory.eINSTANCE.createMapJustification();
                mapJustificationB.setExplanation("OK");
                resource.getContents().add((Object)mapJustificationB);
                complianceMapE.setMapJustification(mapJustificationB);
                complianceMapE.setType(MapKind.FULL);
                complianceMapA.getTarget().add((Object)artefactA);
                complianceMapE.getTarget().add((Object)artefactE);
                baseArtefactA.getComplianceMap().add((Object)complianceMapA);
                baseArtefactE.getComplianceMap().add((Object)complianceMapE);
                BaseArtefactRel baseArtefactRelA = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelA", (BaseArtefact)baseArtefactB, (BaseArtefact)baseArtefactA, (ChangeEffectKind)ChangeEffectKind.REVOKE, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                BaseArtefactRel baseArtefactRelB = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelB", (BaseArtefact)baseArtefactC, (BaseArtefact)baseArtefactB, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                BaseArtefactRel baseArtefactRelC = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelC", (BaseArtefact)baseArtefactD, (BaseArtefact)baseArtefactC, (ChangeEffectKind)ChangeEffectKind.REVOKE, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                BaseArtefactRel baseArtefactRelD = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelD", (BaseArtefact)baseArtefactE, (BaseArtefact)baseArtefactD, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                resource.getContents().add((Object)notImpactingArtefact);
                resource.getContents().add((Object)baseArtefactA);
                resource.getContents().add((Object)baseArtefactB);
                resource.getContents().add((Object)baseArtefactC);
                resource.getContents().add((Object)baseArtefactD);
                resource.getContents().add((Object)baseArtefactE);
                resource.getContents().add((Object)artefactA);
                resource.getContents().add((Object)artefactE);
                resource.getContents().add((Object)baseArtefactRelA);
                resource.getContents().add((Object)baseArtefactRelB);
                resource.getContents().add((Object)baseArtefactRelC);
                resource.getContents().add((Object)baseArtefactRelD);
            }
        }.executeReadWriteOperation();
    }

    private static void createAdvancedImpactStructure() {
        new SimpleInTransactionExecutor(){

            public void executeInTransaction(CDOTransaction cdoTransaction) {
                Resource resource = StandaloneCDOAccessor.getDefaultResource((CDOTransaction)cdoTransaction);
                BaseArtefact notImpactingArtefact = DataCreationRoutines.createBaseArtefact((String)"NotImpactingArtefact", (int)1);
                BaseArtefact baseArtefactA = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactAA", (int)1);
                BaseArtefact baseArtefactB = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactBB", (int)2);
                BaseArtefact baseArtefactC = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactCC", (int)3);
                BaseArtefact baseArtefactD = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactDD", (int)4);
                BaseArtefact baseArtefactE = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactEE", (int)5);
                Artefact artefact00 = DataCreationRoutines.createArtefact((String)"Artefact00", (int)1);
                Artefact artefactA = DataCreationRoutines.createArtefact((String)"ArtefactAA", (int)1);
                Artefact artefactE = DataCreationRoutines.createArtefact((String)"ArtefactEE", (int)5);
                Artefact artefactZ = DataCreationRoutines.createArtefact((String)"ArtefactZZ", (int)5);
                Artefact artefactB = DataCreationRoutines.createArtefact((String)"ArtefactBB", (int)1);
                Artefact artefactC = DataCreationRoutines.createArtefact((String)"ArtefactCC", (int)5);
                Artefact artefactD = DataCreationRoutines.createArtefact((String)"ArtefactDD", (int)5);
                ArtefactRel artefactRel00 = DataCreationRoutines.createArtefactRel((String)"ArtefactRel00", (Artefact)artefactA, (Artefact)artefact00, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                ArtefactRel artefactRelZZ = DataCreationRoutines.createArtefactRel((String)"ArtefactRelZZ", (Artefact)artefactZ, (Artefact)artefactE, (ChangeEffectKind)ChangeEffectKind.VALIDATE, (ChangeEffectKind)ChangeEffectKind.VALIDATE);
                BaseComplianceMap complianceMapA = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapA.setType(MapKind.FULL);
                BaseComplianceMap complianceMapE = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapE.setType(MapKind.FULL);
                BaseComplianceMap complianceMapB = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapB.setType(MapKind.FULL);
                BaseComplianceMap complianceMapC = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapC.setType(MapKind.FULL);
                BaseComplianceMap complianceMapD = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapD.setType(MapKind.FULL);
                complianceMapA.getTarget().add((Object)artefactA);
                complianceMapE.getTarget().add((Object)artefactE);
                complianceMapB.getTarget().add((Object)artefactB);
                complianceMapC.getTarget().add((Object)artefactC);
                complianceMapD.getTarget().add((Object)artefactD);
                baseArtefactA.getComplianceMap().add((Object)complianceMapA);
                baseArtefactE.getComplianceMap().add((Object)complianceMapE);
                baseArtefactB.getComplianceMap().add((Object)complianceMapB);
                baseArtefactC.getComplianceMap().add((Object)complianceMapC);
                baseArtefactD.getComplianceMap().add((Object)complianceMapD);
                BaseArtefactRel baseArtefactRelA = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelAA", (BaseArtefact)baseArtefactB, (BaseArtefact)baseArtefactA, (ChangeEffectKind)ChangeEffectKind.REVOKE, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                BaseArtefactRel baseArtefactRelB = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelBB", (BaseArtefact)baseArtefactC, (BaseArtefact)baseArtefactB, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                BaseArtefactRel baseArtefactRelC = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelCC", (BaseArtefact)baseArtefactD, (BaseArtefact)baseArtefactC, (ChangeEffectKind)ChangeEffectKind.REVOKE, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                BaseArtefactRel baseArtefactRelD = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelDD", (BaseArtefact)baseArtefactE, (BaseArtefact)baseArtefactD, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                resource.getContents().add((Object)artefactRel00);
                resource.getContents().add((Object)artefactRelZZ);
                resource.getContents().add((Object)notImpactingArtefact);
                resource.getContents().add((Object)baseArtefactA);
                resource.getContents().add((Object)baseArtefactB);
                resource.getContents().add((Object)baseArtefactC);
                resource.getContents().add((Object)baseArtefactD);
                resource.getContents().add((Object)baseArtefactE);
                resource.getContents().add((Object)artefact00);
                resource.getContents().add((Object)artefactA);
                resource.getContents().add((Object)artefactE);
                resource.getContents().add((Object)artefactZ);
                resource.getContents().add((Object)artefactB);
                resource.getContents().add((Object)artefactC);
                resource.getContents().add((Object)artefactD);
                resource.getContents().add((Object)baseArtefactRelA);
                resource.getContents().add((Object)baseArtefactRelB);
                resource.getContents().add((Object)baseArtefactRelC);
                resource.getContents().add((Object)baseArtefactRelD);
            }
        }.executeReadWriteOperation();
    }

    private static void createAdvancedImpactStructureWIthMultipleMappings() {
        new SimpleInTransactionExecutor(){

            public void executeInTransaction(CDOTransaction cdoTransaction) {
                Resource resource = StandaloneCDOAccessor.getDefaultResource((CDOTransaction)cdoTransaction);
                BaseArtefact notImpactingArtefact = DataCreationRoutines.createBaseArtefact((String)"NotImpactingArtefact", (int)1);
                BaseArtefact baseArtefactA = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactAAAA", (int)1);
                BaseArtefact baseArtefactB = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactBBBB", (int)2);
                BaseArtefact baseArtefactC = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactCCCC", (int)3);
                BaseArtefact baseArtefactD = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactDDDD", (int)4);
                BaseArtefact baseArtefactE = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactEEEE", (int)5);
                BaseArtefact baseArtefactB2 = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactBBBB2", (int)2);
                BaseArtefact baseArtefactC2 = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactCCCC2", (int)3);
                BaseArtefact baseArtefactD2 = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactDDDD2", (int)4);
                BaseArtefact baseArtefactZ2 = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactZZZZ2", (int)5);
                BaseArtefact baseArtefactB3 = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactBBBB3", (int)2);
                BaseArtefact baseArtefactC3 = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactCCCC3", (int)3);
                BaseArtefact baseArtefactD3 = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactDDDD3", (int)4);
                BaseArtefact baseArtefactZ3 = DataCreationRoutines.createBaseArtefact((String)"BaseArtefactZZZZ3", (int)5);
                Artefact artefact00 = DataCreationRoutines.createArtefact((String)"Artefact000", (int)1);
                Artefact artefactA = DataCreationRoutines.createArtefact((String)"ArtefactAAAA", (int)1);
                Artefact artefactE = DataCreationRoutines.createArtefact((String)"ArtefactEEEE", (int)5);
                Artefact artefactZ = DataCreationRoutines.createArtefact((String)"ArtefactZZZZ", (int)5);
                Artefact artefactB = DataCreationRoutines.createArtefact((String)"ArtefactBBBB", (int)1);
                Artefact artefactC = DataCreationRoutines.createArtefact((String)"ArtefactCCCC", (int)5);
                Artefact artefactD = DataCreationRoutines.createArtefact((String)"ArtefactDDDD", (int)5);
                Artefact artefactB3 = DataCreationRoutines.createArtefact((String)"ArtefactBBBB3", (int)1);
                Artefact artefactC3 = DataCreationRoutines.createArtefact((String)"ArtefactCCCC3", (int)5);
                Artefact artefactD3 = DataCreationRoutines.createArtefact((String)"ArtefactDDDD3", (int)5);
                Artefact artefactZ3 = DataCreationRoutines.createArtefact((String)"ArtefactZZZZ3", (int)5);
                ArtefactRel artefactRel00 = DataCreationRoutines.createArtefactRel((String)"ArtefactRel0000", (Artefact)artefactA, (Artefact)artefact00, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                ArtefactRel artefactRelZZ = DataCreationRoutines.createArtefactRel((String)"ArtefactRelZZZZ", (Artefact)artefactZ, (Artefact)artefactE, (ChangeEffectKind)ChangeEffectKind.VALIDATE, (ChangeEffectKind)ChangeEffectKind.VALIDATE);
                BaseComplianceMap complianceMapA = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapA.setType(MapKind.FULL);
                BaseComplianceMap complianceMapE = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapE.setType(MapKind.FULL);
                BaseComplianceMap complianceMapB = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapB.setType(MapKind.FULL);
                BaseComplianceMap complianceMapC = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapC.setType(MapKind.FULL);
                BaseComplianceMap complianceMapD = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapD.setType(MapKind.FULL);
                BaseComplianceMap complianceMapB2 = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapB.setType(MapKind.FULL);
                BaseComplianceMap complianceMapC2 = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapC.setType(MapKind.FULL);
                BaseComplianceMap complianceMapD2 = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapD.setType(MapKind.FULL);
                BaseComplianceMap complianceMapZ2 = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapE.setType(MapKind.FULL);
                BaseComplianceMap complianceMapB3 = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapB.setType(MapKind.FULL);
                BaseComplianceMap complianceMapC3 = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapC.setType(MapKind.FULL);
                BaseComplianceMap complianceMapD3 = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapD.setType(MapKind.FULL);
                BaseComplianceMap complianceMapZ3 = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapE.setType(MapKind.FULL);
                complianceMapA.getTarget().add((Object)artefactA);
                complianceMapE.getTarget().add((Object)artefactE);
                complianceMapB.getTarget().add((Object)artefactB);
                complianceMapC.getTarget().add((Object)artefactC);
                complianceMapD.getTarget().add((Object)artefactD);
                complianceMapB2.getTarget().add((Object)artefactB);
                complianceMapC2.getTarget().add((Object)artefactC);
                complianceMapD2.getTarget().add((Object)artefactD);
                complianceMapZ2.getTarget().add((Object)artefactZ);
                complianceMapB3.getTarget().add((Object)artefactB3);
                complianceMapC3.getTarget().add((Object)artefactC3);
                complianceMapD3.getTarget().add((Object)artefactD3);
                complianceMapZ3.getTarget().add((Object)artefactZ3);
                baseArtefactA.getComplianceMap().add((Object)complianceMapA);
                baseArtefactE.getComplianceMap().add((Object)complianceMapE);
                baseArtefactB.getComplianceMap().add((Object)complianceMapB);
                baseArtefactC.getComplianceMap().add((Object)complianceMapC);
                baseArtefactD.getComplianceMap().add((Object)complianceMapD);
                baseArtefactB2.getComplianceMap().add((Object)complianceMapB2);
                baseArtefactC2.getComplianceMap().add((Object)complianceMapC2);
                baseArtefactD2.getComplianceMap().add((Object)complianceMapD2);
                baseArtefactZ2.getComplianceMap().add((Object)complianceMapZ2);
                baseArtefactB3.getComplianceMap().add((Object)complianceMapB3);
                baseArtefactC3.getComplianceMap().add((Object)complianceMapC3);
                baseArtefactD3.getComplianceMap().add((Object)complianceMapD3);
                baseArtefactZ3.getComplianceMap().add((Object)complianceMapZ3);
                BaseArtefactRel baseArtefactRelA = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelAA", (BaseArtefact)baseArtefactB, (BaseArtefact)baseArtefactA, (ChangeEffectKind)ChangeEffectKind.REVOKE, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                BaseArtefactRel baseArtefactRelB = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelBB", (BaseArtefact)baseArtefactC, (BaseArtefact)baseArtefactB, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                BaseArtefactRel baseArtefactRelC = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelCC", (BaseArtefact)baseArtefactD, (BaseArtefact)baseArtefactC, (ChangeEffectKind)ChangeEffectKind.REVOKE, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                BaseArtefactRel baseArtefactRelD = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelDD", (BaseArtefact)baseArtefactE, (BaseArtefact)baseArtefactD, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.MODIFY);
                BaseArtefactRel baseArtefactRelB2 = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelBB2", (BaseArtefact)baseArtefactB3, (BaseArtefact)baseArtefactB2, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                BaseArtefactRel baseArtefactRelC2 = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelCC2", (BaseArtefact)baseArtefactC3, (BaseArtefact)baseArtefactC2, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                BaseArtefactRel baseArtefactRelD2 = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelDD2", (BaseArtefact)baseArtefactD3, (BaseArtefact)baseArtefactD2, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                BaseArtefactRel baseArtefactRelZ2 = DataCreationRoutines.createBaseArtefactRel((String)"BaseArtefactRelZZ2", (BaseArtefact)baseArtefactZ3, (BaseArtefact)baseArtefactZ2, (ChangeEffectKind)ChangeEffectKind.MODIFY, (ChangeEffectKind)ChangeEffectKind.REVOKE);
                resource.getContents().add((Object)artefactRel00);
                resource.getContents().add((Object)artefactRelZZ);
                resource.getContents().add((Object)notImpactingArtefact);
                resource.getContents().add((Object)baseArtefactA);
                resource.getContents().add((Object)baseArtefactB);
                resource.getContents().add((Object)baseArtefactC);
                resource.getContents().add((Object)baseArtefactD);
                resource.getContents().add((Object)baseArtefactE);
                resource.getContents().add((Object)baseArtefactB2);
                resource.getContents().add((Object)baseArtefactC2);
                resource.getContents().add((Object)baseArtefactD2);
                resource.getContents().add((Object)baseArtefactZ2);
                resource.getContents().add((Object)baseArtefactB3);
                resource.getContents().add((Object)baseArtefactC3);
                resource.getContents().add((Object)baseArtefactD3);
                resource.getContents().add((Object)baseArtefactZ3);
                resource.getContents().add((Object)artefact00);
                resource.getContents().add((Object)artefactA);
                resource.getContents().add((Object)artefactE);
                resource.getContents().add((Object)artefactZ);
                resource.getContents().add((Object)artefactB);
                resource.getContents().add((Object)artefactC);
                resource.getContents().add((Object)artefactD);
                resource.getContents().add((Object)artefactB3);
                resource.getContents().add((Object)artefactC3);
                resource.getContents().add((Object)artefactD3);
                resource.getContents().add((Object)artefactZ3);
                resource.getContents().add((Object)baseArtefactRelA);
                resource.getContents().add((Object)baseArtefactRelB);
                resource.getContents().add((Object)baseArtefactRelC);
                resource.getContents().add((Object)baseArtefactRelD);
                resource.getContents().add((Object)baseArtefactRelB2);
                resource.getContents().add((Object)baseArtefactRelC2);
                resource.getContents().add((Object)baseArtefactRelD2);
                resource.getContents().add((Object)baseArtefactRelZ2);
            }
        }.executeReadWriteOperation();
    }

    private static void createUseCaseTest() {
        new SimpleInTransactionExecutor(){

            public void executeInTransaction(CDOTransaction cdoTransaction) {
                StandaloneCDOAccessor.getDefaultResource((CDOTransaction)cdoTransaction);
                BaseComplianceMap complianceMapA = BaselineFactory.eINSTANCE.createBaseComplianceMap();
                complianceMapA.setType(MapKind.FULL);
                complianceMapA.setName("complianceMapA");
                MapJustification createMapJustification = MappingFactory.eINSTANCE.createMapJustification();
                createMapJustification.setExplanation("expl");
                complianceMapA.setMapJustification(createMapJustification);
                BaseArtefact baseArtefact = BaseFrameworkImpactStructureCreator.getBaseArtefactByCdoId(3942L, cdoTransaction);
                Artefact artefact = BaseFrameworkImpactStructureCreator.getArtefactByCdoId(6491L, cdoTransaction);
                complianceMapA.getTarget().add((Object)artefact);
                baseArtefact.getComplianceMap().add((Object)complianceMapA);
            }
        }.executeReadWriteOperation();
    }

    private static Artefact getArtefactByCdoId(Long cdoId, CDOTransaction cdoTransaction) {
        CDOQuery query = cdoTransaction.createQuery("sql", "select * from evidence_artefact where cdo_id = " + cdoId + CDOStorageUtil.getMandatoryCDOQuerySuffix());
        Artefact artefact = (Artefact)query.getResultValue(Artefact.class);
        if (artefact == null) {
            throw new RuntimeException("Root impacting artefact doesn't exist in database");
        }
        return artefact;
    }

    private static BaseArtefact getBaseArtefactByCdoId(Long cdoId, CDOTransaction cdoTransaction) {
        CDOQuery query = cdoTransaction.createQuery("sql", "select * from baseline_baseartefact where cdo_id = " + cdoId + CDOStorageUtil.getMandatoryCDOQuerySuffix());
        BaseArtefact artefact = (BaseArtefact)query.getResultValue(BaseArtefact.class);
        if (artefact == null) {
            throw new RuntimeException("Root impacting artefact doesn't exist in database");
        }
        return artefact;
    }
}

