/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.uml.tools.utils.ObjectFlowUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ObjectFlow;

public class ObjectFlowReorientCommand
extends EditElementCommand {
    protected final int reorientDirection;
    protected final EObject oldEnd;
    protected final EObject newEnd;

    public ObjectFlowReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof ObjectFlow)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ActivityNode) || !(this.newEnd instanceof ActivityNode)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Activity)) {
            return false;
        }
        return ObjectFlowUtil.canExistObjectFlow((Activity)((Activity)this.getLink().eContainer()), (ObjectFlow)this.getLink(), (ActivityNode)this.getNewSource(), (ActivityNode)this.getLink().getTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ActivityNode) || !(this.newEnd instanceof ActivityNode)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Activity)) {
            return false;
        }
        return ObjectFlowUtil.canExistObjectFlow((Activity)((Activity)this.getLink().eContainer()), (ObjectFlow)this.getLink(), (ActivityNode)this.getLink().getSource(), (ActivityNode)this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setSource(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTarget(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected ObjectFlow getLink() {
        return (ObjectFlow)this.getElementToEdit();
    }

    protected ActivityNode getOldSource() {
        return (ActivityNode)this.oldEnd;
    }

    protected ActivityNode getNewSource() {
        return (ActivityNode)this.newEnd;
    }

    protected ActivityNode getOldTarget() {
        return (ActivityNode)this.oldEnd;
    }

    protected ActivityNode getNewTarget() {
        return (ActivityNode)this.newEnd;
    }
}

