/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.command.NotContainmentMoveCommand;
import org.eclipse.papyrus.uml.service.types.helper.ActivityGroupHelper;
import org.eclipse.papyrus.uml.service.types.helper.ActivityNodeHelper;
import org.eclipse.papyrus.uml.service.types.messages.Messages;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityPartitionEditHelper
extends ActivityGroupHelper {
    protected ICommand getCreateCommand(CreateElementRequest req) {
        CreateElementRequest createRequest = this.isActivityNode(req.getElementType()) ? this.getCreatePartitionChildRequest(req) : req;
        return super.getCreateCommand(createRequest);
    }

    protected CreateElementRequest getCreatePartitionChildRequest(CreateElementRequest req) {
        if (req == null) {
            return null;
        }
        CreateElementRequest result = new CreateElementRequest(req.getEditingDomain(), (EObject)this.findActivity(req.getContainer()), req.getElementType());
        result.setParameter("IN_PARTITION", (Object)req.getContainer());
        result.setContainmentFeature(this.findActivityFeature(req.getElementType().getEClass()));
        return result;
    }

    protected ICommand getMoveCommand(MoveRequest req) {
        if (req != null && req.getTargetContainer() instanceof ActivityPartition) {
            CompositeCommand result = new CompositeCommand(Messages.ActivityPartitionEditHelper_0);
            for (Object movedElement : req.getElementsToMove().keySet()) {
                if (movedElement instanceof ActivityNode) {
                    result.add((IUndoableOperation)this.createMoveActivityNodeCommand(req, (ActivityNode)movedElement));
                    continue;
                }
                result.add((IUndoableOperation)this.createDefaultMoveCommand(req, (EObject)movedElement));
            }
            if (!result.isEmpty()) {
                result.compose((IUndoableOperation)ActivityNodeHelper.getMoveOutFromPartitionCommand(req));
                result.compose((IUndoableOperation)ActivityNodeHelper.getMoveOutFromInterruptibleActivityRegionCommand(req));
            }
            return result;
        }
        return super.getMoveCommand(req);
    }

    private ICommand createMoveActivityNodeCommand(MoveRequest baseRequest, ActivityNode node) {
        CompositeCommand cc = new CompositeCommand(Messages.ActivityPartitionEditHelper_1);
        ActivityPartition partition = (ActivityPartition)baseRequest.getTargetContainer();
        EReference containmentFeature = this.findActivityFeature(node.eClass());
        Activity activity = this.findActivity((EObject)partition);
        MoveRequest moveActivityNodesReq = new MoveRequest(baseRequest.getEditingDomain(), (EObject)activity, containmentFeature, (EObject)node);
        cc.add((IUndoableOperation)new NotContainmentMoveCommand(moveActivityNodesReq));
        cc.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)partition, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityPartition_Node(), (Object)node)));
        return cc;
    }

    private ICommand createDefaultMoveCommand(MoveRequest baseRequest, EObject movedElement) {
        EReference containmentFeature = baseRequest.getTargetFeature(movedElement);
        MoveRequest moveRequest = new MoveRequest(baseRequest.getEditingDomain(), baseRequest.getTargetContainer(), containmentFeature, movedElement);
        return super.getMoveCommand(moveRequest);
    }

    protected Activity findActivity(EObject editElement) {
        if (editElement instanceof ActivityPartition) {
            ActivityPartition partition = (ActivityPartition)editElement;
            if (partition.eContainer() instanceof Activity) {
                return (Activity)partition.eContainer();
            }
            return this.findActivity(partition.eContainer());
        }
        return null;
    }

    protected EReference findActivityFeature(EClass eClass) {
        if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(eClass)) {
            return UMLPackage.eINSTANCE.getActivity_StructuredNode();
        }
        if (UMLPackage.eINSTANCE.getActivityNode().isSuperTypeOf(eClass)) {
            return UMLPackage.eINSTANCE.getActivity_OwnedNode();
        }
        return null;
    }

    @Override
    protected boolean approveRequest(IEditCommandRequest request) {
        if (!(request instanceof CreateElementRequest)) {
            return super.approveRequest(request);
        }
        return this.approveNonContainmentActivityNode((CreateElementRequest)request);
    }
}

