/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.IntValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.linklf.editparts.LinkLFConnectionNodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusConnectionEndEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.edge.PapyrusEdgeFigure;

public abstract class ConnectionEditPart
extends LinkLFConnectionNodeEditPart
implements IPapyrusEditPart {
    protected static final String LINE_STYLE = "lineStyle";
    protected static final String[] LINE_STYLE_VALUES = new String[]{"none", "hidden", "dotted", "dashed", "solid", "double"};
    protected static final String LINE_DASH_LENGTH = "lineDashLength";
    protected static final String LINE_DASH_GAP = "lineDashGap";
    protected static final String SOURCE_DECORATION = "sourceDecoration";
    protected static final String TARGET_DECORATION = "targetDecoration";
    protected static final String[] DECORATION_VALUES = new String[]{"default", "none"};
    protected static final int LINE_DASH_MIN_LENGTH = 2;
    protected static final int LINE_GAP_MIN_LENGTH = 2;

    public ConnectionEditPart(View view) {
        super(view);
    }

    public void refresh() {
        super.refresh();
        IFigure figure = this.getFigure();
        Object model = this.getModel();
        if (figure instanceof PapyrusEdgeFigure && model instanceof Connector) {
            String decoration;
            Connector connector = (Connector)model;
            PapyrusEdgeFigure edge = (PapyrusEdgeFigure)figure;
            edge.resetStyle();
            String lineStyle = this.extract((StringValueStyle)connector.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), LINE_STYLE));
            int lineDashLength = this.extract((IntValueStyle)connector.getNamedStyle(NotationPackage.eINSTANCE.getIntValueStyle(), LINE_DASH_LENGTH));
            int lineDashGap = this.extract((IntValueStyle)connector.getNamedStyle(NotationPackage.eINSTANCE.getIntValueStyle(), LINE_DASH_GAP));
            if (lineStyle != null) {
                this.setupLineStyle(edge, lineStyle, connector.getLineWidth(), lineDashLength < 2 ? 2 : lineDashLength, lineDashGap < 2 ? 2 : lineDashGap);
            }
            if ("none".equals(decoration = this.extract((StringValueStyle)connector.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), TARGET_DECORATION)))) {
                edge.setTargetDecoration(null);
            }
            if ("none".equals(decoration = this.extract((StringValueStyle)connector.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), SOURCE_DECORATION)))) {
                edge.setSourceDecoration(null);
            }
        }
    }

    private String extract(StringValueStyle style) {
        if (style == null || style.getStringValue() == null || style.getStringValue().isEmpty()) {
            return null;
        }
        return style.getStringValue();
    }

    private int extract(IntValueStyle style) {
        if (style == null) {
            return 0;
        }
        return style.getIntValue();
    }

    private void setupLineStyle(PapyrusEdgeFigure edge, String style, int originalWidth, int lineDashLength, int lineDashGap) {
        if ("hidden".equals(style)) {
            edge.setLineStyle(1);
            edge.setLineWidth(0);
            edge.setVisible(false);
        } else if ("dotted".equals(style)) {
            edge.setLineStyle(3);
            edge.setLineWidth(originalWidth);
        } else if ("dashed".equals(style)) {
            edge.setLineStyle(6);
            edge.setLineWidth(originalWidth);
            edge.setLineDash(new int[]{lineDashLength, lineDashGap});
        } else if ("solid".equals(style)) {
            edge.setLineStyle(1);
            edge.setLineWidth(originalWidth);
        } else if ("double".equals(style)) {
            edge.setLineWidth(originalWidth * 2);
        }
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        Object notifier = notification.getNotifier();
        Object oldValue = notification.getOldValue();
        if (notifier instanceof EAnnotation) {
            if (((EAnnotation)notifier).getSource().equalsIgnoreCase("PapyrusCSSForceValue")) {
                super.refresh();
            }
        } else if (oldValue instanceof EAnnotation && ((EAnnotation)oldValue).getSource().equalsIgnoreCase("PapyrusCSSForceValue")) {
            super.refresh();
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new PapyrusConnectionEndEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLineWidth();
        this.installRouter();
    }
}

