/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.commands.NotFoundException;
import org.eclipse.papyrus.commands.messages.Messages;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForIEvaluationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class RenameDiagramHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.executeTransaction(event);
        return null;
    }

    private void executeTransaction(ExecutionEvent event) {
        TransactionalEditingDomain editingDomain;
        Diagram notationDiagramHelper;
        try {
            IEvaluationContext context = this.getIEvaluationContext(event);
            notationDiagramHelper = this.lookupNotationDiagramChecked(context);
            editingDomain = this.lookupTransactionalEditingDomain(context);
        }
        catch (NotFoundException e) {
            return;
        }
        catch (ServiceException e) {
            return;
        }
        String currentName = notationDiagramHelper.getName();
        String newName = null;
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.RenameDiagramHandler_RenameAnExistingDiagram, Messages.RenameDiagramHandler_NewName, currentName, null);
        if (dialog.open() == 0) {
            newName = dialog.getValue();
            if (newName == null || newName.length() <= 0) {
                return;
            }
        } else {
            return;
        }
        final String name = newName;
        RecordingCommand cmd = new RecordingCommand(editingDomain, this.getCommandName()){

            protected void doExecute() {
                notationDiagramHelper.setName(name);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    public String getCommandName() {
        return Messages.RenameDiagramHandler_RenameDiagram;
    }

    protected IEvaluationContext getIEvaluationContext(ExecutionEvent event) throws NotFoundException {
        try {
            return (IEvaluationContext)event.getApplicationContext();
        }
        catch (ClassCastException e) {
            throw new NotFoundException("IEvaluationContext can't be found.");
        }
    }

    protected Diagram lookupNotationDiagramChecked(IEvaluationContext context) throws NotFoundException, ServiceException {
        IEditorPart editor = ((ISashWindowsContainer)ServiceUtilsForIEvaluationContext.getInstance().getService(ISashWindowsContainer.class, (Object)context)).getActiveEditor();
        if (!(editor instanceof DiagramDocumentEditor)) {
            throw new NotFoundException("Selected editor do not contains Diagram");
        }
        DiagramDocumentEditor diagramEditor = (DiagramDocumentEditor)editor;
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram == null) {
            throw new NotFoundException("Selected editor do not contains Diagram");
        }
        return diagram;
    }

    protected TransactionalEditingDomain lookupTransactionalEditingDomain(IEvaluationContext context) throws ServiceException {
        return ServiceUtilsForIEvaluationContext.getInstance().getTransactionalEditingDomain((Object)context);
    }

    public void setEnabled(Object evaluationContext) {
        if (!(evaluationContext instanceof IEvaluationContext)) {
            this.setBaseEnabled(false);
            return;
        }
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        try {
            this.lookupNotationDiagramChecked(context);
            this.setBaseEnabled(true);
        }
        catch (ServiceException e) {
            this.setBaseEnabled(false);
        }
        catch (NotFoundException e) {
            this.setBaseEnabled(false);
        }
    }
}

