/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.file;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.ProjectEditor;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.project.IPackageImportDescription;
import org.eclipse.pde.core.project.IRequiredBundleDescription;

public class ManifestEditor
extends ProjectEditor
implements IManifestEditor {
    private static final String CRNL = "\r\n";
    private static final String CRNLSP = "\r\n ";
    private static final String SEMICOLON = ";";
    private static final String COMMA = ",";
    private static final String COMMA_SPLIT = ",(?!\\s*\\d)";
    private static final String EQUALS = "=";
    private static final String ASSIGN = ":=";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String IMPORT_PACKAGE = "Import-Package";
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final String SINGLETON = "singleton:=";
    private static final String VISIBILITY = "visibility";
    private static final String REEXPORT = "reexport";
    private static final String VERSION = "version";
    private static final String NAME_ATTRIBUTE = "Name";
    private IFile manifestFile;
    private Optional<Manifest> manifest = Optional.empty();

    public ManifestEditor(IProject project) throws IOException, CoreException {
        super(project);
    }

    public boolean initOk() {
        return this.manifest.isPresent() && this.manifestFile != null;
    }

    @Override
    public void addDependency(String dependency) {
        this.addDependency(dependency, null);
    }

    @Override
    public void init() {
        if (this.initOk()) {
            return;
        }
        if (this.manifestFile == null) {
            this.manifestFile = this.getManifestFile();
        }
        if (this.manifestFile != null) {
            try {
                this.manifest = Optional.of(new Manifest(this.manifestFile.getContents()));
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
                throw new RuntimeException(e);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addDependency(String dependency, String version) {
        if (this.hasDependency(dependency)) {
            Map<String, String> attributes = version == null ? null : Collections.singletonMap("bundle-version", version);
            this.updateDependencies(dependency::equals, attributes, null);
        } else {
            String newDependency = version == null ? dependency : String.format("%s;bundle-version=\"%s\"", dependency, version);
            String requireBundle = this.getMainAttribute("Require-Bundle").map(rb -> String.valueOf(rb) + COMMA + newDependency).orElse(newDependency);
            this.setMainAttribute("Require-Bundle", requireBundle);
        }
    }

    @Override
    public boolean hasDependency(String dependency) {
        Pattern namePattern = Pattern.compile(String.format("(?<=^|,)\\Q%s\\E(?=,|;|$)", dependency));
        return this.getMainAttribute("Require-Bundle").map(rb -> namePattern.matcher((CharSequence)rb).find()).orElse(false);
    }

    public boolean hasPackage(String packageName, String type) {
        Pattern namePattern = Pattern.compile(String.format("(?<=^|,)\\Q%s\\E(?=,|;|$)", packageName));
        return this.getMainAttribute(type).map(ip -> namePattern.matcher((CharSequence)ip).find()).orElse(false);
    }

    @Override
    @Deprecated
    public void setDependenciesVersion(String dependencyPattern, String newVersion) {
        this.updateDependencies(name -> name.contains(dependencyPattern), Collections.singletonMap("bundle-version", newVersion), null);
    }

    private void updateDependencies(Predicate<String> predicate, Map<String, String> attributes, Map<String, String> directives) {
        this.updateHeader("Require-Bundle", predicate, attributes, directives);
    }

    private void updatePackages(Predicate<String> predicate, String type, Map<String, String> attributes, Map<String, String> directives) {
        this.updateHeader(type, predicate, attributes, directives);
    }

    private void updateHeader(String headerName, Predicate<String> predicate, Map<String, String> attributes, Map<String, String> directives) {
        Pattern attributeOrDirective = Pattern.compile("([^:]+)(:?=)([\"']?).*\\3");
        this.transformHeader(headerName, predicate, (dependency, attrs) -> {
            StringBuilder result = new StringBuilder();
            HashMap newAttributes = attributes == null ? Collections.emptyMap() : new HashMap(attributes);
            HashMap newDirectives = directives == null ? Collections.emptyMap() : new HashMap(directives);
            result.append((String)dependency);
            for (String string : attrs) {
                Matcher m = attributeOrDirective.matcher(string);
                if (!m.matches()) {
                    result.append(SEMICOLON).append(string);
                    continue;
                }
                String name = m.group(1);
                boolean explicit = newAttributes.containsKey(name) || newDirectives.containsKey(name);
                String value = (String)newAttributes.remove(name);
                if (value == null) {
                    value = (String)newDirectives.remove(name);
                }
                if (value != null) {
                    result.append(SEMICOLON);
                    result.append(name).append(m.group(2));
                    result.append(m.group(3)).append(value).append(m.group(3));
                    continue;
                }
                if (explicit) continue;
                result.append(SEMICOLON).append(m.group());
            }
            for (Map.Entry entry : newAttributes.entrySet()) {
                result.append(SEMICOLON);
                result.append((String)entry.getKey()).append(EQUALS).append('\"').append((String)entry.getValue()).append('\"');
            }
            for (Map.Entry entry : newDirectives.entrySet()) {
                result.append(SEMICOLON);
                result.append((String)entry.getKey()).append(ASSIGN).append((String)entry.getValue());
            }
            return result.toString();
        });
    }

    private void transformDependencies(Predicate<String> predicate, BiFunction<String, List<String>, String> transformation) {
        this.transformHeader("Require-Bundle", predicate, transformation);
    }

    private void transformImportedPackages(Predicate<String> predicate, BiFunction<String, List<String>, String> transformation) {
        this.transformHeader(IMPORT_PACKAGE, predicate, transformation);
    }

    private void transformHeader(String headerName, Predicate<String> predicate, BiFunction<String, List<String>, String> transformation) {
        String entryList = this.getMainAttribute(headerName).orElse("");
        String[] entries = entryList.isEmpty() ? new String[]{} : entryList.split(COMMA_SPLIT);
        StringBuilder newEntryList = new StringBuilder();
        int i = 0;
        while (i < entries.length) {
            String entry = entries[i];
            List<String> parts = Arrays.asList(entry.split(SEMICOLON));
            String dependencyName = parts.get(0);
            if (!predicate.test(dependencyName)) {
                if (newEntryList.length() > 0) {
                    newEntryList.append(COMMA);
                }
                newEntryList.append(entry);
            } else {
                String transformed = transformation.apply(dependencyName, parts.subList(1, parts.size()));
                if (transformed != null) {
                    if (newEntryList.length() > 0) {
                        newEntryList.append(COMMA);
                    }
                    newEntryList.append(transformed);
                }
            }
            ++i;
        }
        this.setMainAttribute(headerName, newEntryList.length() == 0 ? null : newEntryList.toString());
    }

    @Override
    public void setValue(String key, String value) {
        this.setMainAttribute(key, value);
    }

    @Override
    public void setValue(String key, String name, String value) {
        this.setAttribute(key, name, value);
    }

    void setMainAttribute(String name, String value) {
        if (value == null) {
            this.removeMainAttribute(name);
        } else {
            this.manifest.map(Manifest::getMainAttributes).ifPresent(attrs -> {
                if (!Objects.equals(attrs.getValue(name), value)) {
                    this.touch();
                    attrs.putValue(name, value);
                }
            });
        }
    }

    void setAttribute(String section, String name, String value) {
        if (value == null) {
            this.removeAttribute(section, name);
        } else {
            Optional<Attributes> attributes = this.manifest.map(m -> m.getEntries().computeIfAbsent(section, __ -> new Attributes()));
            attributes.ifPresent(attrs -> {
                if (!Objects.equals(attrs.getValue(name), value)) {
                    this.touch();
                    attrs.putValue(name, value);
                }
            });
        }
    }

    @Override
    public void removeValue(String section, String name) {
        this.removeAttribute(section, name);
    }

    @Override
    public void removeValue(String key) {
        this.removeMainAttribute(key);
    }

    void removeMainAttribute(String name) {
        this.manifest.map(m -> m.getMainAttributes()).ifPresent(attrs -> {
            if (attrs.remove(new Attributes.Name(name)) != null) {
                this.touch();
            }
        });
    }

    void removeAttribute(String section, String name) {
        this.manifest.map(m -> m.getAttributes(section)).ifPresent(attrs -> {
            if (attrs.remove(new Attributes.Name(name)) != null) {
                this.touch();
                if (attrs.isEmpty()) {
                    this.manifest.get().getEntries().remove(section);
                }
            }
        });
    }

    private IFile getManifestFile() {
        IFile manifest = this.getProject().getFile("META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            return manifest;
        }
        return null;
    }

    @Override
    public boolean exists() {
        return super.exists() && this.getManifestFile() != null && this.getSymbolicBundleName() != null && this.getBundleVersion() != null;
    }

    @Override
    protected void doSave() {
        if (this.manifest.isPresent()) {
            HeaderOrder headerOrder = this.getHeaderOrder(this.manifestFile);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                this.manifest.get().write(os);
                final StringReader reader = new StringReader(this.format(this.sortHeaders(os.toString("UTF-8"), headerOrder)));
                this.manifestFile.setContents(new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return reader.read();
                    }
                }, true, true, null);
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
            }
            catch (CoreException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    protected String format(String text) {
        String[] lines = text.split(CRNLSP);
        String non72safe = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            non72safe = String.valueOf(non72safe) + line;
            ++n2;
        }
        lines = non72safe.split(COMMA_SPLIT);
        String newText = "";
        int i = 0;
        while (i < lines.length) {
            newText = String.valueOf(newText) + lines[i].trim();
            if (i < lines.length - 1) {
                newText = String.valueOf(newText) + ",\r\n ";
            }
            ++i;
        }
        return String.valueOf(newText) + CRNL;
    }

    private HeaderOrder getHeaderOrder(IFile manifestFile) {
        Predicate<String> blankLine = Pattern.compile("^\\s*$").asPredicate();
        HeaderOrder.Builder builder = HeaderOrder.builder();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader input = new BufferedReader(new InputStreamReader(manifestFile.getContents(), manifestFile.getCharset()));){
                input.lines().forEach(line -> {
                    int colon;
                    if (blankLine.test((String)line)) {
                        builder.newSection();
                    } else if (!line.startsWith(" ") && (colon = line.indexOf(58)) > 0) {
                        String headerName = line.substring(0, colon).trim();
                        if (NAME_ATTRIBUTE.equals(headerName)) {
                            builder.sectionName(line.substring(colon + 1).trim());
                        } else {
                            builder.addAttribute(headerName);
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Activator.log.error("Failed to scan manifest for headers", (Throwable)e);
        }
        return builder.build();
    }

    private String sortHeaders(String manifest, HeaderOrder headerOrder) {
        StringBuilder result = new StringBuilder(manifest.length());
        String[] sections = Pattern.compile("^\\s*$", 40).split(manifest);
        Pattern attrPattern = Pattern.compile("^(\\w[^:]+):.*?(?=^\\w|\\z)", 40);
        Pattern namePattern = Pattern.compile("^Name:(.*?)$", 40);
        String mainSection = sections[0];
        HashMap<String, String> additionalSections = new HashMap<String, String>();
        int i = 1;
        while (i < sections.length) {
            Matcher nameMatcher = namePattern.matcher(sections[i]);
            if (nameMatcher.find()) {
                additionalSections.put(nameMatcher.group(1).trim(), sections[i]);
            }
            ++i;
        }
        headerOrder.sectionsAsStream(additionalSections.keySet()).forEachOrdered(sectionOrder -> {
            String section;
            String string2 = section = sectionOrder.isMainSection() ? mainSection : (String)additionalSections.remove(sectionOrder.getName());
            if (section != null) {
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                Matcher header = attrPattern.matcher(section);
                while (header.find()) {
                    headers.put(header.group(1), header.group());
                }
                if (!sectionOrder.isMainSection()) {
                    result.append(CRNL);
                }
                for (String headerName : sectionOrder.getAttributeNames()) {
                    String next = (String)headers.remove(headerName);
                    if (next == null) continue;
                    result.append(next);
                }
                for (String remaining : headers.values()) {
                    result.append(remaining);
                }
            }
        });
        return result.toString();
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> files = super.getMissingFiles();
        IFile classpath = this.getProject().getFile("META-INF/MANIFEST.MF");
        if (!classpath.exists()) {
            files.add("META-INF/MANIFEST.MF");
        }
        return files;
    }

    @Override
    public void createFiles(Set<String> files) {
        if (files.contains("META-INF/MANIFEST.MF")) {
            this.manifestFile = this.getProject().getFile("META-INF/MANIFEST.MF");
            if (!this.manifestFile.exists()) {
                try {
                    IContainer parent;
                    String input = "Manifest-Version: 1.0\n";
                    if (!this.manifestFile.getParent().exists() && (parent = this.manifestFile.getParent()) instanceof IFolder && !parent.exists()) {
                        ((IFolder)parent).create(true, false, null);
                    }
                    this.manifestFile.create(this.getInputStream("Manifest-Version: 1.0\n"), true, null);
                    this.manifestFile = this.getProject().getFile("META-INF/MANIFEST.MF");
                }
                catch (CoreException ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
            try {
                Throwable ex = null;
                Object var3_7 = null;
                try (InputStream contents = this.manifestFile.getContents();){
                    this.manifest = Optional.of(new Manifest(contents));
                }
                catch (Throwable throwable) {
                    if (ex == null) {
                        ex = throwable;
                    } else if (ex != throwable) {
                        ex.addSuppressed(throwable);
                    }
                    throw ex;
                }
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            if (this.getSymbolicBundleName() == null) {
                this.setSymbolicBundleName(this.getProject().getName());
            }
            if (this.getBundleVersion() == null) {
                this.setBundleVersion("0.0.1");
            }
        }
    }

    @Override
    public void setSymbolicBundleName(String newName) {
        if (newName == null) {
            newName = "noName";
        }
        this.setMainAttribute(BUNDLE_SYMBOLIC_NAME, newName);
    }

    @Override
    public String getSymbolicBundleName() {
        return this.getMainAttribute(BUNDLE_SYMBOLIC_NAME).map(name -> {
            int semiColon = name.indexOf(SEMICOLON);
            return semiColon >= 0 ? name.substring(0, semiColon) : name;
        }).orElse(null);
    }

    @Override
    public String getBundleVersion() {
        return this.getMainAttribute("Bundle-Version").orElse(null);
    }

    @Override
    public void setBundleVersion(String version) {
        this.setMainAttribute("Bundle-Version", version);
    }

    @Override
    public String getBundleVendor() {
        return this.getMainAttribute("Bundle-Vendor").orElse(null);
    }

    @Override
    public void setBundleVendor(String vendor) {
        this.setMainAttribute("Bundle-Vendor", vendor);
    }

    @Override
    public String getValue(String name) {
        return this.getMainAttribute(name).orElse(null);
    }

    @Override
    public String getValue(String key, String name) {
        return this.getAttribute(key, name).orElse(null);
    }

    Optional<String> getMainAttribute(String name) {
        return this.manifest.map(Manifest::getMainAttributes).map(attrs -> attrs.getValue(name));
    }

    Optional<String> getAttribute(String section, String name) {
        return this.manifest.map(m -> m.getAttributes(section)).map(attrs -> attrs.getValue(name));
    }

    @Override
    public String getBundleName() {
        return this.getMainAttribute("Bundle-Name").orElse(null);
    }

    @Override
    public void setBundleName(String newName) {
        if (newName == null) {
            newName = "noName";
        }
        this.setMainAttribute("Bundle-Name", newName);
    }

    @Override
    public String getBundleLocalization() {
        return this.getMainAttribute("Bundle-Localization").orElse(null);
    }

    @Override
    public void setSingleton(boolean singleton) {
        String[] directives;
        String value = this.getMainAttribute(BUNDLE_SYMBOLIC_NAME).orElse("");
        String[] stringArray = directives = value.isEmpty() ? new String[]{} : value.split(SEMICOLON);
        if (directives.length == 0) {
            return;
        }
        value = directives[0];
        boolean isDefined = false;
        int i = 1;
        while (i < directives.length) {
            String directive = directives[i];
            if (directive.startsWith(SINGLETON)) {
                directive = SINGLETON + singleton;
                isDefined = true;
            }
            value = String.valueOf(value) + SEMICOLON + directive;
            ++i;
        }
        if (!isDefined) {
            value = String.valueOf(value) + ";singleton:=" + singleton;
        }
        this.setMainAttribute(BUNDLE_SYMBOLIC_NAME, value);
    }

    @Override
    public void addImportPackage(String packageName) {
        this.addImportPackage(packageName, null);
    }

    @Override
    public void addImportPackage(String packageName, String version) {
        this.addPackage(packageName, IMPORT_PACKAGE, version);
    }

    @Override
    public void addExportPackage(String packageName) {
        this.addExportPackage(packageName, null);
    }

    @Override
    public void addExportPackage(String packageName, String version) {
        this.addPackage(packageName, EXPORT_PACKAGE, version);
    }

    private void addPackage(String packageName, String type, String version) {
        if (this.hasPackage(packageName, type)) {
            Map<String, String> attributes = version == null ? null : Collections.singletonMap(VERSION, version);
            this.updatePackages(packageName::equals, type, attributes, null);
        } else {
            String newPackage = version == null ? packageName : String.format("%s;version=\"%s\"", packageName, version);
            String importPackage = this.getMainAttribute(type).map(ip -> String.valueOf(ip) + COMMA + newPackage).orElse(newPackage);
            this.setMainAttribute(type, importPackage);
        }
    }

    @Override
    public List<IRequiredBundleDescription> getRequiredBundles() {
        ArrayList<IRequiredBundleDescription> result = new ArrayList<IRequiredBundleDescription>();
        Pattern versionPattern = Pattern.compile("bundle-version=([\"']?)(.*)\\1");
        Pattern optionalPattern = Pattern.compile("resolution:?=([\"']?)optional\\1");
        Pattern reexportPattern = Pattern.compile("visibility:?=([\"']?)reexport\\1");
        IBundleProjectService service = Activator.getDefault().getBundleProjectService();
        String requireBundles = this.getMainAttribute("Require-Bundle").orElse("");
        String[] bundles = requireBundles.isEmpty() ? new String[]{} : requireBundles.split(COMMA_SPLIT);
        int i = 0;
        while (i < bundles.length) {
            String dependency = bundles[i];
            String[] parts = dependency.split(SEMICOLON);
            String name = parts[0];
            VersionRange version = VersionRange.emptyRange;
            boolean optional = false;
            boolean reexported = false;
            int j = 1;
            while (j < parts.length) {
                Matcher m = versionPattern.matcher(parts[j]);
                if (m.matches()) {
                    version = new VersionRange(m.group(2));
                } else {
                    m = optionalPattern.matcher(parts[j]);
                    if (m.matches()) {
                        optional = true;
                    } else {
                        m = reexportPattern.matcher(parts[j]);
                        if (m.matches()) {
                            reexported = true;
                        }
                    }
                }
                ++j;
            }
            result.add(service.newRequiredBundle(name, version, optional, reexported));
            ++i;
        }
        return result;
    }

    @Override
    public List<IPackageImportDescription> getImportedPackages() {
        ArrayList<IPackageImportDescription> result = new ArrayList<IPackageImportDescription>();
        Pattern versionPattern = Pattern.compile("version=([\"']?)(.*)\\1");
        Pattern optionalPattern = Pattern.compile("resolution:?=([\"']?)optional\\1");
        IBundleProjectService service = Activator.getDefault().getBundleProjectService();
        String importedPackages = this.getMainAttribute(IMPORT_PACKAGE).orElse("");
        String[] packages = importedPackages.isEmpty() ? new String[]{} : importedPackages.split(COMMA_SPLIT);
        int i = 0;
        while (i < packages.length) {
            String package_ = packages[i];
            String[] parts = package_.split(SEMICOLON);
            String name = parts[0];
            VersionRange version = VersionRange.emptyRange;
            boolean optional = false;
            int j = 1;
            while (j < parts.length) {
                Matcher m = versionPattern.matcher(parts[j]);
                if (m.matches()) {
                    version = new VersionRange(m.group(2));
                } else {
                    m = optionalPattern.matcher(parts[j]);
                    if (m.matches()) {
                        optional = true;
                    }
                }
                ++j;
            }
            result.add(service.newPackageImport(name, version, optional));
            ++i;
        }
        return result;
    }

    @Override
    public void setRequiredBundleExported(String bundleName, boolean exported) {
        this.updateDependencies(bundleName::equals, null, Collections.singletonMap(VISIBILITY, exported ? REEXPORT : null));
    }

    @Override
    public void removeRequiredBundle(String bundleName) {
        this.transformDependencies(bundleName::equals, (dep, parts) -> null);
    }

    @Override
    public void removeImportedPackage(String packageName) {
        this.transformImportedPackages(packageName::equals, (dep, parts) -> null);
    }

    private static class HeaderOrder {
        private final Section main = new Section();
        private final Map<String, Section> sections = new LinkedHashMap<String, Section>();

        private HeaderOrder() {
        }

        public Section getMainSection() {
            return this.main;
        }

        public Section getSection(String name) {
            name = name.substring(name.indexOf(58) + 1).trim();
            return this.sections.computeIfAbsent(name, Section::new);
        }

        public static Builder builder() {
            return new Builder();
        }

        public Stream<Section> sectionsAsStream(Collection<String> implicitSectionNames) {
            ArrayList<String> newSectionNames = new ArrayList<String>(implicitSectionNames);
            newSectionNames.removeAll(this.sections.keySet());
            return Stream.concat(Stream.concat(Stream.of(this.main), this.sections.values().stream()), newSectionNames.stream().map(this::getSection));
        }

        static final class Builder {
            private HeaderOrder product = new HeaderOrder();
            private Section currentSection = this.product.getMainSection();

            Builder() {
            }

            public Builder newSection() {
                if (!this.currentSection.attributeNames.isEmpty()) {
                    this.currentSection = new Section();
                }
                return this;
            }

            public Builder sectionName(String name) {
                this.currentSection.setName(name);
                this.product.sections.put(name, this.currentSection);
                return this.addAttribute(ManifestEditor.NAME_ATTRIBUTE);
            }

            public Builder addAttribute(String name) {
                this.currentSection.addAttribute(name);
                return this;
            }

            public HeaderOrder build() {
                return this.product;
            }
        }
    }

    private static class Section {
        private static final String MAIN = "$main$";
        private String name;
        private final List<String> attributeNames = new ArrayList<String>();

        Section() {
            this(MAIN);
        }

        Section(String name) {
            this.name = name;
        }

        public boolean isMainSection() {
            return MAIN.equals(this.name);
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        void addAttribute(String name) {
            this.attributeNames.add(name);
        }

        public Iterable<String> getAttributeNames() {
            return this.attributeNames;
        }
    }
}

