/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.migration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.InsertFloatingLabelFromMapCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;

public class ClassReconciler
extends DiagramReconciler {
    private static final String CONTAINMENT_LINK_OLD_VISUAL_ID = "4022";
    private static final String CONTAINMENT_LINK_NEW_VISUAL_ID = "4023";
    private static final String CONTAINMENT_LINK_AFFIXEDNODE_OLD_VISUAL_ID = "3032";
    private static final String ClassEditPart_VISUAL_ID = "2008";
    private static final String ClassFloatingNameEditPart_VISUAL_ID = "8510";
    private static final String AssociationClassEditPart_VISUAL_ID = "2013";
    private static final String AssociationClassFloatingNameEditPart_VISUAL_ID = "8504";
    private static final String AssociationNodeEditPart_VISUAL_ID = "2015";
    private static final String AssociationFloatingNameEditPart_VISUAL_ID = "8521";
    private static final String ClassEditPartCN_VISUAL_ID = "3010";
    private static final String ClassFloatingNameEditPartCN_VISUAL_ID = "8518";
    private static final String ComponentEditPart_VISUAL_ID = "2002";
    private static final String ComponentFloatingNameEditPart_VISUAL_ID = "8503";
    private static final String ComponentEditPartCN_VISUAL_ID = "3021";
    private static final String ComponentFloatingNameEditPartCN_VISUAL_ID = "8513";
    private static final String DataTypeEditPart_VISUAL_ID = "2010";
    private static final String DataTypeFloatingNameEditPart_VISUAL_ID = "8502";
    private static final String DataTypeEditPartCN_VISUAL_ID = "3027";
    private static final String DataTypeFloatingNameEditPartCN_VISUAL_ID = "8520";
    private static final String DependencyNodeEditPart_VISUAL_ID = "2014";
    private static final String DependencyFloatingNameEditPart_VISUAL_ID = "8522";
    private static final String EnumerationEditPart_VISUAL_ID = "2006";
    private static final String EnumerationFloatingNameEditPart_VISUAL_ID = "8508";
    private static final String EnumerationEditPartCN_VISUAL_ID = "3025";
    private static final String EnumerationFloatingNameEditPartCN_VISUAL_ID = "8516";
    private static final String InformationItemEditPart_VISUAL_ID = "2099";
    private static final String InformationItemFloatingNameEditPart_VISUAL_ID = "8512";
    private static final String InformationItemEditPartCN_VISUAL_ID = "3040";
    private static final String InformationItemFloatingNameEditPartCN_VISUAL_ID = "8517";
    private static final String InstanceSpecificationEditPart_VISUAL_ID = "2001";
    private static final String InstanceSpecificationFloatingNameEditPart_VISUAL_ID = "8505";
    private static final String InstanceSpecificationEditPartCN_VISUAL_ID = "3020";
    private static final String InstanceSpecificationFloatingNameEditPartCN_VISUAL_ID = "8509";
    private static final String InterfaceEditPart_VISUAL_ID = "2004";
    private static final String InterfaceFloatingNameEditPart_VISUAL_ID = "8507";
    private static final String InterfaceEditPartCN_VISUAL_ID = "3023";
    private static final String InterfaceFloatingNameEditPartCN_VISUAL_ID = "8515";
    private static final String PrimitiveTypeEditPart_VISUAL_ID = "2009";
    private static final String PrimitiveTypeFloatingNameEditPart_VISUAL_ID = "8511";
    private static final String PrimitiveTypeEditPartCN_VISUAL_ID = "3026";
    private static final String PrimitiveTypeFloatingNameEditPartCN_VISUAL_ID = "8519";
    private static final String SignalEditPart_VISUAL_ID = "2003";
    private static final String SignalFloatingNameEditPart_VISUAL_ID = "8506";
    private static final String SignalEditPartCN_VISUAL_ID = "3022";
    private static final String SignalFloatingNameEditPartCN_VISUAL_ID = "8514";

    public ICommand getReconcileCommand(Diagram diagram) {
        CompositeCommand cc = new CompositeCommand("Migrate Class diagram and derivated diagrams");
        this.updateContainmentLinks(diagram, cc);
        cc.add((IUndoableOperation)new InsertFloatingLabelFromMapCommand(diagram, this.getFloatingLabelMap()));
        return cc;
    }

    private Map<String, String> getFloatingLabelMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ClassEditPart_VISUAL_ID, ClassFloatingNameEditPart_VISUAL_ID);
        map.put(AssociationClassEditPart_VISUAL_ID, AssociationClassFloatingNameEditPart_VISUAL_ID);
        map.put(AssociationNodeEditPart_VISUAL_ID, AssociationFloatingNameEditPart_VISUAL_ID);
        map.put(ClassEditPartCN_VISUAL_ID, ClassFloatingNameEditPartCN_VISUAL_ID);
        map.put(ComponentEditPart_VISUAL_ID, ComponentFloatingNameEditPart_VISUAL_ID);
        map.put(ComponentEditPartCN_VISUAL_ID, ComponentFloatingNameEditPartCN_VISUAL_ID);
        map.put(DataTypeEditPart_VISUAL_ID, DataTypeFloatingNameEditPart_VISUAL_ID);
        map.put(DataTypeEditPartCN_VISUAL_ID, DataTypeFloatingNameEditPartCN_VISUAL_ID);
        map.put(DependencyNodeEditPart_VISUAL_ID, DependencyFloatingNameEditPart_VISUAL_ID);
        map.put(EnumerationEditPart_VISUAL_ID, EnumerationFloatingNameEditPart_VISUAL_ID);
        map.put(EnumerationEditPartCN_VISUAL_ID, EnumerationFloatingNameEditPartCN_VISUAL_ID);
        map.put(InformationItemEditPart_VISUAL_ID, InformationItemFloatingNameEditPart_VISUAL_ID);
        map.put(InformationItemEditPartCN_VISUAL_ID, InformationItemFloatingNameEditPartCN_VISUAL_ID);
        map.put(InstanceSpecificationEditPart_VISUAL_ID, InstanceSpecificationFloatingNameEditPart_VISUAL_ID);
        map.put(InstanceSpecificationEditPartCN_VISUAL_ID, InstanceSpecificationFloatingNameEditPartCN_VISUAL_ID);
        map.put(InterfaceEditPart_VISUAL_ID, InterfaceFloatingNameEditPart_VISUAL_ID);
        map.put(InterfaceEditPartCN_VISUAL_ID, InterfaceFloatingNameEditPartCN_VISUAL_ID);
        map.put(PrimitiveTypeEditPart_VISUAL_ID, PrimitiveTypeFloatingNameEditPart_VISUAL_ID);
        map.put(PrimitiveTypeEditPartCN_VISUAL_ID, PrimitiveTypeFloatingNameEditPartCN_VISUAL_ID);
        map.put(SignalEditPart_VISUAL_ID, SignalFloatingNameEditPart_VISUAL_ID);
        map.put(SignalEditPartCN_VISUAL_ID, SignalFloatingNameEditPartCN_VISUAL_ID);
        return map;
    }

    protected void updateContainmentLinks(Diagram diagram, CompositeCommand cc) {
        cc.add((IUndoableOperation)new UpdateContainmentLinksCommand(diagram));
        TreeIterator allContentIterator = diagram.eAllContents();
        while (allContentIterator.hasNext()) {
            EObject eObject = (EObject)allContentIterator.next();
            if (!(eObject instanceof View) || !((View)eObject).getType().equals(CONTAINMENT_LINK_AFFIXEDNODE_OLD_VISUAL_ID)) continue;
            DeleteCommand cmd = new DeleteCommand((View)eObject);
            cc.add((IUndoableOperation)cmd);
        }
    }

    protected class UpdateContainmentLinksCommand
    extends AbstractCommand {
        protected final Diagram diagram;

        public UpdateContainmentLinksCommand(Diagram diagram) {
            super("Update containementLinks in Class diagram and derivated diagrams");
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            TreeIterator allContentIterator = this.diagram.eAllContents();
            while (allContentIterator.hasNext()) {
                Edge edge;
                View source;
                EObject sourceContainer;
                EObject eObject = (EObject)allContentIterator.next();
                if (!(eObject instanceof Edge) || !((Edge)eObject).getType().equals(ClassReconciler.CONTAINMENT_LINK_OLD_VISUAL_ID) || !((sourceContainer = (source = (edge = (Edge)eObject).getSource()).eContainer()) instanceof View)) continue;
                edge.setSource((View)sourceContainer);
                edge.setType(ClassReconciler.CONTAINMENT_LINK_NEW_VISUAL_ID);
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

