/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.infra.services.labelprovider.service.IDetailLabelProvider;
import org.eclipse.papyrus.infra.ui.internal.emf.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EMFGraphicalContentProvider
extends EncapsulatedContentProvider
implements ISelectionChangedListener {
    private static final String DIALOG_SETTINGS = EMFGraphicalContentProvider.class.getName();
    private static final String HISTORY_SETTINGS = "History";
    private static final String PREVIOUS_SELECTION = "PreviousSelection";
    private static final int HISTORY_MAX_SIZE = 15;
    private static final int MAX_SEARCH_DEPTH = 15;
    protected String historyId;
    protected ViewerFilter patternFilter;
    protected List<EObject> selectionHistory;
    protected CLabel detailLabel;
    protected Object selectedObject;
    protected StructuredViewer viewer;
    protected ResourceSet resourceSet;
    private String currentFilterPattern;
    private TableViewer historyViewer;

    public EMFGraphicalContentProvider(IStructuredContentProvider semanticProvider, ResourceSet resourceSet, String historyId) {
        super(semanticProvider);
        this.historyId = historyId;
        this.resourceSet = resourceSet;
    }

    public void createBefore(Composite parent) {
        this.createPatternFilter(parent);
    }

    protected void createPatternFilter(Composite parent) {
        StringEditor editor = new StringEditor(parent, 0);
        editor.setLabel("Filter:");
        editor.setToolTipText("Enter the name of the element you're looking for. You can use * as a wildcard");
        editor.setValidateOnDelay(true);
        this.patternFilter = new PatternViewerFilter();
        this.currentFilterPattern = "";
        ((PatternViewerFilter)this.patternFilter).setPattern(this.currentFilterPattern);
        editor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                String filterPattern = (String)((StringEditor)editor).getValue();
                ((PatternViewerFilter)EMFGraphicalContentProvider.this.patternFilter).setPattern(filterPattern);
                EMFGraphicalContentProvider.this.viewer.refresh();
                if (!"".equals(filterPattern) && !EMFGraphicalContentProvider.this.currentFilterPattern.equals(filterPattern)) {
                    EMFGraphicalContentProvider.this.findAndRevealFirstMatchingItem();
                    EMFGraphicalContentProvider.this.currentFilterPattern = filterPattern;
                }
            }
        });
        LinkedList<ViewerFilter> filters = new LinkedList<ViewerFilter>(Arrays.asList(this.viewer.getFilters()));
        filters.add(this.patternFilter);
        this.viewer.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
    }

    protected EObject findAndRevealFirstMatchingItem() {
        if (!(this.viewer instanceof TreeViewer)) {
            return null;
        }
        Tree tree = ((TreeViewer)this.viewer).getTree();
        if (tree.getItems().length > 0) {
            return this.revealFirstLeaf(tree.getItem(0), 15);
        }
        return null;
    }

    private EObject revealFirstLeaf(TreeItem item, int maxSearchDepth) {
        if (maxSearchDepth < 1 || !(this.viewer instanceof TreeViewer)) {
            return null;
        }
        TreeViewer treeViewer = (TreeViewer)this.viewer;
        Object[] itemDataArray = Collections.singletonList(item.getData()).toArray();
        treeViewer.setExpandedElements(itemDataArray);
        if (item.getItems().length > 0) {
            return this.revealFirstLeaf(item.getItem(0), maxSearchDepth - 1);
        }
        Object data = item.getData();
        if (data instanceof EObjectTreeElement) {
            EObject semanticElement = ((EObjectTreeElement)data).getEObject();
            this.revealSemanticElement(Collections.singletonList(semanticElement));
            return semanticElement;
        }
        return null;
    }

    @Deprecated
    protected Object getFirstMatchingElement(Object parent) {
        if (parent == null) {
            Object[] objectArray = this.getElements(this.viewer.getInput());
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object parentElement = objectArray[n2];
                Object firstMatch = this.getFirstMatchingElement(parentElement);
                if (firstMatch != null) {
                    return firstMatch;
                }
                ++n2;
            }
            return null;
        }
        Object[] objectArray = this.viewer.getFilters();
        int n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            ViewerFilter filter = objectArray[n3];
            if (!filter.select((Viewer)this.viewer, this.getParent(parent), parent)) {
                return null;
            }
            ++n3;
        }
        if (this.isValidValue(parent)) {
            return parent;
        }
        objectArray = this.getChildren(parent);
        n = objectArray.length;
        n3 = 0;
        while (n3 < n) {
            ViewerFilter childElement = objectArray[n3];
            Object firstMatch = this.getFirstMatchingElement(childElement);
            if (firstMatch != null) {
                return firstMatch;
            }
            ++n3;
        }
        return null;
    }

    public void createAfter(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createHistory(parent);
        this.createDetailArea(parent);
    }

    protected void createHistory(Composite parent) {
        this.initSelectionHistory();
        Group historyGroup = new Group(parent, 0);
        historyGroup.setText("Recent selections");
        historyGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        historyGroup.setLayout((Layout)new GridLayout(1, true));
        Table historyTable = new Table((Composite)historyGroup, 2052);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 70;
        historyTable.setLayoutData((Object)data);
        this.historyViewer = new TableViewer(historyTable);
        this.historyViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.historyViewer.setLabelProvider(this.viewer.getLabelProvider());
        this.historyViewer.setInput(this.selectionHistory);
        this.historyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)EMFGraphicalContentProvider.this.historyViewer.getSelection();
                Object selectedObject = selection.getFirstElement();
                if (selectedObject instanceof EObject) {
                    EObject eObject = (EObject)selectedObject;
                    EMFGraphicalContentProvider.this.revealSemanticElement(Collections.singletonList(eObject));
                }
            }
        });
    }

    protected void initSelectionHistory() {
        String[] uriHistory;
        this.selectionHistory = new ArrayList<EObject>(16);
        IDialogSettings historySettings = this.getDialogSettings().getSection(HISTORY_SETTINGS);
        if (historySettings != null && this.resourceSet != null && (uriHistory = historySettings.getArray(PREVIOUS_SELECTION)) != null) {
            String[] stringArray = uriHistory;
            int n = uriHistory.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                try {
                    EObject object = this.resourceSet.getEObject(URI.createURI((String)uri), true);
                    if (object != null && !this.selectionHistory.contains(object)) {
                        this.selectionHistory.add(object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    @Deprecated
    protected void createMetaclassFilter(Composite parent) {
    }

    protected void createDetailArea(Composite parent) {
        this.detailLabel = new CLabel(parent, 2048);
        this.detailLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.updateDetailLabel();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(this.getDialogSettingsIdentifier());
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(this.getDialogSettingsIdentifier());
        }
        return settings;
    }

    private String getDialogSettingsIdentifier() {
        return String.valueOf(DIALOG_SETTINGS) + "_" + this.historyId;
    }

    protected void storeDialog(IDialogSettings settings, Collection<EObject> newValues) {
        this.selectionHistory.removeAll(newValues);
        this.selectionHistory.addAll(0, newValues);
        if (this.selectionHistory.size() > 15) {
            this.selectionHistory = this.selectionHistory.subList(0, 15);
        }
        ArrayList<String> uriList = new ArrayList<String>();
        for (EObject object : this.selectionHistory) {
            URI uri = EcoreUtil.getURI((EObject)object);
            uriList.add(uri.toString());
        }
        IDialogSettings historySettings = settings.getSection(HISTORY_SETTINGS);
        if (historySettings == null) {
            historySettings = settings.addNewSection(HISTORY_SETTINGS);
        }
        historySettings.put(PREVIOUS_SELECTION, uriList.toArray(new String[uriList.size()]));
        this.historyViewer.setInput(this.selectionHistory);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.encapsulated.inputChanged(viewer, oldInput, newInput);
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
            if (newInput != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        } else {
            this.viewer = null;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
        this.updateDetailLabel();
    }

    private void updateDetailLabel() {
        if (this.detailLabel == null || this.detailLabel.isDisposed()) {
            return;
        }
        if (this.selectedObject == null) {
            this.detailLabel.setText("");
            this.detailLabel.setImage(null);
        } else {
            ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
            String description = labelProvider instanceof IDetailLabelProvider ? ((IDetailLabelProvider)labelProvider).getDetail(this.selectedObject) : labelProvider.getText(this.selectedObject);
            this.detailLabel.setText(description);
            this.detailLabel.setImage(labelProvider.getImage(this.selectedObject));
        }
        this.detailLabel.getParent().getParent().layout();
    }

    public void commit(AbstractEditor editor) {
        Iterator selectionIterator = ((IStructuredSelection)this.viewer.getSelection()).iterator();
        LinkedHashSet<EObject> eObjectsToStore = new LinkedHashSet<EObject>();
        while (selectionIterator.hasNext()) {
            Object semanticObject;
            Object selectedElement = selectionIterator.next();
            if (!this.isValidValue(selectedElement) || !((semanticObject = this.getAdaptedValue(selectedElement)) instanceof EObject)) continue;
            eObjectsToStore.add((EObject)semanticObject);
        }
        if (!eObjectsToStore.isEmpty()) {
            this.storeDialog(this.getDialogSettings(), eObjectsToStore);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }
}

