/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.EasingFunctionBase;

public class BackEase
extends EasingFunctionBase {
    private double amplitude = 1.0;

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
    }

    @Override
    public double ease(double normalizedTime) {
        switch (this.getEasingMode()) {
            case EaseIn: {
                return this.easeValue(normalizedTime, this.getAmplitude());
            }
            case EaseOut: {
                return 1.0 - this.easeValue(1.0 - normalizedTime, this.getAmplitude());
            }
            case EaseInOut: {
                normalizedTime /= 0.5;
                if (normalizedTime < 1.0) {
                    return this.easeValue(normalizedTime, this.getAmplitude()) / 2.0;
                }
                return (2.0 - this.easeValue(2.0 - normalizedTime, this.getAmplitude())) / 2.0;
            }
        }
        throw new XWTException(String.valueOf(this.getEasingMode().name()) + " is supported.");
    }

    protected double easeValue(double normalizedTime, double amplitude) {
        return normalizedTime * normalizedTime * normalizedTime - normalizedTime * amplitude * Math.sin(normalizedTime * Math.PI);
    }
}

