/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.wizards;

import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.osgi.framework.Bundle;

public class SWTUtil {
    public static Button createButton(Composite parent, String caption, int buttonStyle, int style) {
        Button button = new Button(parent, buttonStyle);
        GridData gridData = new GridData(style);
        button.setLayoutData((Object)gridData);
        button.setText(caption);
        return button;
    }

    public static Button createButton(Composite parent, Image image) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData(4, 4, false, false, 1, 1);
        button.setLayoutData((Object)gridData);
        button.setImage(image);
        return button;
    }

    public static Button createButton(Composite parent, String caption) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData(4, 4, false, false, 1, 1);
        button.setLayoutData((Object)gridData);
        button.setText(caption);
        return button;
    }

    public static void colorComposite(Composite composite, int color) {
        composite.setBackground(composite.getShell().getDisplay().getSystemColor(color));
    }

    public static Button createButton(Composite parent, String caption, int style) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData(style);
        button.setLayoutData((Object)gridData);
        button.setText(caption);
        return button;
    }

    public static Button createCheckButton(Composite parent, String caption, int style) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData(style);
        button.setLayoutData((Object)gridData);
        button.setText(caption);
        return button;
    }

    public static Button createCheckButton(Composite parent, String caption, int buttonStyle, int style) {
        Button button = new Button(parent, buttonStyle | 0x20);
        GridData gridData = new GridData(style);
        button.setLayoutData((Object)gridData);
        button.setText(caption);
        return button;
    }

    public static Text createText(Composite parent, int width) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = width;
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        return text;
    }

    public static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setFont(parent.getFont());
        return text;
    }

    public static Label createLabel(Composite parent, String caption) {
        Label label = new Label(parent, 64);
        label.setText(caption);
        return label;
    }

    public static Label createLabel(Composite parent, String caption, int style) {
        Label label = new Label(parent, style);
        label.setText(caption);
        return label;
    }

    public static Label createLabel(Composite parent, Image image) {
        Label label = new Label(parent, 16384);
        label.setImage(image);
        label.setLayoutData((Object)new GridData(1808));
        return label;
    }

    public static Group createGroup(Composite parent, int cols, String caption) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(cols, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText(caption);
        return group;
    }

    public static Group createGroup(Composite parent, int cols, String caption, int style) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(cols, false));
        group.setLayoutData((Object)new GridData(style));
        group.setText(caption);
        return group;
    }

    public static Composite createComposite(Composite parent, int cols) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(cols, false);
        composite.setLayout((Layout)layout);
        return composite;
    }

    public static Composite createComposite(Composite parent, int cols, int style) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(style);
        composite.setLayout((Layout)new GridLayout(cols, false));
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    public static ScrolledComposite createScrolledComposite(Composite parent, int cols) {
        ScrolledComposite composite = new ScrolledComposite(parent, 2816);
        composite.setLayout((Layout)new GridLayout(cols, false));
        return composite;
    }

    public static Combo createCombo(Composite parent) {
        return new Combo(parent, 12);
    }

    public static Dialog createDialogWithTreeViewer(Shell shell, final String labelString, final ViewerFilter filter, final AdapterFactoryContentProvider contentProvider, final AdapterFactoryLabelProvider labelProvider, final Object input, final Collection<EObject> selection) {
        return new Dialog(shell){

            protected Control createDialogArea(Composite parent) {
                Composite root = (Composite)super.createDialogArea(parent);
                Composite composite = new Composite(root, 0);
                composite.setLayout((Layout)new GridLayout());
                GridData gridData = new GridData(4, 4, true, true);
                gridData.widthHint = 500;
                gridData.heightHint = 300;
                composite.setLayoutData((Object)gridData);
                if (labelString instanceof String && labelString.length() > 0) {
                    Label label = new Label(composite, 64);
                    label.setText(labelString);
                    GridData data = new GridData(768);
                    label.setLayoutData((Object)data);
                }
                Tree tree = new Tree(composite, 2050);
                tree.setLayoutData((Object)new GridData(4, 4, true, true));
                TreeViewer treeViewer = new TreeViewer(tree);
                treeViewer.setContentProvider((IContentProvider)contentProvider);
                treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
                treeViewer.setInput(input);
                if (filter != null) {
                    treeViewer.addFilter(filter);
                }
                if (selection != null) {
                    treeViewer.setSelection((ISelection)new StructuredSelection(selection.toArray()), true);
                }
                treeViewer.expandAll();
                return root;
            }
        };
    }

    public static void setEnableCompositeAndAllChildren(Composite composite, boolean enable) {
        composite.setEnabled(enable);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enable);
            if (control instanceof Composite) {
                SWTUtil.setEnableCompositeAndAllChildren((Composite)control, enable);
            }
            ++n2;
        }
    }

    public static Image captureImage(String pluginId, String projectRelativeImagePath) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)bundle.getEntry(projectRelativeImagePath));
        return imageDescriptor.createImage();
    }

    public static final void setBoldFont(Control control) {
        FontData[] fontDatas;
        FontData[] fontDataArray = fontDatas = control.getFont().getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setStyle(1);
            ++n2;
        }
        Font newFont = new Font((Device)control.getShell().getDisplay(), fontDatas);
        control.setFont(newFont);
    }

    public static final void setItalicFont(Control control) {
        FontData[] fontDatas;
        FontData[] fontDataArray = fontDatas = control.getFont().getFontData();
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setStyle(2);
            ++n2;
        }
        Font newFont = new Font((Device)control.getShell().getDisplay(), fontDatas);
        control.setFont(newFont);
    }
}

