/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.Etl;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.opencert.apm.assurproj.assuranceproject.provider.AssuranceprojectEditPlugin;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.Etl.EtlTransformParameters;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.Etl.EtlTransformation;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.Etl.RedirectSystemErr;
import org.eclipse.opencert.apm.baseline.baseline.BaseFramework;
import org.eclipse.opencert.apm.baseline.baseline.BaselineFactory;
import org.eclipse.opencert.apm.baseline.baseline.BaselinePackage;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.BaselineDiagramEditorUtil;
import org.eclipse.opencert.apm.baseline.baseline.impl.BaseFrameworkImpl;
import org.eclipse.opencert.sam.arg.arg.ArgFactory;
import org.eclipse.opencert.sam.arg.arg.ArgPackage;
import org.eclipse.opencert.sam.arg.arg.Case;
import org.eclipse.opencert.sam.arg.arg.InformationElementType;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramEditorUtil;
import org.eclipse.opencert.sam.arg.arg.impl.CaseImpl;
import org.osgi.framework.Bundle;

public class CDOTransformHandler {
    private static final String UTF_8 = "UTF-8";
    private static final String ARGUMENTATION = "Argumentation";
    private static final String BASELINE = "baseline";
    private static final String ARG = "arg";
    private static String etlFile = "epsilon/Baseline2Arg.etl";
    private static String modelIURI = "model.baseline";
    private static String modelOURI = "model.arg";
    private static String fileIURI = "model/baseline.ecore";
    private static String fileOURI = "model/arg.ecore";
    private static String pluginInWorkSpace = "";
    private static String pluginPath = "";
    private static String metamodelFiles = "";
    private static String targetmetamodelFiles = "";
    private static String ArgPack = "org.eclipse.opencert.sam.arg.arg";
    private static String ArgBundle = "org.eclipse.opencert.sam.arg";
    private static Object IoldEPackage = null;
    private static Object OoldEPackage = null;
    private CDOResource targetModel;
    private CDOResourceFolder project;
    private EMFPlugin pluginProject;
    private CDOTransaction transaction;
    private String sourceModelFile;
    private String targetModelFile;
    private Resource targetModelResource = null;
    private static Map<EObject, EObject> map = new HashMap<EObject, EObject>();

    private Object setUp(String fileURI) throws Exception {
        Object oldEPackage = null;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        ResourceSetImpl rs = new ResourceSetImpl();
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData(rs.getPackageRegistry());
        rs.getLoadOptions().put("EXTENDED_META_DATA", extendedMetaData);
        Resource r = rs.getResource(URI.createURI((String)fileURI), true);
        EObject eObject = (EObject)r.getContents().get(0);
        if (eObject instanceof EPackage) {
            EPackage p = (EPackage)eObject;
            Object oldEPackage2 = EPackage.Registry.INSTANCE.get((Object)p.getNsURI());
            if (oldEPackage2 != null) {
                oldEPackage = oldEPackage2;
            }
            EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
        }
        return oldEPackage;
    }

    public CDOTransformHandler(CDOResourceFolder project, CDOResource sourceModel, CDOResource targetModel, CDOTransaction transaction) {
        try {
            this.project = project;
            this.pluginProject = AssuranceprojectEditPlugin.INSTANCE;
            this.targetModel = targetModel;
            this.transaction = transaction;
            URL entry = null;
            URL fileURL = null;
            String file = "";
            try {
                String wrong;
                String sname;
                String spluginPath = Platform.getBundle((String)"org.eclipse.opencert.apm.assurproj.wizards").getLocation();
                RedirectSystemErr.out("spluginPath:= ." + spluginPath + ".");
                if (spluginPath.contains("plugins")) {
                    entry = Platform.getBundle((String)"org.eclipse.opencert.apm.assurproj.wizards").getEntry(fileIURI);
                    fileURL = FileLocator.resolve((URL)entry);
                    file = fileURL.getFile();
                    RedirectSystemErr.out("file:= ." + file + ".");
                    pluginPath = String.valueOf(file.substring("file:/".length(), file.indexOf("plugins"))) + "configuration";
                    RedirectSystemErr.out("pluginPath:= ." + pluginPath + ".");
                    sname = Platform.getBundle((String)"org.eclipse.opencert.apm.assurproj.wizards").getSymbolicName();
                    RedirectSystemErr.out("sname:= ." + sname + ".");
                    pluginInWorkSpace = "";
                } else {
                    pluginPath = spluginPath.substring("reference:file:/".length(), spluginPath.length() - 1);
                    RedirectSystemErr.out("pluginPath:= ." + pluginPath + ".");
                    sname = Platform.getBundle((String)"org.eclipse.opencert.apm.assurproj.wizards").getSymbolicName();
                    int index0 = pluginPath.lastIndexOf("/", pluginPath.length() - (sname.length() + 2));
                    pluginInWorkSpace = pluginPath.substring(index0 + 1, pluginPath.lastIndexOf("/"));
                }
                RedirectSystemErr.out("pluginInWorkSpace:= ." + pluginInWorkSpace + ".");
                metamodelFiles = String.valueOf(pluginPath) + "/model/general.ecore, " + pluginPath + "/model/property.ecore, " + pluginPath + "/model/Mapping.ecore, " + pluginPath + "/model/refframework.ecore, " + pluginPath + "/model/assuranceasset.ecore, " + pluginPath + "/model/evidence.ecore, " + pluginPath + "/model/baseline.ecore";
                RedirectSystemErr.out("metamodelFiles:= ." + metamodelFiles + ".");
                if (spluginPath.contains("plugins")) {
                    String file2;
                    entry = Platform.getBundle((String)"org.eclipse.opencert.apm.assurproj.wizards").getEntry(fileIURI);
                    fileURL = FileLocator.resolve((URL)entry);
                    file = fileURL.getFile();
                    RedirectSystemErr.out("metamodelo input0:= ." + file + ".");
                    wrong = file.substring(file.indexOf("plugins"), file.indexOf("/" + fileIURI));
                    file = file2 = file.replace(wrong, "configuration");
                } else {
                    entry = Platform.getBundle((String)"org.eclipse.opencert.apm.assurproj.wizards").getEntry(fileIURI);
                    fileURL = FileLocator.resolve((URL)entry);
                    file = "file:" + fileURL.getFile();
                }
                RedirectSystemErr.out("metamodelo input:= ." + file + ".");
                this.setUp(file);
                RedirectSystemErr.out("version CRF");
                targetmetamodelFiles = String.valueOf(pluginPath) + "/model/general.ecore, " + pluginPath + "/model/property.ecore, " + pluginPath + "/model/Mapping.ecore, " + pluginPath + "/model/assuranceasset.ecore, " + pluginPath + "/model/evidence.ecore, " + pluginPath + "/model/arg.ecore";
                RedirectSystemErr.out("targetmetamodelFiles:= ." + targetmetamodelFiles + ".");
                if (spluginPath.contains("plugins")) {
                    String file2;
                    entry = Platform.getBundle((String)"org.eclipse.opencert.apm.assurproj.wizards").getEntry(fileOURI);
                    fileURL = FileLocator.resolve((URL)entry);
                    file = fileURL.getFile();
                    RedirectSystemErr.out("metamodelo output0:= ." + file + ".");
                    wrong = file.substring(file.indexOf("plugins"), file.indexOf("/" + fileOURI));
                    file = file2 = file.replace(wrong, "configuration");
                } else {
                    entry = Platform.getBundle((String)"org.eclipse.opencert.apm.assurproj.wizards").getEntry(fileOURI);
                    fileURL = FileLocator.resolve((URL)entry);
                    file = "file:" + fileURL.getFile();
                }
                RedirectSystemErr.out("metamodelo output:= ." + file + ".");
                this.setUp(file);
                String modelsPath = System.getProperty("user.home");
                RedirectSystemErr.out("modelsPath:= ." + modelsPath + ".");
                this.sourceModelFile = String.valueOf(modelsPath) + '/' + modelIURI;
                RedirectSystemErr.out("sourceModelFile:= ." + this.sourceModelFile + ".");
                URI modelILocalURI = URI.createFileURI((String)this.sourceModelFile);
                this.createBaselineModel(modelILocalURI, sourceModel);
                this.targetModelFile = String.valueOf(modelsPath) + '/' + modelOURI;
                RedirectSystemErr.out("targetModelFile:= ." + this.targetModelFile + ".");
                URI modelOLocalURI = URI.createFileURI((String)this.targetModelFile);
                this.targetModelResource = this.createArgModel(modelOLocalURI, null);
                RedirectSystemErr.out(" created Arg model ");
            }
            catch (IOException e) {
                e.printStackTrace();
                RedirectSystemErr.out("CDOTransformHandler Exception 1 ." + e.toString());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                RedirectSystemErr.out("CDOTransformHandler Exception 2 ." + e.toString());
            }
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(BASELINE, new GMFResourceFactory());
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(ARG, new GMFResourceFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
            RedirectSystemErr.out("CDOTransformHandler Exception 3 ." + e.toString());
        }
    }

    private void attachModelToResource(EObject model, Resource resource) {
        resource.getContents().add((Object)model);
    }

    private void setCharset(IFile file) {
        if (file == null) {
            return;
        }
        try {
            file.setCharset(UTF_8, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private BaseFramework createBaselineInitialModel() {
        return BaselineFactory.eINSTANCE.createBaseFramework();
    }

    private Resource createBaselineModel(URI modelURI, final CDOResource modelCDO) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        final Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Create Baseline Model File", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                RedirectSystemErr.out("createBaselineModel before createBaselineInitialModel");
                BaseFrameworkImpl model = (BaseFrameworkImpl)CDOTransformHandler.this.createBaselineInitialModel();
                if (modelCDO != null) {
                    EObject bEObject;
                    RedirectSystemErr.out("createBaselineModel before map.clear");
                    map.clear();
                    for (EObject aEObject : modelCDO.getContents()) {
                        bEObject = CDOTransformHandler.this.getCorrespondingEObject(aEObject, "BaselinePackage");
                        if (bEObject == null) continue;
                        modelResource.getContents().add((Object)bEObject);
                    }
                    RedirectSystemErr.out("createBaselineModel before iterator");
                    TreeIterator iterator = modelCDO.getAllContents();
                    while (iterator.hasNext()) {
                        EObject aEObject = (EObject)iterator.next();
                        bEObject = CDOTransformHandler.this.getCorrespondingEObject(aEObject, "BaselinePackage");
                        if (bEObject == null) continue;
                        CDOTransformHandler.this.copyAEObjectToBEObject(aEObject, bEObject, "BaselinePackage");
                    }
                }
                RedirectSystemErr.out("createBaselineModel before attachModelToResource");
                CDOTransformHandler.this.attachModelToResource((EObject)model, modelResource);
                try {
                    RedirectSystemErr.out("createBaselineModel before modelResource.save");
                    modelResource.save(BaselineDiagramEditorUtil.getSaveOptions());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    RedirectSystemErr.out("createBaselineModel exception e.=" + e.toString());
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            RedirectSystemErr.out("createBaselineModel exception e.=" + e.toString());
        }
        this.setCharset(WorkspaceSynchronizer.getFile((Resource)modelResource));
        return modelResource;
    }

    private Case createArgInitialModel() {
        return ArgFactory.eINSTANCE.createCase();
    }

    private Resource createArgModel(URI modelURI, final CDOResource modelCDO) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        final Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Create Argumentation Model File", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CaseImpl model = (CaseImpl)CDOTransformHandler.this.createArgInitialModel();
                if (modelCDO != null) {
                    model = (CaseImpl)modelCDO.getContents().get(0);
                }
                CDOTransformHandler.this.attachModelToResource((EObject)model, modelResource);
                try {
                    modelResource.save(ArgDiagramEditorUtil.getSaveOptions());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.setCharset(WorkspaceSynchronizer.getFile((Resource)modelResource));
        return modelResource;
    }

    public Object execute() throws ExecutionException, IOException {
        Object res = null;
        EtlTransformParameters parameters = this.createTransformParameters(new EtlTransformParameters());
        String sourceModelFilePath = this.sourceModelFile;
        parameters.setSourceModelFilePath(sourceModelFilePath);
        parameters.setTargetModelFilePath(this.targetModelFile);
        parameters.setIOldEPackages(IoldEPackage);
        parameters.setOOldEPackages(OoldEPackage);
        EtlTransformation service = new EtlTransformation(null);
        service.createJob(parameters);
        try {
            BufferedOutputStream outStream;
            FileOutputStream fileOutStream;
            try {
                String modelsPath = System.getProperty("user.home");
                RedirectSystemErr.out("fileStream name:=." + modelsPath + '/' + modelIURI + ".");
                FileInputStream fileStream = new FileInputStream(String.valueOf(modelsPath) + '/' + modelIURI);
                RedirectSystemErr.out("fileStream:=." + fileStream.toString() + ".");
                String fileContentI = new Scanner((InputStream)fileStream, UTF_8).useDelimiter("\\A").next();
                fileStream.close();
                if (fileContentI.contains("xmlns:baseline=\"http://baseline/1.0\"")) {
                    fileOutStream = new FileOutputStream(String.valueOf(modelsPath) + '/' + modelIURI);
                    outStream = new BufferedOutputStream(fileOutStream);
                    outStream.write(fileContentI.getBytes(UTF_8));
                    outStream.flush();
                    outStream.close();
                    fileOutStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            RedirectSystemErr.out(" before service.execute() ");
            service.execute();
            res = service.getResult();
            RedirectSystemErr.out(" res :=." + res + ".");
            RedirectSystemErr.out(" before removing schema from arg model ");
            try {
                RedirectSystemErr.out(" targetModelFile:=. " + this.targetModelFile + ".");
                FileInputStream fileInStream = new FileInputStream(this.targetModelFile);
                String fileContentO = new Scanner((InputStream)fileInStream, UTF_8).useDelimiter("\\A").next();
                fileInStream.close();
                if (fileContentO.contains("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"")) {
                    String newfileContent = fileContentO.replaceAll("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "");
                    newfileContent = newfileContent.replaceAll("xsi:schemaLocation=\"arg ../../../" + pluginInWorkSpace + "/org.eclipse.opencert.apm.assurproj.wizards/model/arg.ecore\"", "");
                    fileOutStream = new FileOutputStream(this.targetModelFile);
                    outStream = new BufferedOutputStream(fileOutStream);
                    outStream.write(newfileContent.getBytes(UTF_8));
                    outStream.flush();
                    outStream.close();
                    fileOutStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            RedirectSystemErr.out(" before updating arg package ");
            EPackage p = (EPackage)OoldEPackage;
            if (p != null) {
                EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
            }
            RedirectSystemErr.out(" before refreshing file content ");
            if (this.targetModelResource.isLoaded()) {
                this.targetModelResource.unload();
                try {
                    this.targetModelResource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            new ResourceSetImpl();
            URI resourceURI = this.targetModel.getURI();
            RedirectSystemErr.out(" before creating CDO Arg model ");
            resourceURI.toString().substring("cdo://opencert".length(), resourceURI.toString().length());
            CDOResource resource = this.transaction.getOrCreateResource(resourceURI.path());
            Case rootObject = this.createArgInitialModel();
            EObject argModel = (EObject)this.targetModelResource.getContents().get(0);
            if (argModel != null) {
                EObject bEObject;
                RedirectSystemErr.out(" argModel = ." + argModel.toString() + ".");
                map.clear();
                for (EObject aEObject : this.targetModelResource.getContents()) {
                    bEObject = this.getCorrespondingEObject(aEObject, "ArgPackage");
                    if (bEObject == null) continue;
                    resource.getContents().add((Object)bEObject);
                }
                TreeIterator iterator = this.targetModelResource.getAllContents();
                while (iterator.hasNext()) {
                    EObject aEObject = (EObject)iterator.next();
                    bEObject = this.getCorrespondingEObject(aEObject, "ArgPackage");
                    if (bEObject == null) continue;
                    this.copyAEObjectToBEObject(aEObject, bEObject, "ArgPackage");
                }
            } else if (rootObject != null) {
                resource.getContents().add((Object)rootObject);
            }
            RedirectSystemErr.out(" before saving CDO Diagram Arg model ");
            resource.save(Collections.EMPTY_MAP);
            this.transaction.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RedirectSystemErr.end();
        return res;
    }

    private Object getTypeProperty(EObject item) {
        Object result = null;
        for (EAttribute attribute : item.eClass().getEAllAttributes()) {
            if (!attribute.getName().equalsIgnoreCase("type")) continue;
            result = item.eGet((EStructuralFeature)attribute);
            break;
        }
        return result;
    }

    Enumerator getEnum(String clase, String name) {
        InformationElementType ret = null;
        if (clase.contains("InformationElementCitation")) {
            InformationElementType tipo;
            ret = tipo = InformationElementType.getByName((String)name);
        }
        return ret;
    }

    Enumerator getEnumByName(String myclass, Object whatInstance, String name) {
        Enumerator returnValue = null;
        try {
            String classNameToBeLoaded = myclass;
            String bundleStr = ArgBundle;
            Bundle bundle = Platform.getBundle((String)bundleStr);
            Class myClass = bundle.loadClass(classNameToBeLoaded);
            Method myMethod = myClass.getMethod("getByName", String.class);
            returnValue = (Enumerator)myMethod.invoke(whatInstance, name);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    private void copyAEObjectToBEObject(EObject aEObject, EObject bEObject, String type) {
        for (EStructuralFeature aFeature : aEObject.eClass().getEAllStructuralFeatures()) {
            EStructuralFeature bFeature;
            if (!aEObject.eIsSet(aFeature) || (bFeature = bEObject.eClass().getEStructuralFeature(aFeature.getName())) == null) continue;
            if (aFeature instanceof EAttribute) {
                try {
                    if (aEObject.eGet(aFeature).getClass().toString().contains("EEnumLiteralImpl")) {
                        String name = ((EEnumLiteral)aEObject.eGet(aFeature)).getInstance().getName();
                        EEnum objeto = (EEnum)((EObject)aEObject.eGet(aFeature)).eContainer();
                        String clase = objeto.getName();
                        Enumerator newValue = this.getEnumByName(String.valueOf(ArgPack) + "." + clase, objeto, name);
                        bEObject.eSet(bFeature, (Object)newValue);
                        continue;
                    }
                    bEObject.eSet(bFeature, aEObject.eGet(aFeature));
                }
                catch (Exception e) {
                    RedirectSystemErr.out(" exception aFeature=." + aFeature.toString() + ". bFeature=." + bFeature.toString() + ". value=." + aEObject.eGet(aFeature).toString() + ".");
                    e.printStackTrace();
                }
                continue;
            }
            BasicEList aList = new BasicEList();
            if (aEObject.eGet(aFeature) instanceof EList) {
                aList = (EList)aEObject.eGet(aFeature);
                BasicEList bList = new BasicEList();
                int i = 0;
                while (i < aList.size()) {
                    EObject objTemp = this.getCorrespondingEObject((EObject)aList.get(i), type);
                    if (objTemp != null) {
                        bList.add((Object)objTemp);
                    }
                    ++i;
                }
                bEObject.eSet(bFeature, (Object)bList);
                continue;
            }
            EObject objTemp = this.getCorrespondingEObject((EObject)aEObject.eGet(aFeature), type);
            if (objTemp == null) continue;
            bEObject.eSet(bFeature, (Object)objTemp);
        }
    }

    private EObject getCorrespondingEObject(EObject aEObject, String type) {
        EObject bEObject = map.get(aEObject);
        if (bEObject == null) {
            EClass aEClass = aEObject.eClass();
            String bClassName = aEClass.getName();
            EClass bEClass = null;
            if (type.contains("ArgPackage")) {
                bEClass = (EClass)ArgPackage.eINSTANCE.getEClassifier(bClassName);
            } else if (type.contains("BaselinePackage")) {
                bEClass = (EClass)BaselinePackage.eINSTANCE.getEClassifier(bClassName);
            }
            if (bEClass == null) {
                System.out.println("getCorrespondingEObject error: type =." + type + ". & bClassName =." + bClassName + ".");
                return null;
            }
            bEObject = EcoreUtil.create((EClass)bEClass);
            map.put(aEObject, bEObject);
        }
        return bEObject;
    }

    public EtlTransformParameters createTransformParameters(EtlTransformParameters etlTransformParameters) {
        etlTransformParameters.setPluginID("org.eclipse.opencert.apm.assurproj.wizards");
        etlTransformParameters.setEtlTransform(etlFile);
        etlTransformParameters.setSourceMetaModelFilePath(metamodelFiles);
        etlTransformParameters.setSourceName("Baseline");
        etlTransformParameters.setSourceReadOnLoad(true);
        etlTransformParameters.setSourceStoreOnDisposal(false);
        etlTransformParameters.setTargetMetaModelFilePath(targetmetamodelFiles);
        etlTransformParameters.setTargetName("Arg");
        etlTransformParameters.setTargetReadOnLoad(false);
        etlTransformParameters.setTargetStoreOnDisposal(true);
        return etlTransformParameters;
    }
}

