/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.handlers;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.common.handlers.CreateNatTableEditorHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class PolicyDefinedTableHandler
extends CreateNatTableEditorHandler {
    private URI configuration;
    private EObject context;
    private String name;

    public PolicyDefinedTableHandler(URI config, EObject context, String name) {
        this.configuration = config;
        this.context = context;
        this.name = name;
    }

    @Override
    protected EObject getTableContext() {
        return this.context;
    }

    @Override
    protected URI getTableEditorConfigurationURI() {
        return this.configuration;
    }

    public boolean execute(final ViewPrototype prototype) {
        String name;
        String string = name = this.name != null ? this.name : this.askName();
        if (name == null) {
            return false;
        }
        try {
            final ServicesRegistry serviceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.context);
            TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    try {
                        Table table = PolicyDefinedTableHandler.this.doExecute(serviceRegistry, name, this.description);
                        table.setOwner(PolicyDefinedTableHandler.this.context);
                        table.setPrototype((EObject)prototype.getConfiguration());
                    }
                    catch (Exception ex) {
                        Activator.log.error((Throwable)ex);
                    }
                }
            });
            return true;
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return false;
        }
    }
}

