/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.edit.part;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableCompartmentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.RubberbandDragTracker;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.linklf.LinkLFShapeCompartmentEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCompartmentSemanticEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CustomContainerEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.PasteEditPolicy;

public abstract class AbstractShapeCompartmentEditPart
extends LinkLFShapeCompartmentEditPart {
    public AbstractShapeCompartmentEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DefaultCompartmentSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new DefaultCreationEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ResizableCompartmentEditPolicy());
        this.installEditPolicy("PASTE_ROLE", (EditPolicy)new PasteEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new CustomContainerEditPolicy());
    }

    protected void setRatio(Double ratio) {
        if (this.getFigure().getParent().getLayoutManager() instanceof ConstrainedToolbarLayout) {
            super.setRatio(ratio);
        }
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature) || NotationPackage.eINSTANCE.getLocation_X().equals(feature) || NotationPackage.eINSTANCE.getLocation_Y().equals(feature)) {
            this.refreshBounds();
        }
        super.handleNotificationEvent(notification);
    }

    protected void refreshBounds() {
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension size = new Dimension(width, height);
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshBounds();
    }

    public DragTracker getDragTracker(Request req) {
        if (!this.supportsDragSelection()) {
            return super.getDragTracker(req);
        }
        if (req instanceof SelectionRequest && ((SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this){

                protected boolean handleButtonDown(int button) {
                    this.getCurrentViewer().select((EditPart)AbstractShapeCompartmentEditPart.this);
                    return true;
                }
            };
        }
        return new RubberbandDragTracker(){

            protected boolean handleDoubleClick(int button) {
                SelectionRequest request = new SelectionRequest();
                request.setLocation(this.getLocation());
                request.setType((Object)"open");
                AbstractShapeCompartmentEditPart.this.performRequest((Request)request);
                return true;
            }

            protected void handleFinished() {
                if (AbstractShapeCompartmentEditPart.this.getViewer().getSelectedEditParts().isEmpty()) {
                    AbstractShapeCompartmentEditPart.this.getViewer().select((EditPart)AbstractShapeCompartmentEditPart.this);
                }
            }
        };
    }
}

