/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.edit.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.CollaborationHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.CompositeLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.ConnectorHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.DurationObservationHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.TimeObservationHelper;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.TypeHelper;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class CustomDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)CompositeLinkMappingHelper.getInstance());
    }

    protected Set<String> getDroppableElementVisualId() {
        HashSet<String> droppableElementsVisualId = new HashSet<String>();
        droppableElementsVisualId.add("Activity_Shape");
        droppableElementsVisualId.add("Interaction_Shape");
        droppableElementsVisualId.add("ProtocolStateMachine_Shape");
        droppableElementsVisualId.add("StateMachine_Shape");
        droppableElementsVisualId.add("FunctionBehavior_Shape");
        droppableElementsVisualId.add("OpaqueBehavior_Shape");
        droppableElementsVisualId.add("Component_Shape");
        droppableElementsVisualId.add("Device_Shape");
        droppableElementsVisualId.add("ExecutionEnvironment_Shape");
        droppableElementsVisualId.add("Node_Shape");
        droppableElementsVisualId.add("Class_Shape");
        droppableElementsVisualId.add("Collaboration_Shape");
        droppableElementsVisualId.add("Interface_Shape");
        droppableElementsVisualId.add("PrimitiveType_Shape");
        droppableElementsVisualId.add("Enumeration_Shape");
        droppableElementsVisualId.add("DataType_Shape");
        droppableElementsVisualId.add("Actor_Shape");
        droppableElementsVisualId.add("DeploymentSpecification_Shape");
        droppableElementsVisualId.add("Artifact_Shape");
        droppableElementsVisualId.add("InformationItem_Shape");
        droppableElementsVisualId.add("Signal_Shape");
        droppableElementsVisualId.add("UseCase_Shape");
        droppableElementsVisualId.add("SignalEvent_Shape");
        droppableElementsVisualId.add("CallEvent_Shape");
        droppableElementsVisualId.add("AnyReceiveEvent_Shape");
        droppableElementsVisualId.add("ChangeEvent_Shape");
        droppableElementsVisualId.add("TimeEvent_Shape");
        droppableElementsVisualId.add("LiteralBoolean_Shape");
        droppableElementsVisualId.add("LiteralInteger_Shape");
        droppableElementsVisualId.add("LiteralNull_Shape");
        droppableElementsVisualId.add("LiteralString_Shape");
        droppableElementsVisualId.add("LiteralUnlimitedNatural_Shape");
        droppableElementsVisualId.add("StringExpression_PackagedElementShape");
        droppableElementsVisualId.add("OpaqueExpression_Shape");
        droppableElementsVisualId.add("TimeExpression_Shape");
        droppableElementsVisualId.add("Expression_Shape");
        droppableElementsVisualId.add("Duration_Shape");
        droppableElementsVisualId.add("Interval_Shape");
        droppableElementsVisualId.add("InstanceValue_Shape");
        droppableElementsVisualId.add("Comment_Shape");
        droppableElementsVisualId.add("DurationConstraint_Shape");
        droppableElementsVisualId.add("TimeConstraint_Shape");
        droppableElementsVisualId.add("IntervalConstraint_Shape");
        droppableElementsVisualId.add("InteractionConstraint_Shape");
        droppableElementsVisualId.add("Constraint_Shape");
        droppableElementsVisualId.add("Activity_Shape_CN");
        droppableElementsVisualId.add("Interaction_Shape_CN");
        droppableElementsVisualId.add("ProtocolStateMachine_Shape_CN");
        droppableElementsVisualId.add("StateMachine_Shape_CN");
        droppableElementsVisualId.add("FunctionBehavior_Shape_CN");
        droppableElementsVisualId.add("OpaqueBehavior_Shape_CN");
        droppableElementsVisualId.add("Component_Shape_CN");
        droppableElementsVisualId.add("Device_Shape_CN");
        droppableElementsVisualId.add("ExecutionEnvironment_Shape_CN");
        droppableElementsVisualId.add("Node_Shape_CN");
        droppableElementsVisualId.add("Class_Shape_CN");
        droppableElementsVisualId.add("Collaboration_Shape_CN");
        droppableElementsVisualId.add("Collaboration_Shape_CN");
        droppableElementsVisualId.add("Dependency_Edge");
        droppableElementsVisualId.add("Dependency_RoleBindingEdge");
        droppableElementsVisualId.add("Connector_Edge");
        droppableElementsVisualId.add("Port_Shape");
        droppableElementsVisualId.add("Parameter_Shape");
        droppableElementsVisualId.add("Property_Shape");
        droppableElementsVisualId.add("TimeObservation_Shape");
        droppableElementsVisualId.add("DurationObservation_Shape");
        droppableElementsVisualId.add("Comment_Shape_CN");
        droppableElementsVisualId.add("Constraint_Shape_CN");
        return droppableElementsVisualId;
    }

    public IElementType getUMLElementType(String elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public String getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public String getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        block131: {
            block129: {
                if (linkVISUALID == null) break block129;
                switch (linkVISUALID) {
                    case "Dependency_Edge": {
                        return this.dropDependency(dropRequest, semanticElement, linkVISUALID);
                    }
                    case "Dependency_RoleBindingEdge": {
                        return this.dropRoleBinding(dropRequest, semanticElement, linkVISUALID);
                    }
                    case "Connector_Edge": {
                        return this.dropConnector(dropRequest, semanticElement, linkVISUALID);
                    }
                }
            }
            if (nodeVISUALID == null) break block131;
            switch (nodeVISUALID) {
                case "AnyReceiveEvent_Shape": 
                case "LiteralString_Shape": 
                case "Interval_Shape": 
                case "OpaqueBehavior_Shape": 
                case "Component_Shape": 
                case "UseCase_Shape": 
                case "Actor_Shape": 
                case "FunctionBehavior_Shape": 
                case "TimeExpression_Shape": 
                case "StringExpression_PackagedElementShape": 
                case "IntervalConstraint_Shape": 
                case "ProtocolStateMachine_Shape": 
                case "Duration_Shape": 
                case "Enumeration_Shape": 
                case "InformationItem_Shape": 
                case "LiteralInteger_Shape": 
                case "Node_Shape": 
                case "Expression_Shape": 
                case "Signal_Shape": 
                case "Device_Shape": 
                case "Collaboration_Shape": 
                case "SignalEvent_Shape": 
                case "StateMachine_Shape": 
                case "DeploymentSpecification_Shape": 
                case "InstanceValue_Shape": 
                case "OpaqueExpression_Shape": 
                case "InteractionConstraint_Shape": 
                case "TimeEvent_Shape": 
                case "LiteralNull_Shape": 
                case "LiteralUnlimitedNatural_Shape": 
                case "Activity_Shape": 
                case "Class_Shape": 
                case "Interface_Shape": 
                case "ChangeEvent_Shape": 
                case "DurationConstraint_Shape": 
                case "Interaction_Shape": 
                case "Artifact_Shape": 
                case "ExecutionEnvironment_Shape": 
                case "CallEvent_Shape": 
                case "PrimitiveType_Shape": 
                case "DataType_Shape": 
                case "LiteralBoolean_Shape": 
                case "TimeConstraint_Shape": {
                    return this.dropTopLevelNode(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
                }
                case "Port_Shape": {
                    return this.dropAffixedNode(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Parameter_Shape": {
                    return this.dropAffixedNode(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Property_Shape": {
                    return this.dropProperty(dropRequest, (Property)semanticElement, nodeVISUALID);
                }
                case "TimeObservation_Shape": {
                    return this.dropTimeObservation(dropRequest, (TimeObservation)semanticElement, nodeVISUALID);
                }
                case "DurationObservation_Shape": {
                    return this.dropDurationObservation(dropRequest, (DurationObservation)semanticElement, nodeVISUALID);
                }
                case "Comment_Shape": 
                case "Comment_Shape_CN": {
                    return this.dropComment(dropRequest, semanticElement, nodeVISUALID);
                }
                case "Constraint_Shape": 
                case "Constraint_Shape_CN": {
                    return this.dropConstraint(dropRequest, semanticElement, nodeVISUALID);
                }
            }
        }
        return super.getSpecificDropCommand(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
    }

    protected Command dropComment(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if ("Comment_Shape".equals(nodeVISUALID)) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_Shape, (IHintedType)UMLElementTypes.Comment_AnnotatedElementEdge);
        }
        if ("Comment_Shape_CN".equals(nodeVISUALID)) {
            return this.getDropCommentCommand((Comment)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Comment_Shape_CN, (IHintedType)UMLElementTypes.Comment_AnnotatedElementEdge);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropConstraint(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if ("Constraint_Shape".equals(nodeVISUALID)) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_Shape, (IHintedType)UMLElementTypes.Constraint_ConstrainedElementEdge);
        }
        if ("Constraint_Shape_CN".equals(nodeVISUALID)) {
            return this.getDropConstraintCommand((Constraint)semanticLink, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView(), (IHintedType)UMLElementTypes.Constraint_Shape_CN, (IHintedType)UMLElementTypes.Constraint_ConstrainedElementEdge);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropDependency(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> sourceEnds = CompositeLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = CompositeLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = (Element)sourceEnds.toArray()[0];
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("Drop Dependency"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropRoleBinding(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> sourceEnds = CompositeLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targetEnds = CompositeLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (sourceEnds != null && targetEnds != null && sourceEnds.size() == 1 && targetEnds.size() == 1) {
            Element source = semanticLink.getOwner();
            Element target = (Element)targetEnds.toArray()[0];
            return new ICommandProxy((ICommand)this.dropBinaryLink(new CompositeCommand("drop RoleBinding"), source, target, linkVISUALID, dropRequest.getLocation(), semanticLink));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropConnector(DropObjectsRequest dropRequest, Element semanticLink, String linkVISUALID) {
        Collection<?> connectorEnds = CompositeLinkMappingHelper.getInstance().getSource(semanticLink);
        if (connectorEnds != null && connectorEnds.size() == 2) {
            ConnectorHelper helper = new ConnectorHelper(this.getEditingDomain());
            return new ICommandProxy((ICommand)helper.dropConnector((Connector)semanticLink, linkVISUALID, this.getViewer(), this.getHost(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView()));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropProperty(DropObjectsRequest dropRequest, Property droppedElement, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        Point location = dropRequest.getLocation().getCopy();
        if (!(droppedElement instanceof Port)) {
            Type type;
            if (graphicalParentObject instanceof Classifier && ((Classifier)graphicalParentObject).getAllAttributes().contains((Object)droppedElement)) {
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement));
            }
            if (graphicalParentObject instanceof ConnectableElement && (type = ((ConnectableElement)graphicalParentObject).getType()) != null && type instanceof Classifier && ((Classifier)type).getAllAttributes().contains((Object)droppedElement)) {
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)droppedElement));
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command dropDurationObservation(DropObjectsRequest dropRequest, DurationObservation droppedElement, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (!(graphicalParentObject instanceof Package)) {
            return UnexecutableCommand.INSTANCE;
        }
        DurationObservationHelper durationObservationHelper = new DurationObservationHelper(this.getEditingDomain());
        return durationObservationHelper.dropDurationObservation(droppedElement, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
    }

    protected Command dropTimeObservation(DropObjectsRequest dropRequest, TimeObservation droppedElement, String nodeVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (!(graphicalParentObject instanceof Package)) {
            return UnexecutableCommand.INSTANCE;
        }
        TimeObservationHelper timeObservationHelper = new TimeObservationHelper(this.getEditingDomain());
        return timeObservationHelper.dropTimeObservation(droppedElement, this.getViewer(), this.getDiagramPreferencesHint(), dropRequest.getLocation(), ((GraphicalEditPart)this.getHost()).getNotationView());
    }

    protected Command dropTopLevelNode(DropObjectsRequest dropRequest, Element semanticElement, String nodeVISUALID, String linkVISUALID) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        if (graphicalParentObject instanceof Package) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropRequest.getLocation(), (EObject)semanticElement));
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        CompoundCommand cc = new CompoundCommand("Drop");
        Iterator iter = dropRequest.getObjects().iterator();
        if (dropRequest.getObjects().size() > 0 && dropRequest.getObjects().get(0) instanceof String) {
            return this.getDropFileCommand(dropRequest);
        }
        Point location = dropRequest.getLocation().getCopy();
        ((GraphicalEditPart)this.getHost()).getContentPane().translateToRelative((Translatable)location);
        ((GraphicalEditPart)this.getHost()).getContentPane().translateFromParent((Translatable)location);
        location.translate(((GraphicalEditPart)this.getHost()).getContentPane().getClientArea().getLocation().getNegated());
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        View graphicalParentView = (View)((GraphicalEditPart)this.getHost()).getModel();
        while (!(graphicalParentView instanceof Diagram) && graphicalParentObject != null && iter.hasNext()) {
            ElementHelper helper;
            EObject droppedObject = (EObject)iter.next();
            if (graphicalParentObject instanceof Collaboration) {
                if (!(droppedObject instanceof Collaboration)) continue;
                helper = new CollaborationHelper(this.getEditingDomain());
                cc.add((Command)helper.dropCollaborationAsCollaborationUse((GraphicalEditPart)this.getHost(), (Collaboration)droppedObject, location));
                continue;
            }
            if (graphicalParentObject instanceof StructuredClassifier) {
                if (!(droppedObject instanceof Collaboration)) continue;
                helper = new CollaborationHelper(this.getEditingDomain());
                cc.add((Command)helper.dropCollaborationAsCollaborationUse((GraphicalEditPart)this.getHost(), (Collaboration)droppedObject, location));
                continue;
            }
            if (graphicalParentObject instanceof TypedElement) {
                if (!(droppedObject instanceof Type) || droppedObject instanceof Association && graphicalParentObject instanceof ConnectableElement) continue;
                helper = new TypeHelper(this.getEditingDomain());
                cc.add((Command)helper.dropTypeOnTypedElement((GraphicalEditPart)this.getHost(), (Type)droppedObject, location));
                continue;
            }
            if (!(graphicalParentObject instanceof CollaborationUse) || !(droppedObject instanceof Collaboration)) continue;
            helper = new CollaborationHelper(this.getEditingDomain());
            cc.add((Command)helper.dropCollaborationOnCollaborationUse((GraphicalEditPart)this.getHost(), (Type)((Collaboration)droppedObject), location));
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        return super.getDropObjectsCommand(dropRequest);
    }

    protected Command getDragCommand(ChangeBoundsRequest request) {
        Boolean isSpecificDrag = false;
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EObject droppedObject = null;
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof GraphicalEditPart) {
                droppedObject = ((GraphicalEditPart)droppedEditPart).resolveSemanticElement();
            }
            isSpecificDrag = this.isSpecificDropActionExpected((GraphicalEditPart)this.getHost(), droppedObject);
        }
        if (isSpecificDrag.booleanValue()) {
            return null;
        }
        return super.getDragCommand(request);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        Boolean isSpecificDrop = false;
        Iterator iter = request.getEditParts().iterator();
        EObject graphicalParentObject = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
        while (graphicalParentObject != null && iter.hasNext()) {
            EObject droppedObject = null;
            EditPart droppedEditPart = (EditPart)iter.next();
            if (droppedEditPart instanceof GraphicalEditPart) {
                droppedObject = ((GraphicalEditPart)droppedEditPart).resolveSemanticElement();
            }
            isSpecificDrop = this.isSpecificDropActionExpected((GraphicalEditPart)this.getHost(), droppedObject);
        }
        if (isSpecificDrop.booleanValue()) {
            return this.getDropObjectsCommand(this.castToDropObjectsRequest(request));
        }
        return super.getDropCommand(request);
    }

    protected boolean isSpecificDropActionExpected(GraphicalEditPart graphicalParent, EObject droppedObject) {
        boolean isSpecificDropActionExpected = false;
        EObject graphicalParentObject = graphicalParent.resolveSemanticElement();
        if (graphicalParentObject != null) {
            if (graphicalParentObject instanceof Collaboration) {
                if (droppedObject instanceof Collaboration || droppedObject instanceof Class) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof StructuredClassifier) {
                if (droppedObject instanceof Collaboration || droppedObject instanceof Class) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof TypedElement) {
                if (droppedObject instanceof Type) {
                    isSpecificDropActionExpected = true;
                }
            } else if (graphicalParentObject instanceof CollaborationUse && droppedObject instanceof Collaboration) {
                isSpecificDropActionExpected = true;
            }
        }
        return isSpecificDropActionExpected;
    }
}

