/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.importer.parser;

import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.opencert.vocabulary.Category;
import org.eclipse.opencert.vocabulary.SourceOfDefinition;
import org.eclipse.opencert.vocabulary.Term;
import org.eclipse.opencert.vocabulary.Vocabulary;
import org.eclipse.opencert.vocabulary.VocabularyFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Parser {
    public static Vocabulary parseVocabulary(InputStream stream) {
        Vocabulary result = null;
        try {
            Node catNode;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            Element vocElement = doc.getDocumentElement();
            String vocName = vocElement.getAttribute("name");
            String vocDescription = vocElement.getAttribute("description");
            result = Parser.createVocabulary(vocName, vocDescription);
            String uri = vocElement.getAttribute("uri");
            SourceOfDefinition sourceOfDefinition = VocabularyFactory.eINSTANCE.createSourceOfDefinition();
            sourceOfDefinition.setUri(uri);
            sourceOfDefinition.setName(vocName);
            sourceOfDefinition.setDescription(vocDescription);
            result.getSourcesOfDefinition().add((Object)sourceOfDefinition);
            HashMap<String, Term> namedTerms = new HashMap<String, Term>();
            NodeList catList = vocElement.getElementsByTagName("category");
            int i = 0;
            while (i < catList.getLength()) {
                catNode = catList.item(i);
                if (catNode.getNodeType() == 1) {
                    Element catElement = (Element)catNode;
                    String catName = catElement.getAttribute("name");
                    String catDescription = catElement.getAttribute("description");
                    Category cat = Parser.createCategory(catName, catDescription);
                    result.getCategories().add((Object)cat);
                    NodeList termList = vocElement.getElementsByTagName("term");
                    int j = 0;
                    while (j < termList.getLength()) {
                        Node termNode = termList.item(j);
                        if (termNode.getNodeType() == 1) {
                            Element termElement = (Element)termNode;
                            Term term = Parser.parseTerm(termElement);
                            term.setDefinedBy(sourceOfDefinition);
                            cat.getTerms().add((Object)term);
                            result.getTerms().add((Object)term);
                            namedTerms.put(term.getName(), term);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < catList.getLength()) {
                catNode = catList.item(i);
                if (catNode.getNodeType() == 1) {
                    NodeList termList = vocElement.getElementsByTagName("term");
                    int j = 0;
                    while (j < termList.getLength()) {
                        Node termNode = termList.item(j);
                        if (termNode.getNodeType() == 1) {
                            String refersToAttrName;
                            String refersToAttrValue;
                            String hasaAttrName;
                            String hasaAttrValue;
                            Element termElement = (Element)termNode;
                            Term source = (Term)namedTerms.get(termElement.getAttribute("name"));
                            String isaAttrName = "isa";
                            String isaAttrValue = termElement.getAttribute(isaAttrName);
                            if (isaAttrValue != null && isaAttrValue.length() > 0) {
                                String[] split;
                                String[] stringArray = split = isaAttrValue.split(",");
                                int n = split.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String s = stringArray[n2];
                                    Term target = (Term)namedTerms.get(s);
                                    if (source != null && target != null) {
                                        source.getIsA().add((Object)target);
                                    }
                                    ++n2;
                                }
                            }
                            if ((hasaAttrValue = termElement.getAttribute(hasaAttrName = "hasa")) != null && hasaAttrValue.length() > 0) {
                                String[] split;
                                String[] stringArray = split = hasaAttrValue.split(",");
                                int target = split.length;
                                int n = 0;
                                while (n < target) {
                                    String s = stringArray[n];
                                    Term target2 = (Term)namedTerms.get(s);
                                    if (source != null && target2 != null) {
                                        source.getHasA().add((Object)target2);
                                    }
                                    ++n;
                                }
                            }
                            if ((refersToAttrValue = termElement.getAttribute(refersToAttrName = "refersto")) != null && refersToAttrValue.length() > 0) {
                                String[] split;
                                String[] stringArray = split = refersToAttrValue.split(",");
                                int n = split.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    String s = stringArray[n3];
                                    Term target = (Term)namedTerms.get(s);
                                    if (source != null && target != null) {
                                        source.getRefersTo().add((Object)target);
                                    }
                                    ++n3;
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Term parseTerm(Element termElement) {
        Term result = VocabularyFactory.eINSTANCE.createTerm();
        String name = termElement.getAttribute("name");
        result.setName(name);
        String synonymString = termElement.getAttribute("synonym");
        if (synonymString != null && synonymString.length() > 0) {
            String[] stringArray = synonymString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                result.getSynonyms().add((Object)s);
                ++n2;
            }
        }
        NodeList definitionNodes = termElement.getElementsByTagName("definition");
        int i = 0;
        while (i < definitionNodes.getLength()) {
            Node definitionNode = definitionNodes.item(i);
            if (definitionNode.getNodeType() == 1) {
                Element definitionElement = (Element)definitionNode;
                String definition = definitionElement.getTextContent();
                result.getDefinitions().add((Object)definition);
            }
            ++i;
        }
        NodeList noteNodes = termElement.getElementsByTagName("note");
        int i2 = 0;
        while (i2 < noteNodes.getLength()) {
            Node noteNode = noteNodes.item(i2);
            if (noteNode.getNodeType() == 1) {
                Element noteElement = (Element)noteNode;
                String note = noteElement.getTextContent();
                result.getNotes().add((Object)note);
            }
            ++i2;
        }
        NodeList exampleNodes = termElement.getElementsByTagName("example");
        int i3 = 0;
        while (i3 < exampleNodes.getLength()) {
            Node exampleNode = exampleNodes.item(i3);
            if (exampleNode.getNodeType() == 1) {
                Element exampleElement = (Element)exampleNode;
                String example = exampleElement.getTextContent();
                result.getExamples().add((Object)example);
            }
            ++i3;
        }
        return result;
    }

    private static Vocabulary createVocabulary(String vocName, String vocDescription) {
        Vocabulary result = VocabularyFactory.eINSTANCE.createVocabulary();
        result.setName(vocName);
        result.setDescription(vocDescription);
        return result;
    }

    private static Category createCategory(String catName, String catDescription) {
        Category result = VocabularyFactory.eINSTANCE.createCategory();
        result.setName(catName);
        result.setDescription(catDescription);
        return result;
    }
}

