/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.layout;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.layout.ILayoutGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.infra.properties.contexts.ContextsFactory;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.environment.CompositeWidgetType;
import org.eclipse.papyrus.infra.properties.environment.LayoutType;
import org.eclipse.papyrus.infra.properties.environment.Namespace;
import org.eclipse.papyrus.infra.properties.environment.Type;
import org.eclipse.papyrus.infra.properties.ui.CompositeWidget;
import org.eclipse.papyrus.infra.properties.ui.Layout;
import org.eclipse.papyrus.infra.properties.ui.PropertyEditor;
import org.eclipse.papyrus.infra.properties.ui.UiFactory;
import org.eclipse.papyrus.infra.properties.ui.ValueAttribute;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.properties.ui.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardLayoutGenerator
implements ILayoutGenerator {
    protected final TreeMap<Category, List<PropertyEditor>> editorsByCategory = new TreeMap();
    protected final Set<Namespace> namespaces = new HashSet<Namespace>();
    public static Type[] orderedTypes = new Type[]{Type.STRING, Type.BOOLEAN, Type.INTEGER, Type.ENUMERATION, Type.REFERENCE};

    @Override
    public synchronized List<Section> layoutElements(List<PropertyEditor> editors, View parent) {
        this.editorsByCategory.clear();
        this.namespaces.clear();
        this.namespaces.addAll(PropertiesRuntime.getConfigurationManager().getBaseNamespaces());
        this.sortEditors(editors);
        Section section = this.createSection(parent);
        for (Map.Entry<Category, List<PropertyEditor>> mapping : this.editorsByCategory.entrySet()) {
            Category category = mapping.getKey();
            List<PropertyEditor> categorizedEditors = mapping.getValue();
            CompositeWidget container = this.layoutCategorizedEditors(category, categorizedEditors);
            section.getWidget().getWidgets().add((Object)container);
        }
        return Collections.singletonList(section);
    }

    protected CompositeWidget layoutCategorizedEditors(Category category, List<PropertyEditor> editors) {
        CompositeWidgetType compositeType = PropertiesRuntime.getConfigurationManager().getDefaultCompositeType();
        LayoutType propertiesLayoutType = PropertiesRuntime.getConfigurationManager().getDefaultLayoutType();
        CompositeWidget container = UiFactory.eINSTANCE.createCompositeWidget();
        container.setWidgetType(compositeType);
        Layout layout = UiFactory.eINSTANCE.createLayout();
        container.setLayout(layout);
        ValueAttribute numColumns = UiFactory.eINSTANCE.createValueAttribute();
        numColumns.setName("numColumns");
        numColumns.setValue(category.getNumColumns().toString());
        layout.getAttributes().add((Object)numColumns);
        layout.setLayoutType(propertiesLayoutType);
        container.getWidgets().addAll(editors);
        return container;
    }

    protected void sortEditors(List<PropertyEditor> editors) {
        for (PropertyEditor editor : editors) {
            Category category = new Category(editor.getProperty());
            this.getByCategory(category).add(editor);
            if (editor.getWidgetType() == null) {
                Activator.log.warn(String.format("Editor for property %s doesn't have a WidgetType", editor.getProperty().getName()));
                continue;
            }
            this.namespaces.add(editor.getWidgetType().getNamespace());
        }
    }

    protected Section createSection(View parent) {
        CompositeWidget sectionRoot = this.createSectionRoot();
        Section section = ContextsFactory.eINSTANCE.createSection();
        section.setName(parent.getName());
        section.setSectionFile(String.format("ui/%s.xwt", section.getName().replaceAll(" ", "")));
        URI compositeURI = URI.createURI((String)section.getSectionFile());
        compositeURI = compositeURI.resolve(parent.eResource().getURI());
        Resource resource = parent.eResource().getResourceSet().createResource(compositeURI);
        section.setWidget(sectionRoot);
        resource.getContents().add((Object)sectionRoot);
        return section;
    }

    protected CompositeWidget createSectionRoot() {
        CompositeWidgetType compositeType = PropertiesRuntime.getConfigurationManager().getDefaultCompositeType();
        this.namespaces.add(compositeType.getNamespace());
        LayoutType propertiesLayoutType = PropertiesRuntime.getConfigurationManager().getDefaultLayoutType();
        this.namespaces.add(propertiesLayoutType.getNamespace());
        CompositeWidget sectionRoot = UiFactory.eINSTANCE.createCompositeWidget();
        sectionRoot.setWidgetType(compositeType);
        Layout layout = UiFactory.eINSTANCE.createLayout();
        layout.setLayoutType(propertiesLayoutType);
        sectionRoot.setLayout(layout);
        sectionRoot.getAttributes().addAll(this.createNamespaces(this.namespaces));
        return sectionRoot;
    }

    protected List<ValueAttribute> createNamespaces(Collection<Namespace> namespaces) {
        LinkedList<ValueAttribute> xmlNamespaces = new LinkedList<ValueAttribute>();
        for (Namespace namespace : namespaces) {
            if (namespace == null) continue;
            ValueAttribute attribute = UiFactory.eINSTANCE.createValueAttribute();
            attribute.setName(PropertiesUtil.getQualifiedName((Namespace)namespace));
            attribute.setValue(PropertiesUtil.getPrefixedValue((Namespace)namespace));
            xmlNamespaces.add(attribute);
        }
        return xmlNamespaces;
    }

    protected List<PropertyEditor> getByCategory(Category category) {
        if (!this.editorsByCategory.containsKey(category)) {
            this.editorsByCategory.put(category, new LinkedList());
        }
        return this.editorsByCategory.get(category);
    }

    @Override
    public String getName() {
        return Messages.StandardLayoutGenerator_name;
    }

    @Override
    public void setGenerator(IGenerator generator) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Category
    implements Comparable<Category> {
        public Type editorType;
        public int multiplicity;

        public Integer getNumColumns() {
            switch (this.editorType) {
                case BOOLEAN: {
                    return 2;
                }
                case ENUMERATION: {
                    return 1;
                }
                case INTEGER: {
                    return 2;
                }
                case REFERENCE: {
                    return 1;
                }
                case STRING: {
                    return 1;
                }
            }
            return 1;
        }

        public Category(Property property) {
            this.editorType = property.getType();
            this.multiplicity = property.getMultiplicity();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.editorType == null ? 0 : this.editorType.hashCode());
            result = 31 * result + this.multiplicity;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Category)) {
                return false;
            }
            Category other = (Category)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.editorType != other.editorType) {
                return false;
            }
            return this.multiplicity == other.multiplicity;
        }

        @Override
        public int compareTo(Category category) {
            if (category == null) {
                return -1;
            }
            if (category.multiplicity != this.multiplicity) {
                return this.multiplicity == 1 ? -1 : 1;
            }
            int result = this.getTypeIndex().compareTo(category.getTypeIndex());
            return result;
        }

        public Integer getTypeIndex() {
            int i = 0;
            Type[] typeArray = orderedTypes;
            int n = orderedTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (type == this.editorType) {
                    return i;
                }
                ++i;
                ++n2;
            }
            return orderedTypes.length;
        }

        public String toString() {
            return String.valueOf(this.multiplicity == 1 ? "Single" : "Multiple") + this.editorType.toString();
        }

        private StandardLayoutGenerator getOuterType() {
            return StandardLayoutGenerator.this;
        }
    }
}

