/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.syncing;

import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.internal.server.syncing.SynchronizableRepository;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class OfflineClone
extends SynchronizableRepository {
    public final CDOCommonRepository.Type getType() {
        return CLONE;
    }

    public final void setType(CDOCommonRepository.Type type) {
        throw new UnsupportedOperationException();
    }

    public InternalCommitContext createCommitContext(InternalTransaction transaction) {
        CDOBranch branch = transaction.getBranch();
        if (branch.isLocal()) {
            return this.createNormalCommitContext(transaction);
        }
        if (this.getState() != ONLINE) {
            return this.createBranchingCommitContext(transaction, branch);
        }
        return this.createWriteThroughCommitContext(transaction);
    }

    protected InternalCommitContext createBranchingCommitContext(InternalTransaction transaction, CDOBranch branch) {
        long[] times = this.createCommitTimeStamp((OMMonitor)new Monitor());
        CDOBranch offlineBranch = this.createOfflineBranch(branch, times[0] - 1L);
        transaction.setBranchPoint(offlineBranch.getHead());
        return new BranchingCommitContext(transaction, times);
    }

    protected CDOBranch createOfflineBranch(CDOBranch baseBranch, long baseTimeStamp) {
        try {
            StoreThreadLocal.setSession(this.getReplicatorSession());
            InternalCDOBranchManager branchManager = this.getBranchManager();
            InternalCDOBranch internalCDOBranch = branchManager.createBranch(Integer.MIN_VALUE, "Offline-" + baseTimeStamp, (InternalCDOBranch)baseBranch, baseTimeStamp);
            return internalCDOBranch;
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected final class BranchingCommitContext
    extends TransactionCommitContext {
        private long[] times;

        public BranchingCommitContext(InternalTransaction transaction, long[] times) {
            super(transaction);
            this.times = times;
        }

        protected void lockObjects() throws InterruptedException {
        }

        protected long[] createTimeStamp(OMMonitor monitor) {
            return this.times;
        }
    }
}

