/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.diagram.interactionoverview.Activator;
import org.eclipse.papyrus.uml.diagram.interactionoverview.edit.commands.CreateSnapshotForInteractionFromRefreshCommand;
import org.eclipse.papyrus.uml.diagram.interactionoverview.edit.part.CallBehaviorActionAsInteractionEditPart;
import org.eclipse.papyrus.uml.diagram.interactionoverview.figures.InteractionWithSnapshotFigure;
import org.eclipse.papyrus.uml.diagram.interactionoverview.part.Messages;
import org.eclipse.papyrus.uml.diagram.interactionoverview.provider.DiagramContentProvider;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.CallBehaviorUtil;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.Interaction;

public class CreateSnapshotFromContextMenuCommand
extends CreateSnapshotForInteractionFromRefreshCommand {
    protected CallBehaviorActionAsInteractionEditPart callBehaviorEditPart;

    public CreateSnapshotFromContextMenuCommand(TransactionalEditingDomain editingDomain, CallBehaviorActionAsInteractionEditPart callBehaviorActionEditPart) {
        super(editingDomain, (View)callBehaviorActionEditPart.getModel(), (GraphicalEditPart)EditPartUtils.findParentEditPartWithId((EditPart)callBehaviorActionEditPart, (String)"Activity_ActivityNodeCompartment"));
        this.setLabel(Messages.CreateSnapshotFromContextMenuCommand_createNewSnapshot);
        this.callBehaviorEditPart = callBehaviorActionEditPart;
        this.isOverrideImage = true;
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CallBehaviorUtil.resetSnapshotEannotation(this.callBehaviorView);
        return super.doExecuteWithResult(monitor, info);
    }

    @Override
    protected Diagram findSequenceDiagram() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getDefault().getActiveShell());
        ServicesRegistry servicesRegistry = ((IMultiDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getServicesRegistry();
        Interaction interaction = (Interaction)((CallBehaviorAction)this.callBehaviorView.getElement()).getBehavior();
        if (interaction != null) {
            Object[] result;
            dialog.setContentProvider((ITreeContentProvider)new DiagramContentProvider(interaction));
            dialog.setInput((Object)servicesRegistry);
            try {
                dialog.setLabelProvider(((LabelProviderService)servicesRegistry.getService(LabelProviderService.class)).getLabelProvider());
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
            dialog.setMessage(Messages.CreateSnapshotForInteractionFromViewDescriptorCommand_DiagramSelectorMessage);
            dialog.setTitle(Messages.CreateSnapshotForInteractionFromViewDescriptorCommand_DiagramSelectorTitle);
            if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
                return (Diagram)EMFHelper.getEObject((Object)result[0]);
            }
        }
        return null;
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.doUndo(monitor, info);
        InteractionWithSnapshotFigure snapshotFigure = (InteractionWithSnapshotFigure)this.callBehaviorEditPart.getPrimaryShape();
        snapshotFigure.resetImage();
        this.callBehaviorEditPart.refresh();
        return status;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.doRedo(monitor, info);
        InteractionWithSnapshotFigure snapshotFigure = (InteractionWithSnapshotFigure)this.callBehaviorEditPart.getPrimaryShape();
        snapshotFigure.resetImage();
        this.callBehaviorEditPart.refresh();
        return status;
    }
}

