/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.export.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.gmfdiag.export.actions.ExportAllDiagramsParameter;
import org.eclipse.papyrus.infra.gmfdiag.export.actions.ExportComposite;
import org.eclipse.papyrus.infra.gmfdiag.export.engine.ExportAllDiagramsEngine;
import org.eclipse.papyrus.infra.gmfdiag.export.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.export.utils.SelectionHelper;
import org.eclipse.papyrus.infra.gmfdiag.export.wizard.ExportDiagramsErrorPage;
import org.eclipse.papyrus.infra.gmfdiag.export.wizard.ExportDiagramsPage;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForSelection;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportAllWizard
extends Wizard
implements IExportWizard {
    private ExportDiagramsPage page;
    private ExportDiagramsErrorPage pageError;
    private IFile file;
    private ExportAllDiagramsEngine exportAllDiagrams = null;
    private ExportAllDiagramsParameter parameter = null;

    public ExportAllWizard() {
        this.setWindowTitle(Messages.ExportAllWizard_1);
        this.exportAllDiagrams = new ExportAllDiagramsEngine();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        ModelSet modelSetSelection = null;
        this.file = null;
        try {
            modelSetSelection = ServiceUtilsForSelection.getInstance().getModelSet((Object)selection);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (modelSetSelection == null) {
            this.file = SelectionHelper.convertSelection2File((ISelection)selection);
            if (this.file != null) {
                URI diFileUri = URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)true);
                this.parameter = new ExportAllDiagramsParameter(diFileUri);
            }
        } else {
            IModel diModel = modelSetSelection.getModel("org.eclipse.papyrus.infra.core.resource.DiModel");
            if (diModel instanceof DiModel) {
                this.file = ResourceUtils.getFile((Resource)((DiModel)diModel).getResource());
            }
            this.parameter = new ExportAllDiagramsParameter(modelSetSelection);
        }
        URI uriDirectory = null;
        if (this.file != null) {
            IResource parentResource = this.file.getParent().findMember(".");
            uriDirectory = URI.createURI((String)parentResource.getLocationURI().toString());
        }
        if (this.parameter == null) {
            this.pageError = new ExportDiagramsErrorPage();
            this.addPage((IWizardPage)this.pageError);
        } else {
            this.page = new ExportDiagramsPage(uriDirectory);
            this.addPage((IWizardPage)this.page);
        }
    }

    public boolean canFinish() {
        return this.file != null && super.canFinish();
    }

    public boolean performFinish() {
        boolean performFinish;
        boolean bl = performFinish = this.parameter != null;
        if (performFinish) {
            ExportComposite exportPage = this.page.getExport();
            performFinish = exportPage.getOutputDirectory().isAccessible();
            if (performFinish) {
                this.page.setErrorMessage(null);
                this.parameter.setOutputDirectory(exportPage.getOutputDirectory());
                this.parameter.setExportFormat(exportPage.getExporter());
                this.parameter.setQualifiedName(exportPage.getQualifiedName());
                this.exportAllDiagrams.initialise(this.parameter);
                this.exportAllDiagrams.exportDiagramsToImages();
            } else {
                this.page.setErrorMessage(Messages.ExportAllWizard_0);
            }
        }
        return performFinish;
    }
}

