/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data.convert;

import java.text.NumberFormat;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public abstract class NumericDisplayConverter
extends DisplayConverter {
    protected NumberFormat nf = NumberFormat.getInstance();

    @Override
    public Object canonicalToDisplayValue(Object canonicalValue) {
        try {
            if (ObjectUtils.isNotNull(canonicalValue)) {
                if (this.nf != null) {
                    return this.nf.format(canonicalValue);
                }
                return canonicalValue.toString();
            }
            return null;
        }
        catch (Exception exception) {
            return canonicalValue;
        }
    }

    @Override
    public Object displayToCanonicalValue(Object displayValue) {
        try {
            if (ObjectUtils.isNotNull(displayValue) && ObjectUtils.isNotEmpty(displayValue.toString())) {
                return this.convertToNumericValue(displayValue.toString().trim());
            }
            return null;
        }
        catch (Exception e) {
            throw new ConversionFailedException(Messages.getString("NumericDisplayConverter.failure", new Object[]{displayValue}), e);
        }
    }

    protected abstract Object convertToNumericValue(String var1);

    public NumberFormat getNumberFormat() {
        return this.nf;
    }

    public void setNumberFormat(NumberFormat nf) {
        this.nf = nf;
    }
}

