/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.io.IOException;
import org.eclipse.net4j.util.io.IORuntimeException;

public final class HexUtil {
    public static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HexUtil() {
    }

    public static String bytesToHex(byte[] bs, int off, int length) {
        if (bs == null) {
            return null;
        }
        if (bs.length <= off || bs.length < off + length) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(length * 2);
        HexUtil.bytesToHexAppend(bs, off, length, sb);
        return sb.toString();
    }

    public static void bytesToHexAppend(byte[] bs, int off, int length, Appendable appendable) {
        if (bs.length <= off || bs.length < off + length) {
            throw new IllegalArgumentException();
        }
        if (appendable instanceof StringBuffer) {
            StringBuffer buffer = (StringBuffer)appendable;
            buffer.ensureCapacity(buffer.length() + length * 2);
        }
        try {
            int i = off;
            while (i < off + length) {
                appendable.append(Character.forDigit(bs[i] >>> 4 & 0xF, 16));
                appendable.append(Character.forDigit(bs[i] & 0xF, 16));
                ++i;
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static String bytesToHex(byte[] bs) {
        if (bs == null) {
            return null;
        }
        return HexUtil.bytesToHex(bs, 0, bs.length);
    }

    public static byte[] hexToBytes(String s) {
        return HexUtil.hexToBytes(s, 0);
    }

    public static byte[] hexToBytes(String s, int off) {
        byte[] bs = new byte[off + (1 + s.length()) / 2];
        HexUtil.hexToBytes(s, bs, off);
        return bs;
    }

    public static void hexToBytes(String s, byte[] out, int off) throws NumberFormatException, IndexOutOfBoundsException {
        int slen = s.length();
        if ((slen & 1) == 1) {
            s = String.valueOf('0') + s;
        }
        if (out.length < off + (slen >> 1)) {
            throw new IndexOutOfBoundsException("Output buffer too small for input (" + out.length + '<' + off + (slen >> 1) + ')');
        }
        int i = 0;
        while (i < slen) {
            byte b1 = (byte)Character.digit(s.charAt(i), 16);
            byte b2 = (byte)Character.digit(s.charAt(i + 1), 16);
            if (b1 < 0 || b2 < 0) {
                throw new NumberFormatException(s);
            }
            out[off + i / 2] = (byte)(b1 << 4 | b2);
            i += 2;
        }
    }

    public static String longToHex(long v) {
        String hex = Long.toHexString(v);
        if (hex.length() < 8) {
            return String.valueOf("00000000".substring(hex.length())) + hex;
        }
        return hex;
    }

    @Deprecated
    public static String formatByte(int b) {
        HexUtil.assertByte(b);
        return "" + DIGITS[b >> 4] + DIGITS[b & 0xF];
    }

    @Deprecated
    public static String formatBytes(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            HexUtil.appendHex(builder, b - -128);
            ++n2;
        }
        return builder.toString();
    }

    @Deprecated
    public static void appendHex(StringBuilder builder, int b) {
        HexUtil.assertByte(b);
        builder.append(DIGITS[b >> 4]);
        builder.append(DIGITS[b & 0xF]);
    }

    @Deprecated
    private static void assertByte(int b) {
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("b=" + b);
        }
    }
}

