/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.fillhandle.utils;

public class PapyrusFillHandleUtils {
    private static String NEGATIVE_CHAR = "-";

    public static String getTemplateString(String initialString) {
        return PapyrusFillHandleUtils.getTemplateWithoutEndingNumber(PapyrusFillHandleUtils.getTemplateWithoutBeginningNumber(initialString));
    }

    public static String getTemplateWithoutBeginningNumber(String initialString) {
        String result = initialString;
        try {
            if (2 <= result.length() && NEGATIVE_CHAR.equals(result.substring(0, 1))) {
                Integer.parseInt(result.substring(1, 2));
                result = result.substring(2);
            }
        }
        catch (Exception exception) {}
        try {
            while (!result.isEmpty()) {
                String firstChar = result.substring(0, 1);
                Integer.parseInt(firstChar);
                result = result.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getTemplateWithoutEndingNumber(String initialString) {
        String result = initialString;
        boolean hasNumber = false;
        try {
            while (!result.isEmpty()) {
                String lastChar = result.substring(result.length() - 1);
                Integer.parseInt(lastChar);
                hasNumber = true;
                result = result.substring(0, result.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hasNumber && NEGATIVE_CHAR.equals(result.substring(result.length() - 1))) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static boolean isBeginningByNumber(String initialString, String templateString) {
        return !templateString.isEmpty() && !initialString.startsWith(templateString);
    }

    public static boolean isEndingBNumber(String initialString, String templateString) {
        return templateString.isEmpty() || !initialString.endsWith(templateString);
    }
}

