/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.Style;

public class HeaderAxisConfigurationManagementUtils {
    private HeaderAxisConfigurationManagementUtils() {
    }

    public static final AbstractHeaderAxisConfiguration getRowAbstractHeaderAxisInTable(Table table) {
        LocalTableHeaderAxisConfiguration config = table.getLocalRowHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getLocalColumnHeaderAxisConfiguration();
        }
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getRowAbstractHeaderAxisInTableConfiguration(Table table) {
        TableHeaderAxisConfiguration config = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getTableConfiguration().getColumnHeaderAxisConfiguration();
        }
        assert (config != null);
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getRowAbstractHeaderAxisConfigurationUsedInTable(Table table) {
        AbstractHeaderAxisConfiguration config = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTable(table);
        if (config == null) {
            config = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table);
        }
        assert (config != null);
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getColumnAbstractHeaderAxisInTable(Table table) {
        LocalTableHeaderAxisConfiguration config = table.getLocalColumnHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getLocalRowHeaderAxisConfiguration();
        }
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getColumnAbstractHeaderAxisInTableConfiguration(Table table) {
        TableHeaderAxisConfiguration config = table.getTableConfiguration().getColumnHeaderAxisConfiguration();
        if (table.isInvertAxis()) {
            config = table.getTableConfiguration().getRowHeaderAxisConfiguration();
        }
        assert (config != null);
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getColumnAbstractHeaderAxisConfigurationUsedInTable(Table table) {
        AbstractHeaderAxisConfiguration config = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTable(table);
        if (config == null) {
            config = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisInTableConfiguration(table);
        }
        Assert.isNotNull((Object)config);
        return config;
    }

    public static final AbstractHeaderAxisConfiguration getRowAbstractHeaderAxisUsedInTable(Table table) {
        AbstractHeaderAxisConfiguration config = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTable(table);
        if (config == null) {
            config = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table);
        }
        Assert.isNotNull((Object)config);
        return config;
    }

    public static LocalTableHeaderAxisConfiguration transformToLocalHeaderConfiguration(TableHeaderAxisConfiguration configuration) {
        LocalTableHeaderAxisConfiguration conf = NattableaxisconfigurationFactory.eINSTANCE.createLocalTableHeaderAxisConfiguration();
        conf.setDisplayFilter(configuration.isDisplayFilter());
        conf.setDisplayIndex(configuration.isDisplayIndex());
        conf.setDisplayLabel(configuration.isDisplayLabel());
        conf.setIndexStyle(configuration.getIndexStyle());
        for (Style current : configuration.getStyles()) {
            Style copy = (Style)EcoreUtil.copy((EObject)current);
            conf.getStyles().add((Object)copy);
        }
        return conf;
    }
}

