/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import com.google.common.collect.AbstractIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

class PlatformUIUtils {
    private static final String MODEL_ELEMENT_KEY = "modelElement";

    private PlatformUIUtils() {
    }

    static Stream<Control> parentChain(Control control) {
        AbstractIterator<Control> iterator = new AbstractIterator<Control>(control){
            private Control next;
            {
                this.next = control;
            }

            protected Control computeNext() {
                Control result = this.next;
                if (result != null) {
                    this.next = result.getParent();
                } else {
                    result = (Control)this.endOfData();
                }
                return result;
            }
        };
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 273);
        return StreamSupport.stream(spliterator, false);
    }

    static <S> S getService(Control control, Class<S> api) {
        Optional<Object> result = PlatformUIUtils.parentChain(control).map(c -> c.getData(MODEL_ELEMENT_KEY)).filter(MPart.class::isInstance).map(MPart.class::cast).map(MContext::getContext).map(ctx -> ctx.get(api)).filter(Objects::nonNull).findFirst();
        return (S)result.orElseGet(() -> PlatformUIUtils.bestEffortService(api));
    }

    private static <S> S bestEffortService(Class<S> api) {
        Object result;
        IWorkbenchWindow[] allWindows;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && (allWindows = workbench.getWorkbenchWindows()).length > 0) {
            window = allWindows[0];
        }
        if (window != null) {
            IWorkbenchPart activePart;
            IWorkbenchPage[] allPages;
            IWorkbenchPage page = window.getActivePage();
            if (page == null && (allPages = window.getPages()).length > 0) {
                page = allPages[0];
            }
            result = page != null ? ((activePart = page.getActivePart()) != null ? activePart.getSite().getService(api) : window.getService(api)) : window.getService(api);
        } else {
            result = workbench.getService(api);
        }
        return (S)result;
    }

    static void handleCommand(final Control control, final String commandID, final String defaultKeystroke, final Runnable action) {
        IBindingService bindingService = PlatformUIUtils.getService(control, IBindingService.class);
        Consumer<IBindingService> onBindingsChanged = new Consumer<IBindingService>(){
            private KeyListener keyListener;

            @Override
            public void accept(IBindingService bindings) {
                TriggerSequence triggerSeq;
                if (this.keyListener != null) {
                    control.removeKeyListener(this.keyListener);
                    this.keyListener = null;
                }
                if ((triggerSeq = bindings.getBestActiveBindingFor(commandID)) != null) {
                    try {
                        Trigger[] triggers = triggerSeq.getTriggers();
                        Object trigger = triggers.length == 1 ? triggers[0] : (defaultKeystroke != null ? KeyStroke.getInstance((String)defaultKeystroke) : null);
                        if (trigger != null) {
                            this.keyListener = new KeyAdapter((Trigger)trigger, action){
                                private final /* synthetic */ Trigger val$trigger;
                                private final /* synthetic */ Runnable val$action;
                                {
                                    this.val$trigger = trigger;
                                    this.val$action = runnable;
                                }

                                public void keyPressed(KeyEvent e) {
                                    int accel = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                                    KeyStroke stroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)accel);
                                    if (stroke.equals((Object)this.val$trigger)) {
                                        this.val$action.run();
                                    }
                                }
                            };
                            control.addKeyListener(this.keyListener);
                        }
                    }
                    catch (ParseException e) {
                        Activator.log.error(String.format("Cannot represent %s trigger as a KeyStroke", defaultKeystroke), (Throwable)e);
                    }
                }
            }
        };
        IBindingManagerListener bindingListener = event -> onBindingsChanged.accept(bindingService);
        bindingService.addBindingManagerListener(bindingListener);
        onBindingsChanged.accept(bindingService);
        control.addDisposeListener(__ -> bindingService.removeBindingManagerListener(bindingListener));
    }
}

