/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.menu;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.navigation.Activator;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.listener.NavigationMenuKeyListener;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.listener.SelectionMenuSelectionChangedListener;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.provider.SelectionMenuLabelProvider;
import org.eclipse.papyrus.infra.services.navigation.service.ExtendedNavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenu;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.infra.services.viewersearch.impl.ViewerSearchService;
import org.eclipse.papyrus.infra.widgets.editors.SelectionMenu;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNavigationMenu
implements NavigationMenu {
    private ServicesRegistry servicesRegistry;
    private Shell parentShell;
    private NavigationService navigationService;
    private ViewerSearchService viewerSearchService;
    private EObject currentModel;
    private List<Object> prependObjects;
    private List<Object> appendObjects = new LinkedList<Object>();
    private SelectionMenu selectionMenu;
    private List<SelectionMenu> subMenus;
    private boolean wasUnderlined;
    private WrappingLabel lastWrappingLabel;
    private static boolean altReleasedPostNavigation = true;
    private View selectedView;

    public DefaultNavigationMenu() {
        this.prependObjects = new LinkedList<Object>();
    }

    public void handleRequest(SelectionRequest request, EditPart targetEditPart) {
        if (targetEditPart != null) {
            EObject model = EMFHelper.getEObject((Object)targetEditPart);
            if (this.isExitState(request, model)) {
                this.exitItem();
            }
            if (this.isEnterState(request, model)) {
                this.enterItem(targetEditPart);
            }
        }
    }

    public void handleRequest(MouseEvent e, TreeItem treeItem) {
        if (treeItem != null) {
            EObject model = EMFHelper.getEObject((Object)treeItem.getData());
            if (this.isExitState(e, model)) {
                this.exitItem();
            }
            if (this.isEnterState(e, model)) {
                this.enterItem(model);
            }
        }
    }

    protected boolean isExitState(SelectionRequest request, EObject model) {
        if (!request.isAltKeyPressed()) {
            altReleasedPostNavigation = true;
            return true;
        }
        return this.isExitState(model);
    }

    private boolean isExitState(MouseEvent e, EObject model) {
        if ((e.stateMask & 0x10000) == 0) {
            altReleasedPostNavigation = true;
            return true;
        }
        return this.isExitState(model);
    }

    protected boolean isExitState(EObject model) {
        if (this.currentModel == null) {
            return false;
        }
        if (model == null) {
            return true;
        }
        return model != this.currentModel;
    }

    protected boolean isEnterState(SelectionRequest request, EObject model) {
        if (!request.isAltKeyPressed() || !altReleasedPostNavigation) {
            return false;
        }
        return this.isEnterState(model);
    }

    protected boolean isEnterState(MouseEvent e, EObject model) {
        if ((e.stateMask & 0x10000) == 0 || !altReleasedPostNavigation) {
            return false;
        }
        return this.isEnterState(model);
    }

    protected boolean isEnterState(EObject model) {
        if (model == this.currentModel) {
            return false;
        }
        if (model == null) {
            return false;
        }
        this.currentModel = model;
        return true;
    }

    public boolean willEnter(SelectionRequest request, EditPart targetEditPart) {
        if (!request.isAltKeyPressed()) {
            return false;
        }
        EObject model = null;
        if (targetEditPart != null) {
            model = EMFHelper.getEObject((Object)targetEditPart);
        }
        return this.willEnter(model);
    }

    public boolean willEnter(EObject model) {
        if (model == this.currentModel) {
            return false;
        }
        return model != null;
    }

    private void disposeCurrentMenu() {
        if (this.selectionMenu != null) {
            this.selectionMenu.dispose();
            this.selectionMenu = null;
        }
    }

    public void exitItem() {
        if (this.lastWrappingLabel != null) {
            this.lastWrappingLabel.setTextUnderline(this.wasUnderlined);
        }
        this.wasUnderlined = false;
        this.lastWrappingLabel = null;
        this.currentModel = null;
        this.disposeCurrentMenu();
    }

    private void enterItem(Object source) {
        Shell shell;
        this.disposeCurrentMenu();
        try {
            shell = this.getParentShell();
        }
        catch (NavigationMenuInitializationException e) {
            Activator.log.error((Throwable)e);
            return;
        }
        LinkedList<Object> navigationMenuElements = new LinkedList<Object>();
        if (this.prependObjects != null && this.prependObjects.size() > 0) {
            navigationMenuElements.addAll(this.prependObjects);
        }
        try {
            navigationMenuElements.addAll(this.getNavigationService().getNavigableElements(source));
        }
        catch (NavigationMenuInitializationException e) {
            Activator.log.error((Throwable)e);
            return;
        }
        if (this.appendObjects != null && this.appendObjects.size() > 0) {
            navigationMenuElements.addAll(this.appendObjects);
        }
        if (navigationMenuElements.isEmpty()) {
            return;
        }
        EObject umlElement = EMFHelper.getEObject((Object)source);
        this.selectionMenu = new SelectionMenu(shell);
        this.subMenus = new LinkedList<SelectionMenu>();
        this.selectionMenu.setLabelProvider((ILabelProvider)new SelectionMenuLabelProvider());
        this.selectionMenu.setContentProvider((IStructuredContentProvider)CollectionContentProvider.instance);
        this.selectionMenu.setInput(navigationMenuElements);
        this.selectionMenu.open();
        this.wasUnderlined = false;
        if (source instanceof IGraphicalEditPart) {
            this.selectedView = ((IGraphicalEditPart)source).getPrimaryView();
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)source;
            IFigure figure = graphicalEditPart.getFigure();
            if (figure instanceof WrappingLabel) {
                this.lastWrappingLabel = (WrappingLabel)figure;
                this.wasUnderlined = this.lastWrappingLabel.isTextUnderlined();
                this.lastWrappingLabel.setTextUnderline(!this.wasUnderlined);
            }
        } else {
            this.selectedView = null;
        }
        this.selectionMenu.addSelectionChangedListener((ISelectionChangedListener)new SelectionMenuSelectionChangedListener(this, this.selectionMenu, navigationMenuElements, umlElement, this.subMenus));
        this.selectionMenu.addKeyListener((KeyListener)new NavigationMenuKeyListener(this));
    }

    public void addContextualMenus(List<Object> navigationMenuElements, Object umlElement) {
        try {
            List buttons = this.getNavigationService().getButtons(umlElement);
            navigationMenuElements.addAll(buttons);
        }
        catch (NavigationMenuInitializationException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public List<Object> getViewsToSelect(NavigableElement navElement, boolean onlyOpened) {
        if (navElement == null) {
            return null;
        }
        EObject element = null;
        if (navElement instanceof ExtendedNavigableElement && ((ExtendedNavigableElement)navElement).getSemanticElement() instanceof EObject) {
            element = (EObject)((ExtendedNavigableElement)navElement).getSemanticElement();
        }
        if (element != null) {
            ViewerSearchService viewerSearchService = null;
            try {
                viewerSearchService = this.getViewerSearchService();
            }
            catch (NavigationMenuInitializationException e) {
                Activator.log.error((Throwable)e);
            }
            if (viewerSearchService != null) {
                return viewerSearchService.getViewersInCurrentModel(element, null, false, onlyOpened);
            }
        }
        return new LinkedList<Object>();
    }

    public void showInModelExplorer(NavigableElement navigableElement) {
        Object semanticElement = null;
        if (navigableElement instanceof ExtendedNavigableElement) {
            semanticElement = ((ExtendedNavigableElement)navigableElement).getSemanticElement();
        }
        if (semanticElement != null) {
            try {
                this.getNavigationService().navigate(semanticElement, "org.eclipse.papyrus.views.modelexplorer.navigation.target");
            }
            catch (NavigationMenuInitializationException e) {
                Activator.log.error((Throwable)e);
            }
        }
        altReleasedPostNavigation = false;
        this.exitItem();
    }

    public void revealObject(Object object) {
        ServicesRegistry registry = null;
        try {
            registry = this.getServicesRegistry();
        }
        catch (NavigationMenuInitializationException e) {
            Activator.log.error((Throwable)e);
            this.exitItem();
            return;
        }
        try {
            OpenElementService service = (OpenElementService)registry.getService(OpenElementService.class);
            if (object instanceof EObject) {
                service.openElement((EObject)object);
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        altReleasedPostNavigation = false;
        this.exitItem();
    }

    private ServicesRegistry getServicesRegistry() throws NavigationMenuInitializationException {
        if (this.servicesRegistry == null) {
            throw new NavigationMenuInitializationException(this.servicesRegistry);
        }
        return this.servicesRegistry;
    }

    private NavigationService getNavigationService() throws NavigationMenuInitializationException {
        if (this.navigationService == null) {
            throw new NavigationMenuInitializationException(this.navigationService);
        }
        return this.navigationService;
    }

    public ViewerSearchService getViewerSearchService() throws NavigationMenuInitializationException {
        if (this.viewerSearchService == null) {
            throw new NavigationMenuInitializationException(this.viewerSearchService);
        }
        return this.viewerSearchService;
    }

    private Shell getParentShell() throws NavigationMenuInitializationException {
        if (this.parentShell == null) {
            throw new NavigationMenuInitializationException(this.parentShell);
        }
        return this.parentShell;
    }

    public List<Object> getAppendObjects() {
        return this.appendObjects;
    }

    public void setAppendObjects(List<Object> appendObjects) {
        this.appendObjects = appendObjects;
    }

    public List<Object> getPrependObjects() {
        return this.prependObjects;
    }

    public void setPrependObjects(List<Object> prependObjects) {
        this.prependObjects = prependObjects;
    }

    public Command navigate(SelectionRequest request, EditPart host) {
        if (!request.isAltKeyPressed()) {
            return null;
        }
        EditPart targetEditPart = host.getViewer().findObjectAt(request.getLocation());
        final NavigableElement element = this.getElementToNavigate(targetEditPart);
        if (element == null) {
            return null;
        }
        return new Command(){

            public void execute() {
                try {
                    DefaultNavigationMenu.this.getNavigationService().navigate(element);
                }
                catch (NavigationMenuInitializationException e) {
                    Activator.log.error((Throwable)e);
                }
                DefaultNavigationMenu.this.exitItem();
            }
        };
    }

    private NavigableElement getElementToNavigate(EditPart target) {
        List navigableElements;
        try {
            navigableElements = this.getNavigationService().getNavigableElements((Object)target);
        }
        catch (NavigationMenuInitializationException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
        if (navigableElements.isEmpty()) {
            return null;
        }
        for (NavigableElement element : navigableElements) {
            if (!element.isEnabled()) continue;
            return element;
        }
        return null;
    }

    public void handleRequest(Object request, Object target) {
        if (request instanceof SelectionRequest && target instanceof EditPart) {
            this.handleRequest((SelectionRequest)request, (EditPart)target);
        }
        if (request instanceof MouseEvent && target instanceof TreeItem) {
            this.handleRequest((MouseEvent)request, (TreeItem)target);
        }
    }

    public boolean willEnter(Object request, Object target) {
        if (request instanceof SelectionRequest && target instanceof EditPart) {
            return this.willEnter((SelectionRequest)request, (EditPart)target);
        }
        return false;
    }

    public Object navigate(Object request, Object host) {
        if (request instanceof SelectionRequest && host instanceof EditPart) {
            return this.navigate((SelectionRequest)request, (EditPart)host);
        }
        return null;
    }

    public void setServicesRegistry(ServicesRegistry registry) {
        this.servicesRegistry = registry;
        try {
            this.navigationService = (NavigationService)this.getServicesRegistry().getService(NavigationService.class);
            this.viewerSearchService = (ViewerSearchService)this.getServicesRegistry().getService(ViewerSearchService.class);
        }
        catch (ServiceException e) {
            if (e instanceof ServiceNotFoundException) {
                this.viewerSearchService = new ViewerSearchService();
                try {
                    this.viewerSearchService.startService();
                    this.getServicesRegistry().add(ViewerSearchService.class, 1, (IService)this.viewerSearchService);
                }
                catch (Exception e1) {
                    Activator.log.error((Throwable)e1);
                }
            } else if (e instanceof BadStateException) {
                try {
                    this.getServicesRegistry().startRegistry();
                    this.viewerSearchService = (ViewerSearchService)this.getServicesRegistry().getService(ViewerSearchService.class);
                }
                catch (Exception e1) {
                    Activator.log.error((Throwable)e1);
                }
            }
        }
        catch (NavigationMenuInitializationException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public View getSelectedView() {
        return this.selectedView;
    }

    public void setParentShell(Shell parentShell) {
        this.parentShell = parentShell;
    }

    public void altReleased() {
        altReleasedPostNavigation = true;
    }

    public class NavigationMenuInitializationException
    extends Exception {
        private static final long serialVersionUID = 1094797103244873186L;
        private Object source;

        public NavigationMenuInitializationException(Object source) {
            this.source = source;
        }

        public String getMessage() {
            String error = "";
            if (this.source instanceof ServicesRegistry) {
                error = "services registry is not set";
            } else if (this.source instanceof Shell) {
                error = "parent shell is not set";
            } else if (this.source instanceof NavigationService) {
                error = "navigation service could not be initialized";
            }
            return "Navigation menu initialization error: " + error;
        }
    }
}

