/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.celleditor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.CellEditorEx;
import org.eclipse.gmf.tooling.runtime.directedit.TextDirectEditManager2;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.opencert.userguidance.celleditor.StyledWrapTextCellEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;

public class TextDirectEditManager3
extends TextDirectEditManager2 {
    private EObject eobj;
    private int featureID;

    public TextDirectEditManager3(GraphicalEditPart source, Class<?> editorType, CellEditorLocator locator, EObject eobj, int featureID) {
        super(source, editorType, locator);
        this.eobj = eobj;
        this.featureID = featureID;
    }

    public void setEditText(String toEdit) {
        CellEditor cellEditor = this.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        ITextAwareEditPart textEP = (ITextAwareEditPart)this.getEditPart();
        textEP.setLabelText(toEdit);
        if (cellEditor instanceof CellEditorEx) {
            ((CellEditorEx)cellEditor).setValueAndProcessEditOccured((Object)toEdit);
        } else {
            cellEditor.setValue((Object)toEdit);
        }
        StyledText textControl = (StyledText)cellEditor.getControl();
        textControl.setSelection(toEdit.length());
    }

    protected CellEditor doCreateCellEditorOn(Composite composite) {
        ILabelDelegate label = (ILabelDelegate)this.getEditPart().getAdapter(ILabelDelegate.class);
        if (label != null && label.isTextWrapOn()) {
            int style = 66;
            switch (label.getTextJustification()) {
                case 1: {
                    style |= 0x4000;
                    break;
                }
                case 4: {
                    style |= 0x20000;
                    break;
                }
                case 2: {
                    style |= 0x1000000;
                    break;
                }
            }
            StyledWrapTextCellEditor editor = new StyledWrapTextCellEditor(composite, style, this.eobj, this.featureID);
            Font font = this.getEditPart().getFigure().getFont();
            editor.getControl().setFont(font);
            return editor;
        }
        throw new IllegalStateException("Error while trying to create a cell editor with a StyledText2.");
    }
}

