/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.es2as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AssociationClass;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.ConnectionPointReference;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.DynamicBehavior;
import org.eclipse.ocl.pivot.DynamicElement;
import org.eclipse.ocl.pivot.DynamicType;
import org.eclipse.ocl.pivot.DynamicValueSpecification;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.FinalState;
import org.eclipse.ocl.pivot.InstanceSpecification;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Profile;
import org.eclipse.ocl.pivot.ProfileApplication;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Pseudostate;
import org.eclipse.ocl.pivot.Region;
import org.eclipse.ocl.pivot.Signal;
import org.eclipse.ocl.pivot.Slot;
import org.eclipse.ocl.pivot.State;
import org.eclipse.ocl.pivot.StateMachine;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.StereotypeExtender;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Transition;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.internal.PackageImpl;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.ecore.es2as.AbstractExternal2AS;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2ASDeclarationSwitch;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.RealValue;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UML2ASDeclarationSwitch
extends UMLSwitch<Object> {
    private static final @NonNull Logger logger = Logger.getLogger(UML2ASDeclarationSwitch.class);
    protected final @NonNull Ecore2ASDeclarationSwitch ecoreSwitch;
    protected final @NonNull UML2AS converter;
    protected final @NonNull PivotMetamodelManager metamodelManager;
    protected final @NonNull StandardLibraryInternal standardLibrary;

    public UML2ASDeclarationSwitch(@NonNull UML2AS converter) {
        this.converter = converter;
        this.ecoreSwitch = new Ecore2ASDeclarationSwitch((AbstractExternal2AS)converter);
        this.metamodelManager = converter.getMetamodelManager();
        this.standardLibrary = converter.getStandardLibrary();
    }

    public Object caseAssociation(Association umlAssociation) {
        assert (umlAssociation != null);
        AssociationClass asAssociationClass = this.converter.refreshNamedElement(AssociationClass.class, PivotPackage.Literals.ASSOCIATION_CLASS, (org.eclipse.uml2.uml.NamedElement)umlAssociation);
        this.copyNamedElement((NamedElement)asAssociationClass, (org.eclipse.uml2.uml.NamedElement)umlAssociation);
        this.converter.queueReference((EObject)umlAssociation);
        this.converter.queueUse((EObject)umlAssociation);
        return asAssociationClass;
    }

    public Object caseAssociationClass(org.eclipse.uml2.uml.AssociationClass umlAssociationClass) {
        assert (umlAssociationClass != null);
        AssociationClass asAssociationClass = this.converter.refreshNamedElement(AssociationClass.class, PivotPackage.Literals.ASSOCIATION_CLASS, (org.eclipse.uml2.uml.NamedElement)umlAssociationClass);
        this.copyClass((Class)asAssociationClass, (org.eclipse.uml2.uml.Class)umlAssociationClass);
        this.converter.queueReference((EObject)umlAssociationClass);
        this.converter.queueUse((EObject)umlAssociationClass);
        return asAssociationClass;
    }

    public Object caseBehavior(Behavior umlBehavior) {
        assert (umlBehavior != null);
        DynamicBehavior pivotElement = (DynamicBehavior)this.converter.refreshElement(DynamicBehavior.class, PivotPackage.Literals.DYNAMIC_BEHAVIOR, (EModelElement)umlBehavior);
        pivotElement.setName(umlBehavior.getName());
        this.doSwitchAll(pivotElement.getOwnedAnnotations(), (List)umlBehavior.getOwnedElements(), null);
        EClass umlMetaClass = umlBehavior.eClass();
        Type metaType = (Type)this.metamodelManager.getASOfEcore(Type.class, (EObject)umlMetaClass);
        pivotElement.setMetaType(metaType);
        return pivotElement;
    }

    public Class caseClass(org.eclipse.uml2.uml.Class umlClass) {
        assert (umlClass != null);
        Class pivotElement = this.converter.refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, (org.eclipse.uml2.uml.NamedElement)umlClass);
        this.copyClass(pivotElement, umlClass);
        this.converter.queueReference((EObject)umlClass);
        return pivotElement;
    }

    public Object caseClassifierTemplateParameter(ClassifierTemplateParameter umlTemplateParameter) {
        assert (umlTemplateParameter != null);
        @NonNull org.eclipse.uml2.uml.Class umlParameterClass = (org.eclipse.uml2.uml.Class)umlTemplateParameter.getParameteredElement();
        TemplateParameter pivotElement = (TemplateParameter)this.converter.refreshElement(TemplateParameter.class, PivotPackage.Literals.TEMPLATE_PARAMETER, (EModelElement)umlTemplateParameter);
        pivotElement.setName(umlParameterClass.getName());
        this.converter.setOriginalMapping((Element)pivotElement, (EObject)umlTemplateParameter);
        return pivotElement;
    }

    public Comment caseComment(org.eclipse.uml2.uml.Comment umlComment) {
        assert (umlComment != null);
        Comment pivotElement = this.converter.refreshElement(Comment.class, PivotPackage.Literals.COMMENT, (EObject)umlComment);
        pivotElement.setBody(umlComment.getBody());
        this.copyComments((Element)pivotElement, (org.eclipse.uml2.uml.Element)umlComment);
        return pivotElement;
    }

    public ConnectionPointReference caseConnectionPointReference(org.eclipse.uml2.uml.ConnectionPointReference umlConnectionPointReference) {
        assert (umlConnectionPointReference != null);
        ConnectionPointReference pivotElement = this.converter.refreshNamedElement(ConnectionPointReference.class, PivotPackage.Literals.CONNECTION_POINT_REFERENCE, (org.eclipse.uml2.uml.NamedElement)umlConnectionPointReference);
        this.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlConnectionPointReference);
        return pivotElement;
    }

    public Constraint caseConstraint(org.eclipse.uml2.uml.Constraint umlConstraint) {
        assert (umlConstraint != null);
        Constraint pivotElement = this.converter.refreshNamedElement(Constraint.class, PivotPackage.Literals.CONSTRAINT, (org.eclipse.uml2.uml.NamedElement)umlConstraint);
        this.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlConstraint);
        this.converter.queueUse((EObject)umlConstraint);
        return pivotElement;
    }

    public DataType caseDataType(org.eclipse.uml2.uml.DataType umlDataType) {
        assert (umlDataType != null);
        DataType pivotElement = this.converter.refreshNamedElement(DataType.class, PivotPackage.Literals.DATA_TYPE, (org.eclipse.uml2.uml.NamedElement)umlDataType);
        this.copyDataTypeOrEnum(pivotElement, umlDataType);
        @NonNull EList umlAttributes = umlDataType.getAttributes();
        this.doSwitchAll((List<? extends EObject>)umlAttributes);
        pivotElement.getSuperClasses().add(this.standardLibrary.getOclAnyType());
        return pivotElement;
    }

    public Enumeration caseEnumeration(org.eclipse.uml2.uml.Enumeration umlEnumeration) {
        assert (umlEnumeration != null);
        Enumeration pivotElement = this.converter.refreshNamedElement(Enumeration.class, PivotPackage.Literals.ENUMERATION, (org.eclipse.uml2.uml.NamedElement)umlEnumeration);
        this.copyDataTypeOrEnum((DataType)pivotElement, (org.eclipse.uml2.uml.DataType)umlEnumeration);
        this.doSwitchAll(pivotElement.getOwnedLiterals(), (List)umlEnumeration.getOwnedLiterals(), null);
        pivotElement.getSuperClasses().add(this.standardLibrary.getOclEnumerationType());
        return pivotElement;
    }

    public EnumerationLiteral caseEnumerationLiteral(org.eclipse.uml2.uml.EnumerationLiteral umlEnumLiteral) {
        assert (umlEnumLiteral != null);
        EnumerationLiteral pivotElement = this.converter.refreshNamedElement(EnumerationLiteral.class, PivotPackage.Literals.ENUMERATION_LITERAL, (org.eclipse.uml2.uml.NamedElement)umlEnumLiteral);
        this.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlEnumLiteral);
        return pivotElement;
    }

    public Object caseExtension(Extension umlExtension) {
        org.eclipse.uml2.uml.Package umlMetapackage;
        assert (umlExtension != null);
        StereotypeExtender asTypeExtension = this.converter.refreshElement(StereotypeExtender.class, PivotPackage.Literals.STEREOTYPE_EXTENDER, (EObject)umlExtension);
        this.converter.copyModelElement((Element)asTypeExtension, (org.eclipse.uml2.uml.Element)umlExtension);
        boolean isRequired = false;
        for (org.eclipse.uml2.uml.Property umlProperty : umlExtension.getOwnedEnds()) {
            Object eObject = this.doSwitch((EObject)umlProperty);
            int lower = umlProperty.getLower();
            if (lower != 1) continue;
            isRequired = false;
        }
        asTypeExtension.setIsRequired(isRequired);
        org.eclipse.uml2.uml.Class umlMetaclass = umlExtension.getMetaclass();
        if (umlMetaclass != null && (umlMetapackage = umlMetaclass.getPackage()) != null) {
            String nsURI = umlMetapackage.getURI();
            if (nsURI != null) {
                this.metamodelManager.getCompleteModel().addPackageURI2completeURI(nsURI, "$uml$");
            }
            this.converter.addImportedPackage(umlMetapackage);
        }
        this.converter.queueReference((EObject)umlExtension);
        return asTypeExtension;
    }

    public FinalState caseFinalState(org.eclipse.uml2.uml.FinalState umlState) {
        assert (umlState != null);
        FinalState pivotElement = this.converter.refreshNamedElement(FinalState.class, PivotPackage.Literals.FINAL_STATE, (org.eclipse.uml2.uml.NamedElement)umlState);
        this.copyState((State)pivotElement, (org.eclipse.uml2.uml.State)umlState);
        return pivotElement;
    }

    public InstanceSpecification caseInstanceSpecification(org.eclipse.uml2.uml.InstanceSpecification umlInstanceSpecification) {
        assert (umlInstanceSpecification != null);
        InstanceSpecification pivotElement = this.converter.refreshNamedElement(InstanceSpecification.class, PivotPackage.Literals.INSTANCE_SPECIFICATION, (org.eclipse.uml2.uml.NamedElement)umlInstanceSpecification);
        this.doSwitchAll(pivotElement.getOwnedSlots(), (List)umlInstanceSpecification.getSlots(), null);
        return pivotElement;
    }

    public Class caseInterface(Interface umlInterface) {
        assert (umlInterface != null);
        Class pivotElement = this.converter.refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, (org.eclipse.uml2.uml.NamedElement)umlInterface);
        pivotElement.setIsInterface(true);
        this.copyClassOrInterface(pivotElement, (Classifier)umlInterface);
        return pivotElement;
    }

    public Object caseOpaqueExpression(OpaqueExpression umlExpression) {
        assert (umlExpression != null);
        if (umlExpression.eContainer() instanceof org.eclipse.uml2.uml.Constraint) {
            this.converter.queueUse((EObject)umlExpression);
            return this;
        }
        ExpressionInOCL pivotElement = this.converter.refreshOpaqueExpression(umlExpression);
        return pivotElement;
    }

    public Operation caseOperation(org.eclipse.uml2.uml.Operation umlOperation) {
        assert (umlOperation != null);
        Operation pivotElement = this.converter.refreshNamedElement(Operation.class, PivotPackage.Literals.OPERATION, (org.eclipse.uml2.uml.NamedElement)umlOperation);
        this.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlOperation);
        for (org.eclipse.uml2.uml.Parameter umlParameter : umlOperation.getOwnedParameters()) {
            Parameter pivotObject;
            ParameterDirectionKind direction = umlParameter.getDirection();
            if (direction != ParameterDirectionKind.IN_LITERAL || (pivotObject = (Parameter)this.doSwitch((EObject)umlParameter)) == null) continue;
            pivotElement.getOwnedParameters().add(pivotObject);
        }
        this.copyTemplateSignature((TemplateableElement)pivotElement, umlOperation.getOwnedTemplateSignature());
        this.converter.queueUse((EObject)umlOperation);
        return pivotElement;
    }

    public Package casePackage(org.eclipse.uml2.uml.Package umlPackage) {
        assert (umlPackage != null);
        Package pivotElement = this.converter.refreshNamedElement(Package.class, PivotPackage.Literals.PACKAGE, (org.eclipse.uml2.uml.NamedElement)umlPackage);
        this.copyPackage(pivotElement, umlPackage);
        return pivotElement;
    }

    public Parameter caseParameter(org.eclipse.uml2.uml.Parameter eObject) {
        assert (eObject != null);
        Parameter pivotElement = this.converter.refreshNamedElement(Parameter.class, PivotPackage.Literals.PARAMETER, (org.eclipse.uml2.uml.NamedElement)eObject);
        this.copyTypedElement((TypedElement)pivotElement, (org.eclipse.uml2.uml.TypedElement)eObject, null);
        return pivotElement;
    }

    public DataType casePrimitiveType(org.eclipse.uml2.uml.PrimitiveType umlPrimitiveType) {
        Object object;
        org.eclipse.uml2.uml.Package umlPackage;
        DataType pivotElement;
        assert (umlPrimitiveType != null);
        PrimitiveType asPrimitiveType = this.getPrimitiveTypeByName(umlPrimitiveType);
        if (asPrimitiveType == null) {
            asPrimitiveType = this.getPrimitiveTypeByOCLStereotype((org.eclipse.uml2.uml.DataType)umlPrimitiveType);
        }
        org.eclipse.uml2.uml.Stereotype ecoreStereotype = null;
        if (asPrimitiveType == this.standardLibrary.getBooleanType()) {
            pivotElement = (DataType)this.converter.refreshNamedElement(PrimitiveType.class, PivotPackage.Literals.PRIMITIVE_TYPE, (org.eclipse.uml2.uml.NamedElement)umlPrimitiveType);
        } else if (asPrimitiveType == this.standardLibrary.getIntegerType()) {
            pivotElement = (DataType)this.converter.refreshNamedElement(PrimitiveType.class, PivotPackage.Literals.PRIMITIVE_TYPE, (org.eclipse.uml2.uml.NamedElement)umlPrimitiveType);
        } else if (asPrimitiveType == this.standardLibrary.getRealType()) {
            pivotElement = (DataType)this.converter.refreshNamedElement(PrimitiveType.class, PivotPackage.Literals.PRIMITIVE_TYPE, (org.eclipse.uml2.uml.NamedElement)umlPrimitiveType);
        } else if (asPrimitiveType == this.standardLibrary.getStringType()) {
            pivotElement = (DataType)this.converter.refreshNamedElement(PrimitiveType.class, PivotPackage.Literals.PRIMITIVE_TYPE, (org.eclipse.uml2.uml.NamedElement)umlPrimitiveType);
        } else if (asPrimitiveType == this.standardLibrary.getUnlimitedNaturalType()) {
            pivotElement = (DataType)this.converter.refreshNamedElement(PrimitiveType.class, PivotPackage.Literals.PRIMITIVE_TYPE, (org.eclipse.uml2.uml.NamedElement)umlPrimitiveType);
        } else {
            ecoreStereotype = umlPrimitiveType.getAppliedStereotype("Ecore::EDataType");
            if (ecoreStereotype == null) {
                ecoreStereotype = umlPrimitiveType.getAppliedStereotype("Ecore::EClassifier");
            }
            pivotElement = ecoreStereotype != null ? this.converter.refreshNamedElement(DataType.class, PivotPackage.Literals.DATA_TYPE, (org.eclipse.uml2.uml.NamedElement)umlPrimitiveType) : (DataType)this.converter.refreshNamedElement(PrimitiveType.class, PivotPackage.Literals.PRIMITIVE_TYPE, (org.eclipse.uml2.uml.NamedElement)umlPrimitiveType);
        }
        if (asPrimitiveType != null && (umlPackage = umlPrimitiveType.getPackage()) != null) {
            String string = umlPackage.getURI();
        }
        this.copyClassifier((Class)pivotElement, (Classifier)umlPrimitiveType);
        String instanceClassName = null;
        PrimitiveType behavioralClass = asPrimitiveType;
        if (ecoreStereotype != null && (object = umlPrimitiveType.getValue(ecoreStereotype, "instanceClassName")) instanceof String) {
            instanceClassName = (String)object;
            behavioralClass = this.getPrimitiveTypeByEcoreStereotype(ecoreStereotype, instanceClassName);
        }
        pivotElement.setInstanceClassName(instanceClassName);
        pivotElement.setBehavioralClass((Class)behavioralClass);
        return pivotElement;
    }

    public Object caseProfile(org.eclipse.uml2.uml.Profile umlProfile) {
        assert (umlProfile != null);
        Profile pivotElement = this.converter.refreshNamedElement(Profile.class, PivotPackage.Literals.PROFILE, (org.eclipse.uml2.uml.NamedElement)umlProfile);
        this.copyPackage((Package)pivotElement, (org.eclipse.uml2.uml.Package)umlProfile);
        return pivotElement;
    }

    public Object caseProfileApplication(org.eclipse.uml2.uml.ProfileApplication umlProfileApplication) {
        assert (umlProfileApplication != null);
        ProfileApplication pivotElement = this.converter.refreshElement(ProfileApplication.class, PivotPackage.Literals.PROFILE_APPLICATION, (EObject)umlProfileApplication);
        this.converter.copyModelElement((Element)pivotElement, (org.eclipse.uml2.uml.Element)umlProfileApplication);
        this.converter.queueReference((EObject)umlProfileApplication);
        return pivotElement;
    }

    public Object caseProperty(org.eclipse.uml2.uml.Property umlProperty) {
        assert (umlProperty != null);
        Association umlAssociation = umlProperty.getAssociation();
        if (umlAssociation != null && !(umlAssociation instanceof Extension)) {
            return this;
        }
        Property pivotElement = this.converter.refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, (org.eclipse.uml2.uml.NamedElement)umlProperty);
        this.copyProperty(pivotElement, umlProperty, null);
        org.eclipse.uml2.uml.Element owner = umlProperty.getOwner();
        boolean isComposer = true;
        pivotElement.setIsComposite(isComposer && umlProperty.isComposite());
        pivotElement.setIsImplicit(!isComposer);
        this.converter.queueReference((EObject)umlProperty);
        this.converter.queueUse((EObject)umlProperty);
        return pivotElement;
    }

    public Pseudostate casePseudostate(org.eclipse.uml2.uml.Pseudostate umlPseudostate) {
        assert (umlPseudostate != null);
        Pseudostate pivotElement = this.converter.refreshNamedElement(Pseudostate.class, PivotPackage.Literals.PSEUDOSTATE, (org.eclipse.uml2.uml.NamedElement)umlPseudostate);
        this.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlPseudostate);
        return pivotElement;
    }

    public Region caseRegion(org.eclipse.uml2.uml.Region umlRegion) {
        assert (umlRegion != null);
        Region pivotElement = this.converter.refreshNamedElement(Region.class, PivotPackage.Literals.REGION, (org.eclipse.uml2.uml.NamedElement)umlRegion);
        this.copyNamespace((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlRegion);
        this.doSwitchAll(pivotElement.getOwnedSubvertexes(), (List)umlRegion.getSubvertices(), null);
        this.doSwitchAll(pivotElement.getOwnedTransitions(), (List)umlRegion.getTransitions(), null);
        return pivotElement;
    }

    public Signal caseSignal(org.eclipse.uml2.uml.Signal umlSignal) {
        assert (umlSignal != null);
        Signal pivotElement = this.converter.refreshNamedElement(Signal.class, PivotPackage.Literals.SIGNAL, (org.eclipse.uml2.uml.NamedElement)umlSignal);
        this.copyClassOrInterface((Class)pivotElement, (Classifier)umlSignal);
        this.converter.queueReference((EObject)umlSignal);
        return pivotElement;
    }

    public Slot caseSlot(org.eclipse.uml2.uml.Slot umlSlot) {
        assert (umlSlot != null);
        Slot pivotElement = this.converter.refreshElement(Slot.class, PivotPackage.Literals.SLOT, (EObject)umlSlot);
        this.doSwitchAll(pivotElement.getOwnedValues(), (List)umlSlot.getValues(), null);
        this.converter.setOriginalMapping((Element)pivotElement, (EObject)umlSlot);
        this.converter.queueReference((EObject)umlSlot);
        return pivotElement;
    }

    public State caseState(org.eclipse.uml2.uml.State umlState) {
        assert (umlState != null);
        State pivotElement = this.converter.refreshNamedElement(State.class, PivotPackage.Literals.STATE, (org.eclipse.uml2.uml.NamedElement)umlState);
        this.copyState(pivotElement, umlState);
        return pivotElement;
    }

    public StateMachine caseStateMachine(org.eclipse.uml2.uml.StateMachine umlStateMachine) {
        assert (umlStateMachine != null);
        StateMachine pivotElement = this.converter.refreshNamedElement(StateMachine.class, PivotPackage.Literals.STATE_MACHINE, (org.eclipse.uml2.uml.NamedElement)umlStateMachine);
        this.copyClass((Class)pivotElement, (org.eclipse.uml2.uml.Class)umlStateMachine);
        this.doSwitchAll(pivotElement.getOwnedRegions(), (List)umlStateMachine.getRegions(), null);
        return pivotElement;
    }

    public Stereotype caseStereotype(org.eclipse.uml2.uml.Stereotype umlStereotype) {
        assert (umlStereotype != null);
        Stereotype pivotElement = this.converter.refreshNamedElement(Stereotype.class, PivotPackage.Literals.STEREOTYPE, (org.eclipse.uml2.uml.NamedElement)umlStereotype);
        this.copyClass((Class)pivotElement, (org.eclipse.uml2.uml.Class)umlStereotype);
        this.converter.queueReference((EObject)umlStereotype);
        return pivotElement;
    }

    public Transition caseTransition(org.eclipse.uml2.uml.Transition umlTransition) {
        assert (umlTransition != null);
        Transition pivotElement = this.converter.refreshNamedElement(Transition.class, PivotPackage.Literals.TRANSITION, (org.eclipse.uml2.uml.NamedElement)umlTransition);
        this.copyNamespace((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlTransition);
        return pivotElement;
    }

    public DynamicValueSpecification caseValueSpecification(ValueSpecification umlValueSpecification) {
        assert (umlValueSpecification != null);
        DynamicValueSpecification pivotElement = (DynamicValueSpecification)this.converter.refreshElement(DynamicValueSpecification.class, PivotPackage.Literals.DYNAMIC_VALUE_SPECIFICATION, (EModelElement)umlValueSpecification);
        this.converter.setOriginalMapping((Element)pivotElement, (EObject)umlValueSpecification);
        return pivotElement;
    }

    protected void copyAnnotatedElement(@NonNull NamedElement pivotElement, @NonNull EModelElement umlElement, @Nullable List<EAnnotation> excludedAnnotations) {
        List pivotAnnotations = pivotElement.getOwnedAnnotations();
        for (EAnnotation eAnnotation : umlElement.getEAnnotations()) {
            Element pivotAnnotation;
            if (excludedAnnotations != null && excludedAnnotations.contains(eAnnotation) || (pivotAnnotation = (Element)this.doSwitch((EObject)eAnnotation)) == null) continue;
            pivotAnnotations.add(pivotAnnotation);
        }
    }

    protected void copyClassOrInterface(@NonNull Class pivotElement, @NonNull Classifier umlClassifier) {
        Object object;
        this.copyClassifier(pivotElement, umlClassifier);
        pivotElement.setIsAbstract(umlClassifier.isAbstract());
        String instanceClassName = null;
        org.eclipse.uml2.uml.Stereotype ecoreStereotype = umlClassifier.getAppliedStereotype("Ecore::EClass");
        if (ecoreStereotype != null && (object = umlClassifier.getValue(ecoreStereotype, "instanceClassName")) instanceof String) {
            instanceClassName = (String)object;
        }
        pivotElement.setInstanceClassName(instanceClassName);
        @NonNull EList umlAttributes = umlClassifier.getAttributes();
        this.doSwitchAll((List<? extends EObject>)umlAttributes);
        this.converter.queueUse((EObject)umlClassifier);
    }

    protected void copyClass(@NonNull Class pivotElement, @NonNull org.eclipse.uml2.uml.Class umlClass) {
        pivotElement.setIsInterface(false);
        this.copyClassOrInterface(pivotElement, (Classifier)umlClass);
        this.doSwitchAll(pivotElement.getOwnedBehaviors(), (List)umlClass.getOwnedBehaviors(), null);
    }

    protected void copyClassifier(@NonNull Class pivotElement, @NonNull Classifier umlClassifier) {
        this.copyNamespace((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlClassifier);
        this.copyTemplateSignature((TemplateableElement)pivotElement, umlClassifier.getOwnedTemplateSignature());
        this.doSwitchAll(pivotElement.getOwnedOperations(), (List)umlClassifier.getOperations(), null);
    }

    protected void copyComments(@NonNull Element pivotElement, @NonNull org.eclipse.uml2.uml.Element umlElement) {
        this.doSwitchAll(pivotElement.getOwnedComments(), (List)umlElement.getOwnedComments(), null);
    }

    protected void copyDataTypeOrEnum(@NonNull DataType pivotElement, @NonNull org.eclipse.uml2.uml.DataType umlDataType) {
        PrimitiveType asPrimitiveType;
        Object object;
        this.copyClassifier((Class)pivotElement, (Classifier)umlDataType);
        String instanceClassName = null;
        org.eclipse.uml2.uml.Stereotype ecoreStereotype = umlDataType.getAppliedStereotype("Ecore::EClass");
        if (ecoreStereotype == null) {
            ecoreStereotype = umlDataType.getAppliedStereotype("Ecore::EDataType");
        }
        if (ecoreStereotype == null) {
            ecoreStereotype = umlDataType.getAppliedStereotype("Ecore::EClassifier");
        }
        if (ecoreStereotype != null && (object = umlDataType.getValue(ecoreStereotype, "instanceClassName")) instanceof String) {
            instanceClassName = (String)object;
            pivotElement.setBehavioralClass((Class)this.getPrimitiveTypeByEcoreStereotype(ecoreStereotype, instanceClassName));
        }
        if ((asPrimitiveType = this.getPrimitiveTypeByOCLStereotype(umlDataType)) != null) {
            pivotElement.setBehavioralClass((Class)asPrimitiveType);
            if (instanceClassName == null) {
                instanceClassName = asPrimitiveType == this.standardLibrary.getIntegerType() ? IntegerValue.class.getName() : RealValue.class.getName();
            }
        }
        pivotElement.setInstanceClassName(instanceClassName);
        this.converter.queueReference((EObject)umlDataType);
    }

    protected void copyNamedElement(@NonNull NamedElement pivotElement, @NonNull org.eclipse.uml2.uml.NamedElement umlNamedElement) {
        this.converter.copyNamedElement(pivotElement, umlNamedElement);
        this.copyAnnotatedElement(pivotElement, (EModelElement)umlNamedElement, null);
        this.copyComments((Element)pivotElement, (org.eclipse.uml2.uml.Element)umlNamedElement);
    }

    protected void copyNamespace(@NonNull Namespace pivotElement, @NonNull org.eclipse.uml2.uml.Namespace umlNamespace) {
        this.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlNamespace);
        this.converter.queueUse((EObject)umlNamespace);
    }

    protected void copyPackage(@NonNull Package pivotElement, @NonNull org.eclipse.uml2.uml.Package umlPackage) {
        this.copyNamespace((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlPackage);
        Object nsPrefix = null;
        Object nsURI = umlPackage.getURI();
        org.eclipse.uml2.uml.Stereotype ecoreStereotype = this.getEcoreStereotype((EObject)umlPackage, "EPackage");
        if (ecoreStereotype != null && umlPackage.isStereotypeApplied(ecoreStereotype)) {
            nsPrefix = umlPackage.getValue(ecoreStereotype, "nsPrefix");
            if (nsURI == null) {
                nsURI = umlPackage.getValue(ecoreStereotype, "nsURI");
            }
        }
        pivotElement.setNsPrefix(nsPrefix != null ? nsPrefix.toString() : null);
        if (nsURI instanceof String) {
            String sharedURI;
            String nsURI2 = nsURI;
            if (!(umlPackage instanceof org.eclipse.uml2.uml.Profile) && nsURI2.startsWith("http://www.omg.org/spec/")) {
                String packageName = umlPackage.getName();
                if ("UML".equals(packageName)) {
                    for (org.eclipse.uml2.uml.Type umlType : umlPackage.getOwnedTypes()) {
                        if (!(umlType instanceof org.eclipse.uml2.uml.Class) || !"Class".equals(umlType.getName())) continue;
                        this.metamodelManager.getCompleteModel().addPackageURI2completeURI(nsURI2, "$uml$");
                        ((PackageImpl)pivotElement).setIgnoreInvariants(true);
                        break;
                    }
                } else if ("PrimitiveTypes".equals(packageName)) {
                    for (org.eclipse.uml2.uml.Type umlType : umlPackage.getOwnedTypes()) {
                        if (!(umlType instanceof org.eclipse.uml2.uml.PrimitiveType) || !"Boolean".equals(umlType.getName())) continue;
                        this.metamodelManager.getCompleteModel().addPackageURI2completeURI(nsURI2, "$types$");
                        break;
                    }
                }
            }
            if ((sharedURI = this.metamodelManager.getCompleteModel().getCompleteURI(nsURI2)) != null && !sharedURI.equals(nsURI)) {
                ((PackageImpl)pivotElement).setPackageId((PackageId)IdManager.getRootPackageId((String)sharedURI));
            }
        }
        pivotElement.setURI(nsURI != null ? nsURI.toString() : null);
        ArrayList<org.eclipse.uml2.uml.Constraint> umlConstraints = null;
        ArrayList<org.eclipse.uml2.uml.Element> umlOtherElements = null;
        ArrayList<org.eclipse.uml2.uml.InstanceSpecification> umlInstanceSpecifications = null;
        ArrayList<org.eclipse.uml2.uml.Package> umlNestedPackages = null;
        ArrayList<org.eclipse.uml2.uml.Package> umlImportedPackages = null;
        ArrayList<org.eclipse.uml2.uml.ProfileApplication> umlProfileApplications = null;
        ArrayList<org.eclipse.uml2.uml.Type> umlTypes = null;
        ArrayList<Association> umlAssociations = null;
        for (org.eclipse.uml2.uml.Element ownedElement : umlPackage.getOwnedElements()) {
            if (ownedElement instanceof org.eclipse.uml2.uml.Package) {
                if (umlNestedPackages == null) {
                    umlNestedPackages = new ArrayList<org.eclipse.uml2.uml.Package>();
                }
                umlNestedPackages.add((org.eclipse.uml2.uml.Package)ownedElement);
                continue;
            }
            if (ownedElement instanceof PackageImport) {
                if (umlImportedPackages == null) {
                    umlImportedPackages = new ArrayList<org.eclipse.uml2.uml.Package>();
                }
                umlImportedPackages.add(((PackageImport)ownedElement).getImportedPackage());
                continue;
            }
            if (ownedElement instanceof Association) {
                if (umlAssociations == null) {
                    umlAssociations = new ArrayList<Association>();
                }
                umlAssociations.add((Association)ownedElement);
                continue;
            }
            if (ownedElement instanceof org.eclipse.uml2.uml.Constraint) {
                if (umlConstraints == null) {
                    umlConstraints = new ArrayList<org.eclipse.uml2.uml.Constraint>();
                }
                umlConstraints.add((org.eclipse.uml2.uml.Constraint)ownedElement);
                continue;
            }
            if (ownedElement instanceof org.eclipse.uml2.uml.InstanceSpecification) {
                if (umlInstanceSpecifications == null) {
                    umlInstanceSpecifications = new ArrayList<org.eclipse.uml2.uml.InstanceSpecification>();
                }
                umlInstanceSpecifications.add((org.eclipse.uml2.uml.InstanceSpecification)ownedElement);
                continue;
            }
            if (ownedElement instanceof org.eclipse.uml2.uml.Type) {
                if (umlTypes == null) {
                    umlTypes = new ArrayList<org.eclipse.uml2.uml.Type>();
                }
                umlTypes.add((org.eclipse.uml2.uml.Type)ownedElement);
                continue;
            }
            if (ownedElement instanceof org.eclipse.uml2.uml.ProfileApplication) {
                if (umlProfileApplications == null) {
                    umlProfileApplications = new ArrayList<org.eclipse.uml2.uml.ProfileApplication>();
                }
                umlProfileApplications.add((org.eclipse.uml2.uml.ProfileApplication)ownedElement);
                continue;
            }
            if (ownedElement instanceof org.eclipse.uml2.uml.Comment) continue;
            if (umlOtherElements == null) {
                umlOtherElements = new ArrayList<org.eclipse.uml2.uml.Element>();
            }
            umlOtherElements.add(ownedElement);
        }
        if (umlInstanceSpecifications != null) {
            this.doSwitchAll(pivotElement.getOwnedInstances(), umlInstanceSpecifications, null);
        } else {
            pivotElement.getOwnedInstances().clear();
        }
        if (umlNestedPackages != null) {
            this.doSwitchAll(pivotElement.getOwnedPackages(), umlNestedPackages, null);
        } else {
            pivotElement.getOwnedPackages().clear();
        }
        if (umlProfileApplications != null) {
            this.doSwitchAll(pivotElement.getOwnedProfileApplications(), umlProfileApplications, null);
            for (org.eclipse.uml2.uml.ProfileApplication umlProfileApplication : umlProfileApplications) {
                org.eclipse.uml2.uml.Profile appliedProfile;
                if (umlProfileApplication == null || (appliedProfile = umlProfileApplication.getAppliedProfile()) == null) continue;
                if (umlImportedPackages == null) {
                    umlImportedPackages = new ArrayList();
                }
                umlImportedPackages.add((org.eclipse.uml2.uml.Package)appliedProfile);
            }
        } else {
            pivotElement.getOwnedProfileApplications().clear();
        }
        ArrayList<@NonNull AssociationClass> asClasses = new ArrayList<AssociationClass>();
        if (umlTypes != null) {
            this.doSwitchAll(asClasses, umlTypes, null);
        } else {
            asClasses.clear();
        }
        if (umlAssociations != null) {
            for (Association umlAssociation : umlAssociations) {
                Object asAssociation = this.doSwitch((EObject)umlAssociation);
                if (!(asAssociation instanceof AssociationClass)) continue;
                asClasses.add((AssociationClass)asAssociation);
            }
        }
        this.converter.refreshList(pivotElement.getOwnedClasses(), asClasses);
        if (umlConstraints != null) {
            this.doSwitchAll(pivotElement.getOwnedConstraints(), umlConstraints, null);
        }
        if (umlOtherElements != null) {
            this.doSwitchAll(pivotElement.getOwnedAnnotations(), umlOtherElements, null);
        } else {
            pivotElement.getOwnedAnnotations().clear();
        }
        if (umlImportedPackages != null) {
            this.converter.addImportedPackages(umlImportedPackages);
            this.converter.queueUse((EObject)umlPackage);
        } else {
            pivotElement.getImportedPackages().clear();
        }
    }

    protected void copyProperty(@NonNull Property pivotElement, @NonNull org.eclipse.uml2.uml.Property umlProperty, List<EAnnotation> excludedAnnotations) {
        this.copyTypedElement((TypedElement)pivotElement, (org.eclipse.uml2.uml.TypedElement)umlProperty, excludedAnnotations);
        pivotElement.setIsReadOnly(umlProperty.isReadOnly());
        pivotElement.setIsDerived(umlProperty.isDerived());
    }

    protected void copyState(@NonNull State pivotElement, @NonNull org.eclipse.uml2.uml.State umlState) {
        this.copyNamespace((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlState);
        this.doSwitchAll(pivotElement.getOwnedRegions(), (List)umlState.getRegions(), null);
    }

    protected void copyTemplateSignature(TemplateableElement pivotElement, org.eclipse.uml2.uml.TemplateSignature umlTemplateSignature) {
        EList umlTemplateParameters;
        if (umlTemplateSignature != null && !(umlTemplateParameters = umlTemplateSignature.getOwnedParameters()).isEmpty()) {
            TemplateSignature pivotTemplateSignature = PivotFactory.eINSTANCE.createTemplateSignature();
            pivotElement.setOwnedSignature(pivotTemplateSignature);
            this.doSwitchAll(pivotTemplateSignature.getOwnedParameters(), (List)umlTemplateParameters, null);
        }
    }

    protected void copyTypedElement(@NonNull TypedElement pivotElement, @NonNull org.eclipse.uml2.uml.TypedElement umlTypedElement, List<EAnnotation> excludedAnnotations) {
        this.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlTypedElement);
        int lower = ((MultiplicityElement)umlTypedElement).getLower();
        int upper = ((MultiplicityElement)umlTypedElement).getUpper();
        pivotElement.setIsRequired(upper == 1 && lower == 1);
        org.eclipse.uml2.uml.Type umlType = umlTypedElement.getType();
        if (umlType != null) {
            this.converter.queueReference((EObject)umlTypedElement);
            Resource umlResource = umlType.eResource();
            if (umlResource != null) {
                this.converter.addImportedResource(umlResource);
            }
        }
    }

    public Element defaultCase(EObject umlObject) {
        DynamicElement pivotElement;
        if (umlObject instanceof org.eclipse.uml2.uml.Type) {
            pivotElement = (DynamicElement)this.converter.refreshElement(DynamicType.class, PivotPackage.Literals.DYNAMIC_TYPE, umlObject);
            ((DynamicType)pivotElement).setName(((org.eclipse.uml2.uml.Type)umlObject).getName());
        } else if (umlObject instanceof org.eclipse.uml2.uml.Element) {
            pivotElement = this.converter.refreshElement(DynamicElement.class, PivotPackage.Literals.DYNAMIC_ELEMENT, umlObject);
        } else {
            this.converter.error("Unsupported " + umlObject.eClass().getName() + " for UML2ASDeclarationSwitch");
            return null;
        }
        this.converter.setOriginalMapping((Element)pivotElement, umlObject);
        this.doSwitchAll(pivotElement.getOwnedAnnotations(), (List)((org.eclipse.uml2.uml.Element)umlObject).getOwnedElements(), null);
        EClass umlMetaClass = umlObject.eClass();
        Type metaType = (Type)this.metamodelManager.getASOfEcore(Type.class, (EObject)umlMetaClass);
        pivotElement.setMetaType(metaType);
        if (umlObject instanceof org.eclipse.uml2.uml.Slot) {
            this.converter.queueUse(umlObject);
        }
        return pivotElement;
    }

    public Object doInPackageSwitch(@NonNull EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public Object doSwitch(EObject eObject) {
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == UMLPackage.eINSTANCE) {
            return this.doInPackageSwitch(eObject);
        }
        if (ePackage == EcorePackage.eINSTANCE) {
            if (eObject.eContainer() instanceof org.eclipse.uml2.uml.Profile) {
                return null;
            }
            return this.ecoreSwitch.doInPackageSwitch(eObject);
        }
        if (ePackage.getNsURI().startsWith("http://www.omg.org/spec/MOF")) {
            if (eObject instanceof AnyType && "Tag".equals(eClass.getName())) {
                Package asPackage;
                FeatureMap anyAttribute = ((AnyType)eObject).getAnyAttribute();
                Object name = null;
                Object value = null;
                Object element = null;
                for (FeatureMap.Entry entry : anyAttribute) {
                    EStructuralFeature eFeature = entry.getEStructuralFeature();
                    if ("name".equals(eFeature.getName())) {
                        name = anyAttribute.get(eFeature, false);
                        continue;
                    }
                    if ("value".equals(eFeature.getName())) {
                        value = anyAttribute.get(eFeature, false);
                        continue;
                    }
                    if (!"element".equals(eFeature.getName())) continue;
                    element = anyAttribute.get(eFeature, false);
                }
                boolean gotIt = false;
                EObject taggedObject = eObject.eResource().getEObject(String.valueOf(element));
                if ("org.omg.xmi.nsPrefix".equals(name) && taggedObject instanceof org.eclipse.uml2.uml.Package) {
                    asPackage = (Package)this.converter.getCreated(Package.class, taggedObject);
                    if (asPackage != null) {
                        asPackage.setNsPrefix(String.valueOf(value));
                        gotIt = true;
                    }
                } else if ("org.omg.xmi.nsURI".equals(name) && taggedObject instanceof org.eclipse.uml2.uml.Package) {
                    asPackage = (Package)this.converter.getCreated(Package.class, taggedObject);
                    if (asPackage != null) {
                        asPackage.setURI(String.valueOf(value));
                        gotIt = true;
                    }
                } else if ("org.omg.xmi.schemaType".equals(name) && taggedObject instanceof org.eclipse.uml2.uml.DataType && (asPackage = (DataType)this.converter.getCreated(DataType.class, taggedObject)) != null) {
                    System.out.println("Unknown " + ePackage.getNsURI() + "::" + eObject.eClass().getName() + "::" + name + " ignored");
                    gotIt = true;
                }
                if (!gotIt) {
                    logger.warn((Object)("Unknown " + ePackage.getNsURI() + "::" + eObject.eClass().getName() + "::" + name + " ignored"));
                }
            }
            return null;
        }
        if (ePackage.getNsURI().startsWith("http://www.eclipse.org/uml2/schemas/Ecore")) {
            return null;
        }
        this.converter.addStereotypeApplication(eObject);
        return null;
    }

    public <T extends Element, V extends EObject> void doSwitchAll(Collection<T> pivotObjects, List<V> eObjects, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AbstractConversion.Predicate<V> predicate) {
        assert (pivotObjects != null);
        assert (eObjects != null);
        eObjects.size();
        for (EObject eObject : eObjects) {
            Element pivotObject;
            if (eObject == null || predicate != null && !predicate.filter(eObject) || (pivotObject = (Element)this.doSwitch(eObject)) == null) continue;
            pivotObjects.add(pivotObject);
        }
    }

    public <T extends Element> void doSwitchAll(@NonNull List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            this.doSwitch(eObject);
        }
    }

    protected org.eclipse.uml2.uml.Profile getEcoreProfile(EObject eObject) {
        ResourceSet resourceSet;
        Resource eResource = eObject.eResource();
        if (eResource != null && (resourceSet = eResource.getResourceSet()) != null) {
            return (org.eclipse.uml2.uml.Profile)UML2Util.load((ResourceSet)resourceSet, (URI)URI.createURI((String)"pathmap://UML_PROFILES/Ecore.profile.uml"), (EClass)UMLPackage.Literals.PROFILE);
        }
        return null;
    }

    protected org.eclipse.uml2.uml.Stereotype getEcoreStereotype(EObject eObject, String name) {
        org.eclipse.uml2.uml.Profile ecoreProfile = this.getEcoreProfile(eObject);
        return ecoreProfile != null ? ecoreProfile.getOwnedStereotype(name) : null;
    }

    protected @Nullable PrimitiveType getPrimitiveTypeByEcoreStereotype(@NonNull org.eclipse.uml2.uml.Stereotype ecoreStereotype, @NonNull String instanceClassName) {
        if ("boolean".equals(instanceClassName)) {
            return this.standardLibrary.getBooleanType();
        }
        if ("byte".equals(instanceClassName) || "char".equals(instanceClassName) || "int".equals(instanceClassName) || "long".equals(instanceClassName) || "short".equals(instanceClassName)) {
            return this.standardLibrary.getIntegerType();
        }
        if ("double".equals(instanceClassName) || "float".equals(instanceClassName)) {
            return this.standardLibrary.getRealType();
        }
        try {
            @NonNull ClassLoader classLoader = ecoreStereotype.getClass().getClassLoader();
            java.lang.Class<?> instanceClass = classLoader.loadClass(instanceClassName);
            if (instanceClass != null) {
                PrimitiveType behavioralClass = this.standardLibrary.getBehavioralClass(instanceClass);
                if (behavioralClass != null) {
                    return behavioralClass;
                }
                instanceClass.getDeclaredMethod("compareTo", instanceClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected @Nullable PrimitiveType getPrimitiveTypeByName(@NonNull org.eclipse.uml2.uml.PrimitiveType umlPrimitiveType) {
        String name = umlPrimitiveType.getName();
        if (UMLUtil.isBoolean((org.eclipse.uml2.uml.Type)umlPrimitiveType) || "Boolean".equals(name)) {
            return this.standardLibrary.getBooleanType();
        }
        if (UMLUtil.isInteger((org.eclipse.uml2.uml.Type)umlPrimitiveType) || "Integer".equals(name)) {
            return this.standardLibrary.getIntegerType();
        }
        if (UMLUtil.isReal((org.eclipse.uml2.uml.Type)umlPrimitiveType) || "Real".equals(name)) {
            return this.standardLibrary.getRealType();
        }
        if (UMLUtil.isString((org.eclipse.uml2.uml.Type)umlPrimitiveType) || "String".equals(name)) {
            return this.standardLibrary.getStringType();
        }
        if (UMLUtil.isUnlimitedNatural((org.eclipse.uml2.uml.Type)umlPrimitiveType) || "UnlimitedNatural".equals(name)) {
            return this.standardLibrary.getUnlimitedNaturalType();
        }
        org.eclipse.uml2.uml.Package umlPackage = umlPrimitiveType.getPackage();
        if (umlPackage != null && "EcorePrimitiveTypes".equals(umlPackage.getName())) {
            if ("EBigDecimal".equals(name) || "EFloat".equals(name) || "EFloatObject".equals(name)) {
                return this.standardLibrary.getRealType();
            }
            if ("EBigInteger".equals(name) || "EByte".equals(name) || "EByteObject".equals(name) || "EChar".equals(name) || "ECharacterObject".equals(name) || "ELong".equals(name) || "ELongObject".equals(name) || "EShortObject".equals(name) || "EShortObject".equals(name)) {
                return this.standardLibrary.getIntegerType();
            }
        }
        return null;
    }

    protected @Nullable PrimitiveType getPrimitiveTypeByOCLStereotype(@NonNull org.eclipse.uml2.uml.DataType umlDataType) {
        if (umlDataType.getAppliedStereotype("OCLforUML::Integer") != null) {
            return this.standardLibrary.getIntegerType();
        }
        if (umlDataType.getAppliedStereotype("OCLforUML::Real") != null) {
            return this.standardLibrary.getRealType();
        }
        return null;
    }
}

