/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.general.general;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ActivityRelKind implements Enumerator
{
    DECOMPOSITION(0, "Decomposition", "Decomposition"),
    PRECEDENCE(1, "Precedence", "Precedence");

    public static final int DECOMPOSITION_VALUE = 0;
    public static final int PRECEDENCE_VALUE = 1;
    private static final ActivityRelKind[] VALUES_ARRAY;
    public static final List<ActivityRelKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ActivityRelKind[]{DECOMPOSITION, PRECEDENCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ActivityRelKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivityRelKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivityRelKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivityRelKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivityRelKind get(int value) {
        switch (value) {
            case 0: {
                return DECOMPOSITION;
            }
            case 1: {
                return PRECEDENCE;
            }
        }
        return null;
    }

    private ActivityRelKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

