/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.exporter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.cdo.core.importer.IModelDependentsProvider;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.core.importer.DependencyAdapter;

public class CDODIDependentsProvider
implements IModelDependentsProvider {
    private boolean completedScan;

    @Override
    public Collection<URI> getDependents(Resource resource, IProgressMonitor monitor) {
        HashSet result = Sets.newHashSet();
        Resource di = DependencyAdapter.getDIResource(resource);
        if (di != null) {
            for (Resource component : DependencyAdapter.getDependencies(di)) {
                for (Resource next : DependencyAdapter.getDependents(component)) {
                    Resource dependentDI = DependencyAdapter.getDIResource(next);
                    if (dependentDI == null || dependentDI == di) continue;
                    result.add(dependentDI.getURI());
                }
            }
        }
        return result;
    }

    @Override
    public Collection<URI> getComponents(Resource diResource, IProgressMonitor monitor) {
        ImmutableList result;
        if (!(diResource instanceof CDOResource)) {
            result = Collections.emptyList();
        } else {
            ImmutableList.Builder uris = ImmutableList.builder();
            CDOResource cdo = (CDOResource)diResource;
            CDOView view = cdo.cdoView();
            URI baseURI = cdo.getURI().trimFileExtension();
            CDOResourceFolder folder = cdo.getFolder();
            Iterable inSameFolder = Iterables.filter((Iterable)(folder == null ? view.getRootResource().getContents() : folder.getNodes()), CDOResource.class);
            for (CDOResource next : inSameFolder) {
                URI uri = next.getURI();
                if (next == cdo || !uri.trimFileExtension().equals(baseURI)) continue;
                uris.add((Object)next.getURI());
            }
            result = uris.build();
        }
        return result;
    }

    private void scanRepository(ResourceSet resourceSet) {
        this.completedScan = true;
        TreeIterator repositoryIterator = CDOUtils.getView(resourceSet).getRootResource().eAllContents();
        while (repositoryIterator.hasNext()) {
            CDOResourceNode next = (CDOResourceNode)repositoryIterator.next();
            if (next instanceof CDOResource) {
                CDOResource resource = (CDOResource)next;
                if (DependencyAdapter.isDIResource((Resource)resource)) {
                    DependencyAdapter.getInstance((Resource)resource);
                }
                repositoryIterator.prune();
                continue;
            }
            if (next instanceof CDOResourceFolder) continue;
            repositoryIterator.prune();
        }
    }
}

