/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.importer;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferListener;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferMapping;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferMappingListener;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.core.importer.ModelTransferListenerAdapter;
import org.eclipse.papyrus.cdo.internal.core.Activator;
import org.eclipse.papyrus.cdo.internal.core.l10n.Messages;

public abstract class AbstractModelTransferMapping
implements IModelTransferMapping {
    private final IModelTransferConfiguration config;
    private final Map<IModelTransferNode, IPath> mappings = Maps.newHashMap();
    private CDOCheckout checkout;
    private final CopyOnWriteArrayList<IModelTransferMappingListener> listeners = new CopyOnWriteArrayList();

    public AbstractModelTransferMapping(IModelTransferConfiguration config) {
        this.config = config;
        config.addModelTransferListener(this.createConfigurationListener());
    }

    @Override
    public IModelTransferConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void mapTo(IModelTransferNode source, IPath path) {
        if (!Objects.equal((Object)this.getMapping(source), (Object)path)) {
            this.mappings.put(source, path);
            this.fireMappingChanged(source);
        }
    }

    @Override
    public IPath getMapping(IModelTransferNode node) {
        return this.mappings.get(node);
    }

    @Override
    public CDOCheckout getCheckout() {
        return this.checkout;
    }

    @Override
    public void setCheckout(CDOCheckout checkout) {
        if (checkout != this.checkout) {
            this.checkout = checkout;
            this.fireCheckoutChanged();
        }
    }

    @Override
    public Diagnostic validate() {
        BasicDiagnostic result = new BasicDiagnostic();
        if (this.validateRepository((DiagnosticChain)result)) {
            for (IModelTransferNode node : this.getConfiguration().getModelsToTransfer()) {
                this.validateMapping(node, (DiagnosticChain)result);
            }
            this.validateUniqueMappings((DiagnosticChain)result);
        }
        this.fireProblemsEvent((Diagnostic)result);
        return result;
    }

    protected abstract boolean validateMapping(IModelTransferNode var1, DiagnosticChain var2);

    protected void validateUniqueMappings(DiagnosticChain diagnostics) {
        HashSet paths = Sets.newHashSet();
        for (IModelTransferNode next : this.getConfiguration().getModelsToTransfer()) {
            IPath mapping = this.getMapping(next);
            if (mapping == null || paths.add(mapping)) continue;
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, NLS.bind((String)Messages.AbstractModelTransferMapping_0, (Object)mapping), new Object[]{next}));
            break;
        }
    }

    protected boolean validateRepository(DiagnosticChain diagnostics) {
        boolean result = true;
        if (this.getCheckout() == null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, Messages.AbstractModelTransferMapping_1, null));
            result = false;
        } else if (!this.getCheckout().isOpen()) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, NLS.bind((String)Messages.AbstractModelTransferMapping_2, (Object)this.getCheckout().getLabel()), new Object[]{this.getCheckout()}));
            result = false;
        }
        return result;
    }

    @Override
    public void addModelTransferMappingListener(IModelTransferMappingListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeModelTransferMappingListener(IModelTransferMappingListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireProblemsEvent(Diagnostic problems) {
        if (problems.getSeverity() > 0) {
            for (IModelTransferMappingListener next : this.listeners) {
                try {
                    next.modelTransferMappingProblemsOccurred(problems);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in model transfer mapping listener.", (Throwable)e);
                }
            }
        }
    }

    protected void fireMappingChanged(IModelTransferNode node) {
        for (IModelTransferMappingListener next : this.listeners) {
            try {
                next.modelTransferMappingChanged(node);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in model transfer mapping listener.", (Throwable)e);
            }
        }
    }

    protected void fireCheckoutChanged() {
        for (IModelTransferMappingListener next : this.listeners) {
            try {
                next.modelTransferRepositoryChanged(this);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in model transfer mapping listener.", (Throwable)e);
            }
        }
    }

    private IModelTransferListener createConfigurationListener() {
        return new ModelTransferListenerAdapter(){

            @Override
            public void modelsToTransferChanged(IModelTransferConfiguration configuration) {
                AbstractModelTransferMapping.this.computeDefaultMappings(configuration);
            }
        };
    }

    protected void computeDefaultMappings(IModelTransferConfiguration configuration) {
    }
}

