/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.importer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferOperation;
import org.eclipse.papyrus.cdo.internal.core.importer.DependencyAdapter;
import org.eclipse.papyrus.cdo.internal.core.importer.ModelTransferConfiguration;
import org.eclipse.papyrus.cdo.internal.core.l10n.Messages;

public class ModelTransferNode
implements IModelTransferNode {
    private final ModelTransferConfiguration config;
    private Resource resource;
    private String name;
    private Set<Resource> components = Sets.newLinkedHashSet();
    private Set<IModelTransferNode> dependencies = Sets.newLinkedHashSet();
    private Set<IModelTransferNode> dependents = Sets.newLinkedHashSet();

    public ModelTransferNode(ModelTransferConfiguration config, Resource resource) {
        this.config = config;
        this.resource = resource;
    }

    void initialize(IModelTransferOperation.Context context) {
        context.run(new IModelTransferOperation(){

            @Override
            public Diagnostic run(IProgressMonitor monitor) {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ModelTransferNode_0, (int)2);
                ModelTransferNode.this.components.add(ModelTransferNode.this.resource);
                ModelTransferNode.this.scanForComponents();
                sub.worked(1);
                ModelTransferNode.this.scanForDependencies();
                sub.worked(1);
                sub.done();
                return Diagnostic.OK_INSTANCE;
            }
        });
    }

    @Override
    public String getName() {
        if (this.name == null) {
            URI uri = this.getPrimaryResourceURI();
            String path = uri.path();
            if (uri.isPlatformResource()) {
                path = path.substring(("/" + uri.segment(0)).length());
            }
            this.name = path;
        }
        return this.name;
    }

    @Override
    public IModelTransferConfiguration getConfiguration() {
        return this.config;
    }

    Resource getPrimaryResource() {
        return this.resource;
    }

    @Override
    public URI getPrimaryResourceURI() {
        return this.resource.getURI();
    }

    @Override
    public Collection<URI> getResourceURIs() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Resource next : this.components) {
            result.add((Object)next.getURI());
        }
        return result.build();
    }

    @Override
    public Collection<IModelTransferNode> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    @Override
    public Collection<IModelTransferNode> getDependents() {
        return Collections.unmodifiableSet(this.dependents);
    }

    void addDependent(IModelTransferNode node) {
        this.dependents.add(node);
    }

    public int hashCode() {
        return this.getPrimaryResourceURI().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof IModelTransferNode && this.getPrimaryResourceURI().equals(((IModelTransferNode)obj).getPrimaryResourceURI());
    }

    public String toString() {
        return String.format("ModelTransferNode(%s)", this.getName());
    }

    void scanForComponents() {
        Resource self = this.getPrimaryResource();
        for (Resource next : DependencyAdapter.getDependencies(self)) {
            if (DependencyAdapter.getDIResource(next) != self) continue;
            this.components.add(next);
        }
    }

    void scanForDependencies() {
        URIConverter converter = this.resource.getResourceSet().getURIConverter();
        for (Resource component : this.components) {
            for (Resource xref : DependencyAdapter.getDependencies(component)) {
                IModelTransferNode node;
                URI primary = this.findPrimaryResource(xref.getURI(), converter);
                if (primary == null || !converter.exists(primary, null) || (node = this.config.getNode(primary)) == null || node.equals(this)) continue;
                this.dependencies.add(node);
            }
        }
    }

    private URI findPrimaryResource(URI componentURI, URIConverter converter) {
        URI result = null;
        URI candidate = componentURI.trimFileExtension().appendFileExtension("di");
        if (converter.exists(candidate, null)) {
            result = candidate;
        }
        return result;
    }

    @Override
    public boolean isModelParentUnit(IModelTransferNode other) {
        boolean result = false;
        block0: for (URI childURI : this.getResourceURIs()) {
            Resource child = this.config.getResourceSet().getResource(childURI, false);
            if (child == null) continue;
            for (EObject root : child.getContents()) {
                EObject container = root.eContainer();
                if (container == null) continue;
                URI uri = EcoreUtil.getURI((EObject)container).trimFragment();
                if (!other.getResourceURIs().contains(uri)) continue;
                result = true;
                break block0;
            }
        }
        return result;
    }

    @Override
    public boolean isModelSubUnit(IModelTransferNode other) {
        boolean result = false;
        block0: for (URI uri : other.getResourceURIs()) {
            Resource possibleChild = this.config.getResourceSet().getResource(uri, false);
            if (possibleChild == null) continue;
            for (EObject root : possibleChild.getContents()) {
                EObject container = root.eContainer();
                if (container == null) continue;
                URI parentURI = EcoreUtil.getURI((EObject)container).trimFragment();
                if (!this.getResourceURIs().contains(parentURI)) continue;
                result = true;
                break block0;
            }
        }
        return result;
    }
}

