/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.viewpoints.configuration.Category;
import org.eclipse.papyrus.infra.viewpoints.configuration.ModelRule;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusSyncTable;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusViewpoint;
import org.eclipse.papyrus.infra.viewpoints.policy.Activator;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.NotationUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.UnavailableViewPrototype;
import org.eclipse.swt.graphics.Image;

public abstract class ViewPrototype {
    public static final ViewPrototype UNAVAILABLE_VIEW = new UnavailableViewPrototype("View", "View");
    public static final ViewPrototype UNAVAILABLE_DIAGRAM = new UnavailableViewPrototype("Diagram", "Diagram");
    public static final ViewPrototype UNAVAILABLE_TABLE = new UnavailableViewPrototype("Table", "Table");
    protected static final String EXTENSION_ID = "org.eclipse.papyrus.infra.viewpoints.policy.viewType";
    private static final Collection<IViewTypeHelper> HELPERS = ViewPrototype.getCommandHelpers();
    protected final PapyrusView configuration;

    private static Collection<IViewTypeHelper> getCommandHelpers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] extensions = point.getExtensions();
        ArrayList<IViewTypeHelper> result = new ArrayList<IViewTypeHelper>();
        int i = 0;
        while (i != extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j != elements.length) {
                try {
                    IViewTypeHelper instance = (IViewTypeHelper)elements[j].createExecutableExtension("class");
                    if (instance != null) {
                        result.add(instance);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static boolean isNatural(PapyrusView config) {
        return config.getName() == null && config.getIcon() == null;
    }

    public static boolean isViewObject(EObject object) {
        for (IViewTypeHelper helper : HELPERS) {
            if (!helper.isSupported(object)) continue;
            return true;
        }
        return false;
    }

    public static ViewPrototype get(PapyrusView config) {
        for (IViewTypeHelper helper : HELPERS) {
            ViewPrototype proto;
            if (!helper.isSupported(config.eClass()) || (proto = helper.getPrototypeFor(config)) == null) continue;
            return proto;
        }
        if (config instanceof PapyrusDiagram) {
            return UNAVAILABLE_DIAGRAM;
        }
        if (config instanceof PapyrusTable) {
            return UNAVAILABLE_TABLE;
        }
        if (config instanceof PapyrusSyncTable) {
            return UNAVAILABLE_TABLE;
        }
        return UNAVAILABLE_VIEW;
    }

    public static ViewPrototype get(EObject view) {
        for (IViewTypeHelper helper : HELPERS) {
            ViewPrototype proto;
            if (!helper.isSupported(view) || (proto = helper.getPrototypeOf(view)) == null) continue;
            return proto;
        }
        return UNAVAILABLE_VIEW;
    }

    public static ViewPrototype get(String implem, EObject owner, EObject root) {
        PapyrusView view = PolicyChecker.getCurrent().getViewFrom(implem, owner, root);
        if (view == null) {
            return UNAVAILABLE_VIEW;
        }
        return ViewPrototype.get(view);
    }

    protected ViewPrototype(PapyrusView configuration) {
        this.configuration = configuration;
    }

    public PapyrusView getConfiguration() {
        return this.configuration;
    }

    public boolean isNatural() {
        return ViewPrototype.isNatural(this.configuration);
    }

    public boolean isUnavailable() {
        return false;
    }

    public String getImplementation() {
        return this.configuration.getImplementationID();
    }

    public String getLabel() {
        return this.configuration.getName();
    }

    public String getFullLabel() {
        StringBuilder builder = new StringBuilder(this.getLabel());
        builder.append(" for ");
        boolean first = true;
        for (ModelRule rule : this.configuration.getModelRules()) {
            if (rule.getStereotypes() != null && rule.getStereotypes().size() > 0) {
                for (EClass stereotype : rule.getStereotypes()) {
                    if (!first) {
                        builder.append(", ");
                        first = false;
                    }
                    builder.append(stereotype.getName());
                }
                continue;
            }
            if (rule.getElement() == null) continue;
            if (!first) {
                builder.append(", ");
                first = false;
            }
            builder.append(rule.getElement().getName());
        }
        return builder.toString();
    }

    public String getQualifiedName() {
        PapyrusViewpoint vp = (PapyrusViewpoint)this.configuration.eContainer();
        return String.valueOf(vp.getName()) + " :: " + this.getLabel();
    }

    public String getIconURI() {
        return this.configuration.getIcon();
    }

    public ImageDescriptor getIconDescriptor() {
        URL url = null;
        try {
            url = new URL(this.getIconURI());
        }
        catch (MalformedURLException e) {
            Activator.log.error("Cannot load icon at URI " + this.getIconURI(), (Throwable)e);
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    public Image getIcon() {
        return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(this.getIconDescriptor());
    }

    public Collection<Category> getCategories() {
        return this.configuration.getCategories();
    }

    public abstract boolean isOwnerReassignable();

    public abstract boolean instantiateOn(EObject var1);

    public abstract boolean instantiateOn(EObject var1, String var2);

    public abstract Command getCommandChangeOwner(EObject var1, EObject var2);

    public abstract Command getCommandChangeRoot(EObject var1, EObject var2);

    public abstract EObject getOwnerOf(EObject var1);

    public abstract EObject getRootOf(EObject var1);

    /*
     * Unable to fully structure code
     */
    public int getOwnedViewCount(EObject element) {
        count = 0;
        roots = NotationUtils.getNotationRoots(element);
        if (roots != null) ** GOTO lbl9
        return count;
lbl-1000:
        // 1 sources

        {
            view = roots.next();
            proto = ViewPrototype.get(view);
            if (this != proto || (owner = proto.getOwnerOf(view)) != element) continue;
            ++count;
lbl9:
            // 3 sources

            ** while (roots.hasNext())
        }
lbl10:
        // 1 sources

        return count;
    }

    /*
     * Unable to fully structure code
     */
    public int getViewCountOn(EObject element) {
        count = 0;
        roots = NotationUtils.getNotationRoots(element);
        if (roots != null) ** GOTO lbl9
        return count;
lbl-1000:
        // 1 sources

        {
            view = roots.next();
            proto = ViewPrototype.get(view);
            if (this != proto || (root = proto.getRootOf(view)) != element) continue;
            ++count;
lbl9:
            // 3 sources

            ** while (roots.hasNext())
        }
lbl10:
        // 1 sources

        return count;
    }

    public static class Comp
    implements Comparator<ViewPrototype> {
        private static final Map<Class<? extends PapyrusView>, Integer> priorities = new HashMap<Class<? extends PapyrusView>, Integer>();

        public Comp() {
            priorities.put(PapyrusDiagram.class, 1);
            priorities.put(PapyrusTable.class, 2);
            priorities.put(PapyrusSyncTable.class, 3);
        }

        private static Integer getPriority(ViewPrototype proto) {
            for (Map.Entry<Class<? extends PapyrusView>, Integer> entry : priorities.entrySet()) {
                if (!entry.getKey().isAssignableFrom(proto.configuration.getClass())) continue;
                return entry.getValue();
            }
            return 0;
        }

        @Override
        public int compare(ViewPrototype proto1, ViewPrototype proto2) {
            Integer p2;
            Integer p1 = Comp.getPriority(proto1);
            if (p1 == (p2 = Comp.getPriority(proto2))) {
                return proto1.getLabel().compareTo(proto2.getLabel());
            }
            return p1.compareTo(p2);
        }
    }
}

