/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.viewpoints.configuration.Category;
import org.eclipse.papyrus.infra.viewpoints.configuration.ModelRule;
import org.eclipse.papyrus.infra.viewpoints.configuration.OwningRule;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusViewpoint;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.swt.graphics.Image;

public class ViewPrototypeContentProvider
implements ITreeContentProvider {
    public static final Object treeRoot = new Object();
    private Map<Category, List<ViewPrototype>> views = new HashMap<Category, List<ViewPrototype>>();
    private List<Category> categories = new ArrayList<Category>();

    private static ImageDescriptor loadImage(String uri) {
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ImageDescriptor.createFromURL(url);
    }

    public ViewPrototypeContentProvider() {
        for (ViewPrototype view : PolicyChecker.getCurrent().getAllPrototypes()) {
            for (Category category : view.getCategories()) {
                if (!this.categories.contains(category)) {
                    this.categories.add(category);
                    this.views.put(category, new ArrayList());
                }
                this.views.get(category).add(view);
            }
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.categories.toArray();
    }

    private Object[] getChildren(ViewPrototype view) {
        if (view.getConfiguration() == null) {
            return new String[0];
        }
        ArrayList<EObject> data = new ArrayList<EObject>();
        data.add(view.getConfiguration().eContainer());
        data.addAll((Collection<EObject>)view.getConfiguration().getProfiles());
        data.addAll((Collection<EObject>)view.getConfiguration().getModelRules());
        data.addAll((Collection<EObject>)view.getConfiguration().getOwningRules());
        return data.toArray();
    }

    public Object[] getChildren(Object element) {
        if (element == treeRoot) {
            return this.categories.toArray();
        }
        if (element instanceof Category) {
            ArrayList protos = new ArrayList(this.views.get(element));
            Collections.sort(protos, new ViewPrototype.Comp());
            return protos.toArray();
        }
        if (element instanceof ViewPrototype) {
            return this.getChildren((ViewPrototype)element);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element == treeRoot) {
            return null;
        }
        if (element instanceof Category) {
            return treeRoot;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == treeRoot) {
            return true;
        }
        if (element instanceof Category) {
            return true;
        }
        return element instanceof ViewPrototype;
    }

    public static class LP
    extends LabelProvider {
        private static final String IMG_CATEGORY = "imageCategory";
        private static final String IMG_VIEWPOINT = "imageViewpoint";
        private static final String IMG_PROFILE = "imageProfile";
        private static final String IMG_MODEL = "imageModel";
        private static final String IMG_OWNER = "imageOwner";
        private ImageRegistry images = new ImageRegistry(JFaceResources.getResources());

        public LP() {
            this.images.put(IMG_CATEGORY, ViewPrototypeContentProvider.loadImage("platform:/plugin/org.eclipse.papyrus.infra.viewpoints.configuration.edit/icons/full/obj16/PapyrusView.png"));
            this.images.put(IMG_VIEWPOINT, ViewPrototypeContentProvider.loadImage("platform:/plugin/org.eclipse.papyrus.infra.viewpoints.configuration.edit/icons/full/obj16/PapyrusViewpoint.png"));
            this.images.put(IMG_PROFILE, ViewPrototypeContentProvider.loadImage("platform:/plugin/org.eclipse.papyrus.infra.viewpoints.policy/icons/Profile.gif"));
            this.images.put(IMG_MODEL, ViewPrototypeContentProvider.loadImage("platform:/plugin/org.eclipse.papyrus.infra.viewpoints.configuration.edit/icons/full/obj16/ModelRule.png"));
            this.images.put(IMG_OWNER, ViewPrototypeContentProvider.loadImage("platform:/plugin/org.eclipse.papyrus.infra.viewpoints.configuration.edit/icons/full/obj16/OwningRule.png"));
        }

        public void dispose() {
            super.dispose();
            this.images.dispose();
        }

        public String getText(Object element) {
            if (element instanceof Category) {
                return "Category " + ((Category)element).getName();
            }
            if (element instanceof ViewPrototype) {
                return ((ViewPrototype)element).getLabel();
            }
            if (element instanceof PapyrusViewpoint) {
                return "Available in viewpoint: " + ((PapyrusViewpoint)element).getName();
            }
            if (element instanceof EPackage) {
                return "Required profile: " + ((EPackage)element).getNsURI();
            }
            if (element instanceof ModelRule) {
                return this.getText((ModelRule)element);
            }
            if (element instanceof OwningRule) {
                return this.getText((OwningRule)element);
            }
            return element.toString();
        }

        private String getText(ModelRule rule) {
            StringBuilder builder = new StringBuilder("Possible root: ");
            boolean first = true;
            for (EClass ste : rule.getStereotypes()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("<<");
                builder.append(ste.getEPackage().getNsPrefix());
                builder.append("::");
                builder.append(ste.getName());
                builder.append(">>");
                first = false;
            }
            if (rule.getElement() != null) {
                if (!first) {
                    builder.append(" ");
                }
                builder.append(rule.getElement().getEPackage().getNsPrefix());
                builder.append("::");
                builder.append(rule.getElement().getName());
            }
            return builder.toString();
        }

        private String getText(OwningRule rule) {
            StringBuilder builder = new StringBuilder("Possible owner: ");
            boolean first = true;
            for (EClass ste : rule.getStereotypes()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("<<");
                builder.append(ste.getEPackage().getNsPrefix());
                builder.append("::");
                builder.append(ste.getName());
                builder.append(">>");
                first = false;
            }
            if (rule.getElement() != null) {
                if (!first) {
                    builder.append(" ");
                }
                builder.append(rule.getElement().getEPackage().getNsPrefix());
                builder.append("::");
                builder.append(rule.getElement().getName());
            }
            return builder.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof Category) {
                return this.images.get(IMG_CATEGORY);
            }
            if (element instanceof ViewPrototype) {
                return ((ViewPrototype)element).getIcon();
            }
            if (element instanceof PapyrusViewpoint) {
                return this.images.get(IMG_VIEWPOINT);
            }
            if (element instanceof EPackage) {
                return this.images.get(IMG_PROFILE);
            }
            if (element instanceof ModelRule) {
                return this.images.get(IMG_MODEL);
            }
            if (element instanceof OwningRule) {
                return this.images.get(IMG_OWNER);
            }
            return null;
        }
    }
}

