/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.nattableconfiguration.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.papyrus.customization.nattableconfiguration.helper.TableConfigurationHelper;
import org.eclipse.papyrus.customization.nattableconfiguration.messages.Messages;
import org.eclipse.papyrus.customization.nattableconfiguration.pages.AbstractTableConfigurationWizardPage;
import org.eclipse.papyrus.customization.nattableconfiguration.utils.NameSimplifier;
import org.eclipse.papyrus.customization.nattableconfiguration.utils.NattableConfigurationConstants;
import org.eclipse.papyrus.customization.nattableconfiguration.utils.NattableConfigurationEditingSupport;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.FeatureLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.NattablelabelproviderFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ObjectLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.OperationLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.impl.FeatureLabelProviderConfigurationImpl;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.impl.ObjectLabelProviderConfigurationImpl;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.impl.OperationLabelProviderConfigurationImpl;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class AbstractAxisConfigurationWizardPage
extends AbstractTableConfigurationWizardPage {
    protected final TableHeaderAxisConfiguration headerAxisConfiguration = this.getHeaderAxisConfiguration();
    protected Button addAxisManagerRepresentation;
    protected Button removeAxisManagerRepresentation;
    protected TableViewer labelProviderConfigurationTableViewer;

    public AbstractAxisConfigurationWizardPage(String pageName, TableConfigurationHelper helper) {
        super(pageName, helper);
    }

    public abstract TableHeaderAxisConfiguration getHeaderAxisConfiguration();

    public void createControl(Composite parent) {
        this.setPageComplete(this.isPageComplete());
        Composite container = new Composite(parent, 2048);
        container.setLayout((Layout)new GridLayout(1, false));
        Group axisManagersGroup = new Group(container, 0);
        axisManagersGroup.setText(Messages.AbstractAxisConfigurationWizardPage_axisManagersLabel);
        axisManagersGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        axisManagersGroup.setLayout((Layout)new GridLayout(2, false));
        final TableViewer axisManagerTableViewer = this.createAxisManagersTableViewer((Composite)axisManagersGroup);
        Composite buttonsComposite = new Composite((Composite)axisManagersGroup, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        buttonsComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.addAxisManagerRepresentation = new Button(buttonsComposite, 8);
        this.addAxisManagerRepresentation.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.addAxisManagerRepresentation.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        this.addAxisManagerRepresentation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AxisManagerRepresentation createRepresentation = AbstractAxisConfigurationWizardPage.this.createAxisManagerRepresentation();
                AbstractAxisConfigurationWizardPage.this.headerAxisConfiguration.getAxisManagers().add((Object)createRepresentation);
                AbstractAxisConfigurationWizardPage.this.manageLabelProviderConfiguration(createRepresentation);
                AbstractAxisConfigurationWizardPage.this.recalculateButtonsAvailability((ISelection)axisManagerTableViewer.getStructuredSelection());
                axisManagerTableViewer.refresh();
                AbstractAxisConfigurationWizardPage.this.setPageComplete(AbstractAxisConfigurationWizardPage.this.isPageComplete());
            }
        });
        this.removeAxisManagerRepresentation = new Button(buttonsComposite, 8);
        this.removeAxisManagerRepresentation.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.removeAxisManagerRepresentation.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        this.removeAxisManagerRepresentation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object selectedObject : axisManagerTableViewer.getStructuredSelection()) {
                    if (!(selectedObject instanceof AxisManagerRepresentation)) continue;
                    AxisManagerRepresentation axisManagerRepresentation = (AxisManagerRepresentation)selectedObject;
                    AbstractAxisConfigurationWizardPage.this.removeLabelProviderConfiguration(axisManagerRepresentation.getHeaderLabelConfiguration(), axisManagerRepresentation);
                    AbstractAxisConfigurationWizardPage.this.headerAxisConfiguration.getAxisManagers().remove((Object)axisManagerRepresentation);
                }
                AbstractAxisConfigurationWizardPage.this.recalculateButtonsAvailability((ISelection)axisManagerTableViewer.getStructuredSelection());
                axisManagerTableViewer.refresh();
                AbstractAxisConfigurationWizardPage.this.setPageComplete(AbstractAxisConfigurationWizardPage.this.isPageComplete());
            }
        });
        axisManagerTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractAxisConfigurationWizardPage.this.recalculateButtonsAvailability(event.getSelection());
            }
        });
        axisManagerTableViewer.setSelection((ISelection)new StructuredSelection());
        this.labelProviderConfigurationTableViewer = this.createLabelProviderConfigurationsTableViewer((Composite)axisManagersGroup);
        this.createMoreComposite(container);
        this.setControl((Control)container);
    }

    public AxisManagerRepresentation createAxisManagerRepresentation() {
        return NattableaxisconfigurationFactory.eINSTANCE.createAxisManagerRepresentation();
    }

    protected void recalculateButtonsAvailability(ISelection selection) {
        this.removeAxisManagerRepresentation.setEnabled(selection != null && !selection.isEmpty());
    }

    public void createMoreComposite(Composite parent) {
    }

    protected TableViewer createAxisManagersTableViewer(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 68356);
        this.createAxisManagersColumns(tableViewer);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setInput((Object)this.headerAxisConfiguration.getAxisManagers());
        tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        tableViewer.refresh();
        return tableViewer;
    }

    protected abstract void createAxisManagersColumns(TableViewer var1);

    protected TableViewer createLabelProviderConfigurationsTableViewer(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 68356);
        this.createLabelProviderConfigurationsColumns(tableViewer);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setInput((Object)this.headerAxisConfiguration.getOwnedLabelConfigurations());
        tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        tableViewer.refresh();
        return tableViewer;
    }

    protected void createLabelProviderConfigurationsColumns(TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        int[] bounds = new int[]{200, 125, 125, 125, 125, 125, 125};
        String[] titles = new String[]{Messages.AbstractAxisConfigurationWizardPage_labelProviderConfigurationColumnLabel, Messages.AbstractAxisConfigurationWizardPage_displayIconColumnLabel, Messages.AbstractAxisConfigurationWizardPage_displayLabelColumnLabel, Messages.AbstractAxisConfigurationWizardPage_displayNameColumnLabel, Messages.AbstractAxisConfigurationWizardPage_displayTypeColumnLabel, Messages.AbstractAxisConfigurationWizardPage_displayMultiplicityColumnLabel, Messages.AbstractAxisConfigurationWizardPage_displayIsDerivedColumnLabel};
        TableViewerColumn labelProviderConfigurationColumn = this.createTableViewerColumn(tableViewer, titles[0], bounds[0]);
        ColumnLabelProvider axisManagerIdLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                String className;
                String value = "";
                if (element instanceof ILabelProviderConfiguration && NameSimplifier.labelProviderConfigurationNames.containsKey(className = element.getClass().getSimpleName())) {
                    value = NameSimplifier.labelProviderConfigurationNames.get(className);
                }
                return value;
            }
        };
        labelProviderConfigurationColumn.setLabelProvider((CellLabelProvider)axisManagerIdLabelProvider);
        ColumnLabelProvider nullLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        };
        TableViewerColumn displayIconColumn = this.createTableViewerColumn(tableViewer, titles[1], bounds[1]);
        displayIconColumn.setLabelProvider((CellLabelProvider)nullLabelProvider);
        displayIconColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)nullLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                if (element instanceof ObjectLabelProviderConfiguration) {
                    ((ObjectLabelProviderConfiguration)element).setDisplayIcon(((Boolean)value).booleanValue());
                } else if (element instanceof FeatureLabelProviderConfiguration) {
                    ((FeatureLabelProviderConfiguration)element).setDisplayIcon(((Boolean)value).booleanValue());
                } else if (element instanceof OperationLabelProviderConfiguration) {
                    ((OperationLabelProviderConfiguration)element).setDisplayIcon(((Boolean)value).booleanValue());
                }
            }

            @Override
            protected Object getValue(Object element) {
                return AbstractAxisConfigurationWizardPage.this.isDisplayIcon(element);
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)table, 40);
            }
        });
        TableViewerColumn displayLabelColumn = this.createTableViewerColumn(tableViewer, titles[2], bounds[2]);
        displayLabelColumn.setLabelProvider((CellLabelProvider)nullLabelProvider);
        displayLabelColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)nullLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                if (element instanceof ObjectLabelProviderConfiguration) {
                    ((ObjectLabelProviderConfiguration)element).setDisplayLabel(((Boolean)value).booleanValue());
                } else if (element instanceof FeatureLabelProviderConfiguration) {
                    ((FeatureLabelProviderConfiguration)element).setDisplayLabel(((Boolean)value).booleanValue());
                } else if (element instanceof OperationLabelProviderConfiguration) {
                    ((OperationLabelProviderConfiguration)element).setDisplayLabel(((Boolean)value).booleanValue());
                }
            }

            @Override
            protected Object getValue(Object element) {
                return AbstractAxisConfigurationWizardPage.this.isDisplayLabel(element);
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)table, 40);
            }
        });
        TableViewerColumn displayNameColumn = this.createTableViewerColumn(tableViewer, titles[3], bounds[3]);
        displayNameColumn.setLabelProvider((CellLabelProvider)nullLabelProvider);
        displayNameColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)nullLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                if (element instanceof FeatureLabelProviderConfiguration) {
                    ((FeatureLabelProviderConfiguration)element).setDisplayName(((Boolean)value).booleanValue());
                } else if (element instanceof OperationLabelProviderConfiguration) {
                    ((OperationLabelProviderConfiguration)element).setDisplayName(((Boolean)value).booleanValue());
                }
            }

            @Override
            protected Object getValue(Object element) {
                return AbstractAxisConfigurationWizardPage.this.isDisplayName(element);
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)table, 40);
            }

            @Override
            protected boolean canEdit(Object element) {
                return element instanceof FeatureLabelProviderConfiguration || element instanceof OperationLabelProviderConfiguration;
            }
        });
        TableViewerColumn displayTypeColumn = this.createTableViewerColumn(tableViewer, titles[4], bounds[4]);
        displayTypeColumn.setLabelProvider((CellLabelProvider)nullLabelProvider);
        displayTypeColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)nullLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                if (element instanceof FeatureLabelProviderConfiguration) {
                    ((FeatureLabelProviderConfiguration)element).setDisplayType(((Boolean)value).booleanValue());
                } else if (element instanceof OperationLabelProviderConfiguration) {
                    ((OperationLabelProviderConfiguration)element).setDisplayType(((Boolean)value).booleanValue());
                }
            }

            @Override
            protected Object getValue(Object element) {
                return AbstractAxisConfigurationWizardPage.this.isDisplayType(element);
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)table, 40);
            }

            @Override
            protected boolean canEdit(Object element) {
                return element instanceof FeatureLabelProviderConfiguration || element instanceof OperationLabelProviderConfiguration;
            }
        });
        TableViewerColumn displayMultiplicityColumn = this.createTableViewerColumn(tableViewer, titles[5], bounds[5]);
        displayMultiplicityColumn.setLabelProvider((CellLabelProvider)nullLabelProvider);
        displayMultiplicityColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)nullLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                if (element instanceof FeatureLabelProviderConfiguration) {
                    ((FeatureLabelProviderConfiguration)element).setDisplayMultiplicity(((Boolean)value).booleanValue());
                } else if (element instanceof OperationLabelProviderConfiguration) {
                    ((OperationLabelProviderConfiguration)element).setDisplayMultiplicity(((Boolean)value).booleanValue());
                }
            }

            @Override
            protected Object getValue(Object element) {
                return AbstractAxisConfigurationWizardPage.this.isDisplayMultiplicity(element);
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)table, 40);
            }

            @Override
            protected boolean canEdit(Object element) {
                return element instanceof FeatureLabelProviderConfiguration || element instanceof OperationLabelProviderConfiguration;
            }
        });
        TableViewerColumn displayIsDerivedColumn = this.createTableViewerColumn(tableViewer, titles[6], bounds[6]);
        displayIsDerivedColumn.setLabelProvider((CellLabelProvider)nullLabelProvider);
        displayIsDerivedColumn.setEditingSupport((EditingSupport)new NattableConfigurationEditingSupport((ColumnViewer)tableViewer, (ILabelProvider)nullLabelProvider){

            @Override
            protected void setValue(Object element, Object value) {
                if (element instanceof FeatureLabelProviderConfiguration) {
                    ((FeatureLabelProviderConfiguration)element).setDisplayIsDerived(((Boolean)value).booleanValue());
                }
            }

            @Override
            protected Object getValue(Object element) {
                return AbstractAxisConfigurationWizardPage.this.isDisplayIsDerived(element);
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)table, 40);
            }

            @Override
            protected boolean canEdit(Object element) {
                return element instanceof FeatureLabelProviderConfiguration;
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index > 0) {
                    Item item = (Item)event.item;
                    Image trailingImage = null;
                    Object value = null;
                    switch (event.index) {
                        case 1: {
                            value = AbstractAxisConfigurationWizardPage.this.isDisplayIcon(item.getData());
                            break;
                        }
                        case 2: {
                            value = AbstractAxisConfigurationWizardPage.this.isDisplayLabel(item.getData());
                            break;
                        }
                        case 3: {
                            value = AbstractAxisConfigurationWizardPage.this.isDisplayName(item.getData());
                            break;
                        }
                        case 4: {
                            value = AbstractAxisConfigurationWizardPage.this.isDisplayType(item.getData());
                            break;
                        }
                        case 5: {
                            value = AbstractAxisConfigurationWizardPage.this.isDisplayMultiplicity(item.getData());
                            break;
                        }
                        case 6: {
                            value = AbstractAxisConfigurationWizardPage.this.isDisplayIsDerived(item.getData());
                            break;
                        }
                    }
                    if (value instanceof Boolean) {
                        Image image = trailingImage = (Boolean)value != false ? NattableConfigurationConstants.CHECKED : NattableConfigurationConstants.UNCHECKED;
                    }
                    if (trailingImage != null) {
                        int itemWidth = table.getColumn(event.index).getWidth();
                        int imageWidth = trailingImage.getBounds().width;
                        int x = event.x + (itemWidth - imageWidth) / 2;
                        int itemHeight = table.getItemHeight();
                        int imageHeight = trailingImage.getBounds().height;
                        int y = event.y + (itemHeight - imageHeight) / 2;
                        event.gc.drawImage(trailingImage, x, y);
                    }
                }
            }
        });
    }

    protected Object isDisplayIcon(Object element) {
        Boolean result = null;
        if (element instanceof ObjectLabelProviderConfiguration) {
            result = ((ObjectLabelProviderConfiguration)element).isDisplayIcon();
        } else if (element instanceof FeatureLabelProviderConfiguration) {
            result = ((FeatureLabelProviderConfiguration)element).isDisplayIcon();
        } else if (element instanceof OperationLabelProviderConfiguration) {
            result = ((OperationLabelProviderConfiguration)element).isDisplayIcon();
        }
        return result;
    }

    protected Object isDisplayLabel(Object element) {
        Boolean result = null;
        if (element instanceof ObjectLabelProviderConfiguration) {
            result = ((ObjectLabelProviderConfiguration)element).isDisplayLabel();
        } else if (element instanceof FeatureLabelProviderConfiguration) {
            result = ((FeatureLabelProviderConfiguration)element).isDisplayLabel();
        } else if (element instanceof OperationLabelProviderConfiguration) {
            result = ((OperationLabelProviderConfiguration)element).isDisplayLabel();
        }
        return result;
    }

    protected Object isDisplayName(Object element) {
        Boolean result = null;
        if (element instanceof FeatureLabelProviderConfiguration) {
            result = ((FeatureLabelProviderConfiguration)element).isDisplayName();
        } else if (element instanceof OperationLabelProviderConfiguration) {
            result = ((OperationLabelProviderConfiguration)element).isDisplayName();
        }
        return result;
    }

    protected Object isDisplayType(Object element) {
        Boolean result = null;
        if (element instanceof FeatureLabelProviderConfiguration) {
            result = ((FeatureLabelProviderConfiguration)element).isDisplayType();
        } else if (element instanceof OperationLabelProviderConfiguration) {
            result = ((OperationLabelProviderConfiguration)element).isDisplayType();
        }
        return result;
    }

    protected Object isDisplayMultiplicity(Object element) {
        Boolean result = null;
        if (element instanceof FeatureLabelProviderConfiguration) {
            result = ((FeatureLabelProviderConfiguration)element).isDisplayMultiplicity();
        } else if (element instanceof OperationLabelProviderConfiguration) {
            result = ((OperationLabelProviderConfiguration)element).isDisplayMultiplicity();
        }
        return result;
    }

    protected Object isDisplayIsDerived(Object element) {
        Boolean result = null;
        if (element instanceof FeatureLabelProviderConfiguration) {
            result = ((FeatureLabelProviderConfiguration)element).isDisplayIsDerived();
        }
        return result;
    }

    protected TableViewerColumn createTableViewerColumn(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(width);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    protected List<String> createAxisManagerIdItems(List<String> requiredProposedAxisManagers, Collection<String> knownAxis) {
        ArrayList<String> input = new ArrayList<String>();
        for (String requiredAxisManager : requiredProposedAxisManagers) {
            input.add(requiredAxisManager);
        }
        for (String knowAxis : knownAxis) {
            if (input.contains(knowAxis)) continue;
            input.add(knowAxis);
        }
        return input;
    }

    protected void manageLabelProviderConfiguration(AxisManagerRepresentation axisManagerRepresentation) {
        String axisManagerId = axisManagerRepresentation.getAxisManagerId();
        if (axisManagerId != null && !axisManagerId.isEmpty()) {
            if (axisManagerRepresentation.getHeaderLabelConfiguration() == null) {
                axisManagerRepresentation.setHeaderLabelConfiguration(this.createLabelProviderConfiguration(axisManagerId));
            } else {
                ILabelProviderConfiguration existingLabelProviderConfiguration = axisManagerRepresentation.getHeaderLabelConfiguration();
                String typeOfLabelProviderConfiguration = this.getTypeOfLabelProviderConfiguration(axisManagerId);
                if (!existingLabelProviderConfiguration.getClass().getSimpleName().equals(typeOfLabelProviderConfiguration)) {
                    this.removeLabelProviderConfiguration(existingLabelProviderConfiguration, axisManagerRepresentation);
                    axisManagerRepresentation.setHeaderLabelConfiguration(this.createLabelProviderConfiguration(axisManagerId));
                }
            }
        }
    }

    protected ILabelProviderConfiguration createLabelProviderConfiguration(String axisManagerId) {
        Object createdLabelProviderConfiguration = null;
        String typeOfLabelProviderConfiguration = this.getTypeOfLabelProviderConfiguration(axisManagerId);
        Iterator existingLabelProviderConfigurationsIterator = this.headerAxisConfiguration.getOwnedLabelConfigurations().iterator();
        while (existingLabelProviderConfigurationsIterator.hasNext() && createdLabelProviderConfiguration == null) {
            ILabelProviderConfiguration existingLabelProviderConfiguration = (ILabelProviderConfiguration)existingLabelProviderConfigurationsIterator.next();
            if (!existingLabelProviderConfiguration.getClass().getSimpleName().equals(typeOfLabelProviderConfiguration)) continue;
            createdLabelProviderConfiguration = existingLabelProviderConfiguration;
        }
        if (createdLabelProviderConfiguration == null) {
            createdLabelProviderConfiguration = FeatureLabelProviderConfigurationImpl.class.getSimpleName().equals(typeOfLabelProviderConfiguration) ? NattablelabelproviderFactory.eINSTANCE.createFeatureLabelProviderConfiguration() : (OperationLabelProviderConfigurationImpl.class.getSimpleName().equals(typeOfLabelProviderConfiguration) ? NattablelabelproviderFactory.eINSTANCE.createOperationLabelProviderConfiguration() : NattablelabelproviderFactory.eINSTANCE.createObjectLabelProviderConfiguration());
            this.headerAxisConfiguration.getOwnedLabelConfigurations().add(createdLabelProviderConfiguration);
            this.labelProviderConfigurationTableViewer.refresh();
        }
        return createdLabelProviderConfiguration;
    }

    protected void removeLabelProviderConfiguration(ILabelProviderConfiguration labelProviderConfiguration, AxisManagerRepresentation currentRepresentation) {
        if (labelProviderConfiguration != null) {
            boolean canBeRemoved = true;
            Iterator axisManagerIterator = this.headerAxisConfiguration.getAxisManagers().iterator();
            while (axisManagerIterator.hasNext() && canBeRemoved) {
                AxisManagerRepresentation axisManager = (AxisManagerRepresentation)axisManagerIterator.next();
                if (axisManager.equals(currentRepresentation)) continue;
                boolean bl = canBeRemoved = !labelProviderConfiguration.equals(axisManager.getHeaderLabelConfiguration());
            }
            if (canBeRemoved) {
                this.headerAxisConfiguration.getOwnedLabelConfigurations().remove((Object)labelProviderConfiguration);
                this.labelProviderConfigurationTableViewer.refresh();
            }
        }
    }

    protected String getTypeOfLabelProviderConfiguration(String axisManagerId) {
        String result = ObjectLabelProviderConfigurationImpl.class.getSimpleName();
        if (NameSimplifier.labelProviderConfigurationByAxisManager.containsKey(axisManagerId)) {
            result = NameSimplifier.labelProviderConfigurationByAxisManager.get(axisManagerId);
        }
        return result;
    }

    public boolean isPageComplete() {
        boolean isComplete = true;
        Iterator axisManagerIterator = this.headerAxisConfiguration.getAxisManagers().iterator();
        while (axisManagerIterator.hasNext() && isComplete) {
            AxisManagerRepresentation axisManager = (AxisManagerRepresentation)axisManagerIterator.next();
            boolean bl = isComplete = axisManager.getAxisManagerId() != null && !axisManager.getAxisManagerId().isEmpty() && axisManager.getLabelProviderContext() != null && !axisManager.getLabelProviderContext().isEmpty() && axisManager.getHeaderLabelConfiguration() != null;
        }
        return isComplete;
    }
}

