/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractAppliedStereotypeDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CommentShapeForAppliedStereotypeEditPolicy
extends AbstractAppliedStereotypeDisplayEditPolicy
implements IPapyrusListener {
    @Override
    protected Element getUMLElement() {
        Element element = null;
        if ((Element)this.getView().getElement() != null) {
            element = (Element)this.getView().getElement();
        } else {
            EObject object = NotationUtils.getEObjectValue((View)this.getView(), (String)"BASE_ELEMENT", null);
            if (object != null) {
                if (object instanceof Element) {
                    element = (Element)object;
                } else if (UMLUtil.getStereotype((EObject)object) != null) {
                    element = UMLUtil.getStereotype((EObject)object);
                }
            }
        }
        return element;
    }

    public Command getCommand(Request request) {
        if (request instanceof EditCommandRequestWrapper && ((EditCommandRequestWrapper)request).getEditCommandRequest() instanceof DestroyElementRequest) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCommand(request);
    }

    protected void refreshAppliedStereotypesPropertiesInBrace(IPapyrusNodeUMLElementFigure figure) {
        String toDisplayInBrace = this.helper.getStereotypePropertiesInBrace(((GraphicalEditPart)this.getHost()).getNotationView());
        if (!"".equals(toDisplayInBrace)) {
            figure.setStereotypePropertiesInBrace(toDisplayInBrace);
        } else {
            figure.setStereotypePropertiesInBrace(null);
        }
    }

    protected void executeAppliedStereotypeCommentDeletion(TransactionalEditingDomain domain, View commentNode) {
        if (commentNode != null && domain != null && TransactionUtil.getEditingDomain((EObject)commentNode) == domain) {
            DeleteCommand command = new DeleteCommand(commentNode);
            try {
                GMFUnsafe.write((TransactionalEditingDomain)domain, (ICommand)command);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    public void activate() {
        super.activate();
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.subscribe((EObject)view);
    }

    @Override
    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.unsubscribe((EObject)view);
    }

    @Override
    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected void refreshStereotypeDisplay() {
        View commentNode;
        IFigure figure = ((IPapyrusEditPart)this.getHost()).getPrimaryShape();
        if (figure instanceof IPapyrusNodeUMLElementFigure) {
            this.refreshAppliedStereotypesPropertiesInBrace((IPapyrusNodeUMLElementFigure)figure);
        }
        if ((commentNode = this.getView()) != null) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)commentNode);
            if (this.getUMLElement() == null) {
                this.executeAppliedStereotypeCommentDeletion(domain, commentNode);
            }
            if (commentNode.getSourceEdges().size() == 0 && commentNode.getTargetEdges().size() == 0) {
                this.executeAppliedStereotypeCommentDeletion(domain, commentNode);
            }
        }
    }

    @Override
    public void refreshDisplay() {
        this.refreshStereotypeDisplay();
    }
}

