/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.part;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.SynchronizableGmfDiagramEditor;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramVersioningUtils;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.contexts.IContextService;

public class UmlGmfDiagramEditor
extends SynchronizableGmfDiagramEditor {
    private Diagram diagram;
    private PartNameSynchronizer partNameSynchronizer;
    private ServicesRegistry servicesRegistry;

    public UmlGmfDiagramEditor(ServicesRegistry servicesRegistry, Diagram diagram) throws ServiceException {
        super(true);
        this.diagram = diagram;
        this.servicesRegistry = servicesRegistry;
        this.partNameSynchronizer = new PartNameSynchronizer(diagram);
        ISaveAndDirtyService saveAndDirtyService = (ISaveAndDirtyService)servicesRegistry.getService(ISaveAndDirtyService.class);
        saveAndDirtyService.registerIsaveablePart((ISaveablePart)this);
    }

    public void doSetInput(IEditorInput input, boolean releaseEditorContents) throws CoreException {
        super.doSetInput(input, releaseEditorContents);
        if (this.getDiagram() != null && !DiagramVersioningUtils.isOfCurrentPapyrusVersion((Diagram)this.getDiagram())) {
            new SynchronizableGmfDiagramEditor.ReconcileHelper(this.getEditingDomain()).reconcileDiagram(this.getDiagram());
        }
    }

    public void dispose() {
        this.setUndoContext(new IUndoContext(){

            public String getLabel() {
                return "Disposed undo context";
            }

            public boolean matches(IUndoContext context) {
                return false;
            }
        });
        super.dispose();
        try {
            ISaveAndDirtyService saveAndDirtyService = (ISaveAndDirtyService)this.servicesRegistry.getService(ISaveAndDirtyService.class);
            saveAndDirtyService.removeIsaveablePart((ISaveablePart)this);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.partNameSynchronizer = null;
        this.diagram = null;
        this.servicesRegistry = null;
    }

    public Object getAdapter(Class type) {
        if (type == ServicesRegistry.class) {
            return this.servicesRegistry;
        }
        return super.getAdapter(type);
    }

    protected void stopListening() {
        super.stopListening();
    }

    public ServicesRegistry getServicesRegistry() {
        return this.servicesRegistry;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
        this.partNameSynchronizer.setDiagram(diagram);
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    protected KeyHandler getKeyHandler() {
        KeyHandler keyHandler = new KeyHandler();
        return keyHandler;
    }

    public void createPartControl(Composite parent) {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("org.eclipse.gmf.runtime.diagram.ui.diagramContext");
        super.createPartControl(parent);
    }

    public class PartNameSynchronizer {
        Diagram diagram;
        private Adapter diagramNameListener = new Adapter(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(Diagram.class) == 11 && notification.getNotifier() == PartNameSynchronizer.this.diagram) {
                    UmlGmfDiagramEditor.this.setPartName(PartNameSynchronizer.this.diagram.getName());
                }
            }

            public Notifier getTarget() {
                return null;
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }
        };

        PartNameSynchronizer(Diagram diagram) {
            this.setDiagram(diagram);
        }

        public void setDiagram(Diagram diagram) {
            if (this.diagram != null) {
                diagram.eAdapters().remove((Object)this.diagramNameListener);
            }
            this.diagram = diagram;
            UmlGmfDiagramEditor.this.setPartName(diagram.getName());
            diagram.eAdapters().add((Object)this.diagramNameListener);
        }
    }
}

