/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Chokri MRAIDHA (CEA LIST) chokri.mraidha@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.DataPool;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.DataPoolOrderingKind;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.GCMPackage;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Property;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data Pool</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.impl.DataPoolImpl#getOrdering <em>Ordering</em>}</li>
 * <li>{@link org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.impl.DataPoolImpl#getBase_Property <em>Base Property</em>}</li>
 * <li>{@link org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.impl.DataPoolImpl#getInsertion <em>Insertion</em>}</li>
 * <li>{@link org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.impl.DataPoolImpl#getSelection <em>Selection</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DataPoolImpl extends EObjectImpl implements DataPool {
	/**
	 * The default value of the '{@link #getOrdering() <em>Ordering</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getOrdering()
	 * @generated
	 * @ordered
	 */
	protected static final DataPoolOrderingKind ORDERING_EDEFAULT = DataPoolOrderingKind.FIFO;

	/**
	 * The cached value of the '{@link #getOrdering() <em>Ordering</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getOrdering()
	 * @generated
	 * @ordered
	 */
	protected DataPoolOrderingKind ordering = ORDERING_EDEFAULT;

	/**
	 * The cached value of the '{@link #getBase_Property() <em>Base Property</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getBase_Property()
	 * @generated
	 * @ordered
	 */
	protected Property base_Property;

	/**
	 * The cached value of the '{@link #getInsertion() <em>Insertion</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getInsertion()
	 * @generated
	 * @ordered
	 */
	protected Behavior insertion;

	/**
	 * The cached value of the '{@link #getSelection() <em>Selection</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getSelection()
	 * @generated
	 * @ordered
	 */
	protected Behavior selection;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected DataPoolImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GCMPackage.Literals.DATA_POOL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public DataPoolOrderingKind getOrdering() {
		return ordering;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setOrdering(DataPoolOrderingKind newOrdering) {
		DataPoolOrderingKind oldOrdering = ordering;
		ordering = newOrdering == null ? ORDERING_EDEFAULT : newOrdering;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, GCMPackage.DATA_POOL__ORDERING, oldOrdering, ordering));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Property getBase_Property() {
		if (base_Property != null && base_Property.eIsProxy()) {
			InternalEObject oldBase_Property = (InternalEObject) base_Property;
			base_Property = (Property) eResolveProxy(oldBase_Property);
			if (base_Property != oldBase_Property) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, GCMPackage.DATA_POOL__BASE_PROPERTY, oldBase_Property, base_Property));
				}
			}
		}
		return base_Property;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public Property basicGetBase_Property() {
		return base_Property;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setBase_Property(Property newBase_Property) {
		Property oldBase_Property = base_Property;
		base_Property = newBase_Property;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, GCMPackage.DATA_POOL__BASE_PROPERTY, oldBase_Property, base_Property));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Behavior getInsertion() {
		if (insertion != null && insertion.eIsProxy()) {
			InternalEObject oldInsertion = (InternalEObject) insertion;
			insertion = (Behavior) eResolveProxy(oldInsertion);
			if (insertion != oldInsertion) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, GCMPackage.DATA_POOL__INSERTION, oldInsertion, insertion));
				}
			}
		}
		return insertion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public Behavior basicGetInsertion() {
		return insertion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setInsertion(Behavior newInsertion) {
		Behavior oldInsertion = insertion;
		insertion = newInsertion;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, GCMPackage.DATA_POOL__INSERTION, oldInsertion, insertion));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Behavior getSelection() {
		if (selection != null && selection.eIsProxy()) {
			InternalEObject oldSelection = (InternalEObject) selection;
			selection = (Behavior) eResolveProxy(oldSelection);
			if (selection != oldSelection) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, GCMPackage.DATA_POOL__SELECTION, oldSelection, selection));
				}
			}
		}
		return selection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public Behavior basicGetSelection() {
		return selection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setSelection(Behavior newSelection) {
		Behavior oldSelection = selection;
		selection = newSelection;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, GCMPackage.DATA_POOL__SELECTION, oldSelection, selection));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case GCMPackage.DATA_POOL__ORDERING:
			return getOrdering();
		case GCMPackage.DATA_POOL__BASE_PROPERTY:
			if (resolve) {
				return getBase_Property();
			}
			return basicGetBase_Property();
		case GCMPackage.DATA_POOL__INSERTION:
			if (resolve) {
				return getInsertion();
			}
			return basicGetInsertion();
		case GCMPackage.DATA_POOL__SELECTION:
			if (resolve) {
				return getSelection();
			}
			return basicGetSelection();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case GCMPackage.DATA_POOL__ORDERING:
			setOrdering((DataPoolOrderingKind) newValue);
			return;
		case GCMPackage.DATA_POOL__BASE_PROPERTY:
			setBase_Property((Property) newValue);
			return;
		case GCMPackage.DATA_POOL__INSERTION:
			setInsertion((Behavior) newValue);
			return;
		case GCMPackage.DATA_POOL__SELECTION:
			setSelection((Behavior) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case GCMPackage.DATA_POOL__ORDERING:
			setOrdering(ORDERING_EDEFAULT);
			return;
		case GCMPackage.DATA_POOL__BASE_PROPERTY:
			setBase_Property((Property) null);
			return;
		case GCMPackage.DATA_POOL__INSERTION:
			setInsertion((Behavior) null);
			return;
		case GCMPackage.DATA_POOL__SELECTION:
			setSelection((Behavior) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case GCMPackage.DATA_POOL__ORDERING:
			return ordering != ORDERING_EDEFAULT;
		case GCMPackage.DATA_POOL__BASE_PROPERTY:
			return base_Property != null;
		case GCMPackage.DATA_POOL__INSERTION:
			return insertion != null;
		case GCMPackage.DATA_POOL__SELECTION:
			return selection != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (ordering: ");
		result.append(ordering);
		result.append(')');
		return result.toString();
	}

} // DataPoolImpl
