/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.ci;

import com.google.common.html.HtmlEscapers;
import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.utils.MapOnce;
import org.eclipse.packagedrone.web.common.table.TableColumn;
import org.eclipse.packagedrone.web.common.table.TableColumnProvider;
import org.eclipse.packagedrone.web.common.table.TableDescriptor;
import org.eclipse.packagedrone.web.common.table.TableExtender;

public class BuildUrlExtender
implements TableExtender {
    private static final TableColumn COLUMN_URL = new TableColumn("ci-link", -10000, "CI", "Continous Integration");
    private static final MetaKey KEY_JENKINS_NUMBER = new MetaKey("jenkins", "buildNumber");
    private static final MetaKey KEY_JENKINS_JOB_NAME = new MetaKey("jenkins", "jobName");
    private static final MetaKey KEY_JENKINS_URL = new MetaKey("jenkins", "buildUrl");
    private static final String SERVER_NAME_JENKINS = "Jenkins";
    private static final MetaKey KEY_HUDSON_NUMBER = new MetaKey("hudson", "buildNumber");
    private static final MetaKey KEY_HUDSON_URL = new MetaKey("hudson", "buildUrl");
    private static final MetaKey KEY_HUDSON_JOB_NAME = new MetaKey("hudson", "jobName");
    private static final String SERVER_NAME_HUDSON = "Hudson";
    private static final MetaKey KEY_TRAVIS_REPO = new MetaKey("travis", "repoSlug");
    private static final MetaKey KEY_TRAVIS_JOB_ID = new MetaKey("travis", "jobId");
    private static final MetaKey KEY_TRAVIS_JOB_NUMBER = new MetaKey("travis", "jobNumber");
    private static final String SERVER_NAME_TRAVIS = "Travis CI";

    public void getColumns(HttpServletRequest request, TableDescriptor descriptor, Consumer<TableColumnProvider> columnReceiver) {
        if (!descriptor.hasTag("artifacts")) {
            return;
        }
        columnReceiver.accept(TableColumnProvider.stringProvider((TableColumn)COLUMN_URL, ArtifactInformation.class, BuildUrlExtender::buildLink));
    }

    protected static String buildLink(ArtifactInformation art) {
        if (art == null) {
            return null;
        }
        MapOnce map = new MapOnce((Object)art);
        map.map(BuildUrlExtender::fromHudson);
        map.map(BuildUrlExtender::fromJenkins);
        map.map(BuildUrlExtender::fromTravis);
        return map.get().orElse(null);
    }

    protected static Optional<String> fromJenkins(ArtifactInformation art) {
        return BuildUrlExtender.fromUrlAndNumber(art, KEY_JENKINS_URL, KEY_JENKINS_NUMBER, KEY_JENKINS_JOB_NAME, SERVER_NAME_JENKINS);
    }

    protected static Optional<String> fromHudson(ArtifactInformation art) {
        return BuildUrlExtender.fromUrlAndNumber(art, KEY_HUDSON_URL, KEY_HUDSON_NUMBER, KEY_HUDSON_JOB_NAME, SERVER_NAME_HUDSON);
    }

    private static Optional<String> makeUrl(String serverName, Supplier<String> urlProvider, Supplier<String> labelProvider, Supplier<String> titleProvider) {
        String label;
        String url;
        try {
            url = urlProvider.get();
            if (url == null || url.isEmpty()) {
                return Optional.empty();
            }
            new URI(url);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
        try {
            label = labelProvider.get();
        }
        catch (Exception exception) {
            return Optional.empty();
        }
        if (label == null || label.isEmpty()) {
            return Optional.empty();
        }
        String title = null;
        try {
            title = titleProvider.get();
        }
        catch (Exception exception) {}
        StringBuilder sb = new StringBuilder();
        sb.append("<a target=\"_blank\" href=\"").append(url).append("\"");
        if (title != null && !title.isEmpty()) {
            sb.append(" title=\"");
            sb.append(HtmlEscapers.htmlEscaper().escape(title));
            sb.append("\"");
        } else {
            sb.append(String.format("title=\"%s build link\"", serverName));
        }
        sb.append(">");
        sb.append(HtmlEscapers.htmlEscaper().escape(label));
        sb.append("</a>");
        return Optional.of(sb.toString());
    }

    private static Optional<String> fromUrlAndNumber(ArtifactInformation art, MetaKey keyUrl, MetaKey keyNumber, MetaKey keyJobName, String serverName) {
        return BuildUrlExtender.makeUrl(serverName, () -> (String)art.getMetaData().get(keyUrl), () -> String.format("#%d", Long.parseLong((String)art.getMetaData().get(keyNumber))), () -> {
            Optional<String> jobName = Optional.ofNullable((String)art.getMetaData().get(keyJobName));
            return jobName.map(name -> String.format("Build #%s of job '%s' on %s", name, serverName)).orElse(null);
        });
    }

    private static Optional<String> fromTravis(ArtifactInformation art) {
        return BuildUrlExtender.makeUrl(SERVER_NAME_TRAVIS, () -> {
            String repo = (String)art.getMetaData().get(KEY_TRAVIS_REPO);
            if (repo == null || repo.isEmpty()) {
                return null;
            }
            return String.format("https://travis-ci.org/%s/jobs/%s", repo, art.getMetaData().get(KEY_TRAVIS_JOB_ID));
        }, () -> {
            Optional<String> jobNumber = Optional.ofNullable((String)art.getMetaData().get(KEY_TRAVIS_JOB_NUMBER));
            return jobNumber.map(name -> "#" + name).orElse(null);
        }, () -> {
            Optional<String> jobName = Optional.ofNullable((String)art.getMetaData().get(KEY_TRAVIS_JOB_NUMBER));
            return jobName.map(name -> String.format("%s job #%s of repository %s", SERVER_NAME_TRAVIS, name, art.getMetaData().get(KEY_TRAVIS_REPO))).orElse(null);
        });
    }
}

